/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Stack;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.Tapestry;

public abstract class AbstractMarkupWriter
implements IMarkupWriter {
    private PrintWriter _writer;
    private boolean _openTag = false;
    private boolean _emptyTag = false;
    private Stack _activeElementStack;
    private int _depth = 0;
    private char[] _buffer;
    private String[] _entities;
    private boolean[] _safe;
    private String _contentType;

    public String getContentType() {
        return this._contentType;
    }

    public abstract IMarkupWriter getNestedWriter();

    protected AbstractMarkupWriter(boolean[] safe, String[] entities, String contentType, OutputStream stream) {
        this(safe, entities, contentType);
        this._writer = new PrintWriter(stream);
    }

    protected AbstractMarkupWriter(boolean[] safe, String[] entities, String contentType) {
        this._entities = entities;
        this._safe = safe;
        this._contentType = contentType;
        if (entities == null || safe == null || contentType == null) {
            throw new IllegalArgumentException(Tapestry.getString("AbstractMarkupWriter.missing-constructor-parameters"));
        }
    }

    protected void setWriter(PrintWriter writer) {
        this._writer = writer;
    }

    public void attribute(String name) {
        this.attribute(name, name);
    }

    public void attribute(String name, int value) {
        this.checkTagOpen();
        this._writer.print(' ');
        this._writer.print(name);
        this._writer.print("=\"");
        this._writer.print(value);
        this._writer.print('\"');
    }

    public void attribute(String name, String value) {
        this.checkTagOpen();
        this._writer.print(' ');
        this._writer.print(name);
        this._writer.print("=\"");
        if (value == null) {
            this._writer.print(name);
        } else {
            int length = value.length();
            if (this._buffer == null || this._buffer.length < length) {
                this._buffer = new char[length];
            }
            value.getChars(0, length, this._buffer, 0);
            this.safePrint(this._buffer, 0, length, true);
        }
        this._writer.print('\"');
    }

    public void begin(String name) {
        if (this._openTag) {
            this.closeTag();
        }
        this.push(name);
        this._writer.print('<');
        this._writer.print(name);
        this._openTag = true;
        this._emptyTag = false;
    }

    public void beginEmpty(String name) {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print('<');
        this._writer.print(name);
        this._openTag = true;
        this._emptyTag = true;
    }

    public boolean checkError() {
        return this._writer.checkError();
    }

    private void checkTagOpen() {
        if (!this._openTag) {
            throw new IllegalStateException(Tapestry.getString("AbstractMarkupWriter.tag-not-open"));
        }
    }

    public void close() {
        if (this._openTag) {
            this.closeTag();
        }
        while (this._depth > 0) {
            this._writer.print("</");
            this._writer.print(this.pop());
            this._writer.print('>');
        }
        this._writer.close();
        this._writer = null;
        this._activeElementStack = null;
        this._buffer = null;
    }

    public void closeTag() {
        if (this._emptyTag) {
            this._writer.print('/');
        }
        this._writer.print('>');
        this._openTag = false;
        this._emptyTag = false;
    }

    public void comment(String value) {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print("<!-- ");
        this._writer.print(value);
        this._writer.println(" -->");
    }

    public void end() {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print("</");
        this._writer.print(this.pop());
        this._writer.print('>');
    }

    public void end(String name) {
        String tagName;
        if (this._openTag) {
            this.closeTag();
        }
        do {
            tagName = this.pop();
            this._writer.print("</");
            this._writer.print(tagName);
            this._writer.print('>');
        } while (!tagName.equals(name));
    }

    public void flush() {
        this._writer.flush();
    }

    protected final String pop() {
        String result = (String)this._activeElementStack.pop();
        --this._depth;
        return result;
    }

    public void print(char[] data, int offset, int length) {
        if (data == null) {
            return;
        }
        if (this._openTag) {
            this.closeTag();
        }
        this.safePrint(data, offset, length, false);
    }

    public void print(char value) {
        if (this._openTag) {
            this.closeTag();
        }
        if (value < this._safe.length && this._safe[value]) {
            this._writer.print(value);
            return;
        }
        String entity = null;
        if (value < this._entities.length) {
            entity = this._entities[value];
        }
        if (entity != null) {
            this._writer.print(entity);
            return;
        }
        this._writer.print("&#" + value + ";");
    }

    public void print(int value) {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print(value);
    }

    public void print(String value) {
        if (value == null) {
            return;
        }
        int length = value.length();
        if (this._buffer == null || this._buffer.length < length) {
            this._buffer = new char[length];
        }
        value.getChars(0, length, this._buffer, 0);
        this.print(this._buffer, 0, length);
    }

    public void println() {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.println();
    }

    public void printRaw(char[] buffer, int offset, int length) {
        if (buffer == null) {
            return;
        }
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.write(buffer, offset, length);
    }

    public void printRaw(String value) {
        if (value == null) {
            return;
        }
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print(value);
    }

    protected final void push(String name) {
        if (this._activeElementStack == null) {
            this._activeElementStack = new Stack();
        }
        this._activeElementStack.push(name);
        ++this._depth;
    }

    private void safePrint(char[] data, int offset, int length, boolean isAttribute) {
        int safelength = 0;
        int start = offset;
        int i = 0;
        while (i < length) {
            boolean isSafe;
            char ch = data[offset + i];
            boolean bl = isSafe = ch < this._safe.length && this._safe[ch];
            if (isAttribute && ch == '\"') {
                isSafe = false;
            }
            if (isSafe) {
                ++safelength;
            } else {
                if (safelength > 0) {
                    this._writer.write(data, start, safelength);
                }
                String entity = null;
                if (ch < this._entities.length) {
                    entity = this._entities[ch];
                }
                if (entity == null) {
                    entity = "&#" + ch + ";";
                }
                this._writer.print(entity);
                start = offset + i + 1;
                safelength = 0;
            }
            ++i;
        }
        if (safelength > 0) {
            this._writer.write(data, start, safelength);
        }
    }
}

