/*
 * Decompiled with CFR 0.152.
 */
package studio.clashbuddy.clashaccess.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import studio.clashbuddy.clashaccess.properties.AccessCredential;

@Component
@ConfigurationProperties(prefix="clashbuddy.clashaccess.application")
public class ClashBuddySecurityClashAccessAppProperties {
    private AccessCredential access = new AccessCredential();
    private boolean enabled = true;
    private boolean scan = true;

    public ClashBuddySecurityClashAccessAppProperties() {
        this.setDefaults();
    }

    public void setAccess(AccessCredential access) {
        this.access = access;
    }

    public String getApiKey() {
        return this.access.getKey();
    }

    public String getEndpointMetadata() {
        return this.access.getEndpoint();
    }

    public boolean isNotChanged() {
        if (this.access == null) {
            return true;
        }
        return this.getEndpointMetadata().equalsIgnoreCase(this.access.getEndpoint()) && this.getDefaultApiKey().equalsIgnoreCase(this.access.getKey());
    }

    public String getDefaultEndpoint() {
        return "/clashbuddy-clash-access/endpoint-metadata";
    }

    public String getDefaultApiKey() {
        return "access";
    }

    public void setDefaults() {
        this.access.setEndpoint(this.getDefaultEndpoint());
        this.access.setKey(this.getDefaultApiKey());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isScan() {
        return this.scan;
    }

    public void setScan(boolean scan) {
        this.scan = scan;
    }
}

