/*
 * Decompiled with CFR 0.152.
 */
package studio.clashbuddy.clashaccess.gateway;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import studio.clashbuddy.clashaccess.metadata.ClashScannedEndpointMetadata;
import studio.clashbuddy.clashaccess.properties.AccessCredential;
import studio.clashbuddy.clashaccess.properties.ClashBuddyClashAccessProperties;
import studio.clashbuddy.clashaccess.properties.ClashBuddySecurityClashAccessGatewayProperties;
import studio.clashbuddy.clashaccess.properties.ServiceType;

@Component
public class LoadedServicesEndpointsRegistry {
    private final ClashBuddyClashAccessProperties clashBuddyClashAccessProperties;
    private final Map<String, ClashScannedEndpointMetadata> endpointMetadataHashMap = new HashMap<String, ClashScannedEndpointMetadata>();
    private final ClashBuddySecurityClashAccessGatewayProperties clashAccessGatewayProperties;
    private final Logger logger = LoggerFactory.getLogger(LoadedServicesEndpointsRegistry.class);

    public LoadedServicesEndpointsRegistry(ClashBuddySecurityClashAccessGatewayProperties clashAccessGatewayProperties, ClashBuddyClashAccessProperties clashBuddyClashAccessProperties) {
        this.clashAccessGatewayProperties = clashAccessGatewayProperties;
        this.clashBuddyClashAccessProperties = clashBuddyClashAccessProperties;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void onStartup() {
        if (this.clashBuddyClashAccessProperties.getServiceType().equals((Object)ServiceType.APPLICATION)) {
            return;
        }
        this.logger.info("\u2705 ClashAccess started in GATEWAY mode \u2014 loading metadata from configured services...");
        this.loadEndpointMetadata();
    }

    public boolean isPublicEndpoint(String endpoint) {
        if (this.clashBuddyClashAccessProperties.getServiceType().equals((Object)ServiceType.APPLICATION)) {
            throw new IllegalStateException("\u274c Invalid usage: this method is only intended for API Gateway services.\n\ud83d\udd27 To fix this, set the correct service type in your configuration:\n\n   clashbuddy.clashaccess.application.scan=true\n\n\ud83d\udeab Current context: 'application'\n\u2705 Allowed context: 'gateway'");
        }
        ClashScannedEndpointMetadata metadata = this.endpointMetadataHashMap.get(endpoint);
        if (metadata == null) {
            return true;
        }
        return metadata.isPublic();
    }

    private void loadEndpointMetadata() {
        if (this.clashAccessGatewayProperties.getAccesses().isEmpty()) {
            return;
        }
        RestTemplate restTemplate = new RestTemplate();
        String accessType = this.clashAccessGatewayProperties.getAccessType().getAccessType();
        for (AccessCredential access : this.clashAccessGatewayProperties.getAccesses()) {
            String url = access.getEndpoint() + "?key=" + access.getKey() + "&p=" + accessType;
            try {
                List results = (List)restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<ClashScannedEndpointMetadata>>(){}, new Object[0]).getBody();
                if (results == null) {
                    this.logger.error("\u274c Failed to load metadata from service:\n\ud83d\udd17 Endpoint: {}\n\ud83d\udd11 Access Key: {}\n\ud83d\udced Response was null. Make sure the service is UP and responds with a JSON body of metadata.", (Object)access.getEndpoint(), (Object)access.getKey());
                    continue;
                }
                for (ClashScannedEndpointMetadata metadata : results) {
                    this.endpointMetadataHashMap.computeIfPresent(metadata.getMainEndpoint(), (k, v) -> {
                        String message = String.format("\u274c ClashAccess Error: Duplicate endpoint detected during metadata load!\n\n\ud83d\udd01 Endpoint: '%s'\n\ud83d\udd12 Already registered by: %s (Service Key: %s)\n\ud83d\udea8 Conflicting with: %s (Service Key: %s)\n\n\ud83d\udc49 Please ensure each service exposes unique main endpoints to avoid collision.", k, v.getFullControllerName(), v.getContextPath(), metadata.getFullControllerName(), access.getKey());
                        throw new IllegalStateException(message);
                    });
                    this.endpointMetadataHashMap.put(metadata.getMainEndpoint(), metadata);
                }
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.error("\u274c Failed to fetch metadata from service:\n\ud83d\udd17 Endpoint: {}\n\ud83d\udd11 Access Key: {}\n\ud83d\udca5 Reason: {}\n", new Object[]{access.getEndpoint(), access.getKey(), e.getMessage()});
            }
        }
    }
}

