/*
 * Decompiled with CFR 0.152.
 */
package studio.clashbuddy.clashaccess.exceptions;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.util.HashMap;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import studio.clashbuddy.clashaccess.exceptions.ClashAccessDeniedException;

@ControllerAdvice
public class ClashAccessExceptionHandler {
    @ExceptionHandler(value={ClashAccessDeniedException.class})
    public ResponseEntity<?> handleAccessDenied(ClashAccessDeniedException ex, HttpServletRequest request) {
        HttpStatus status = HttpStatus.valueOf((int)ex.getStatus());
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("status", status.value());
        body.put("error", status);
        body.put("message", ex.getMessage());
        body.put("path", request.getRequestURI());
        body.put("timestamp", Instant.now().toString());
        return ResponseEntity.status((HttpStatusCode)status).body(body);
    }
}

