/*
 * Decompiled with CFR 0.152.
 */
package studio.clashbuddy.clashaccess.security;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.StringUtils;
import studio.clashbuddy.clashaccess.exceptions.ClashAccessDeniedException;
import studio.clashbuddy.clashaccess.security.AuthorizedUser;

class AccessValidator {
    AccessValidator() {
    }

    public static AuthorizedUser validateOneRoleAndPermissions(HttpServletRequest request, String[] expectedRoles, String[] excludedRoles, String[] expectedPermissions, String[] excludedPermissions, String[] extraSecurityAttributes) {
        AuthorizedUser authorizedUser = AccessValidator.validateAndGetAuthorizedUser(request, extraSecurityAttributes);
        Set<String> userRoles = authorizedUser.getRoles();
        Set<String> userPermissions = authorizedUser.getPermissions();
        AccessValidator.validateRolesOrPermissions(expectedRoles, userRoles, "role", true);
        AccessValidator.validateRolesOrPermissions(expectedPermissions, userPermissions, "permission", true);
        AccessValidator.validateRolesOrPermissions(excludedRoles, userRoles, "role", false);
        AccessValidator.validateRolesOrPermissions(excludedPermissions, userPermissions, "permission", false);
        return authorizedUser;
    }

    private static void validateRolesOrPermissions(String[] expected, Set<String> available, String message, boolean isExpected) {
        if (expected.length == 0) {
            return;
        }
        boolean isContained = Arrays.stream(expected).anyMatch(req -> available.stream().anyMatch(a -> a.equalsIgnoreCase((String)req)));
        if (isExpected && !isContained) {
            throw new ClashAccessDeniedException("Access Denied: Required " + message + " not found", 403);
        }
        if (!isExpected && isContained) {
            throw new ClashAccessDeniedException("Access Denied: " + message + " is explicitly excluded", 403);
        }
    }

    private static AuthorizedUser validateAndGetAuthorizedUser(HttpServletRequest request, String[] extraSecurityAttributes) {
        AccessValidator.validateHeader(request);
        String headerUserId = Objects.requireNonNull(request.getHeader("x-ca-uid"));
        HashSet<String> headerUserPermissions = new HashSet<String>();
        HashSet<String> headerUserRoles = new HashSet<String>();
        AccessValidator.fillFillableList(request, headerUserPermissions, "x-ca-ups");
        AccessValidator.fillFillableList(request, headerUserRoles, "x-ca-urs");
        return new AuthorizedUser(headerUserId, headerUserRoles, headerUserPermissions);
    }

    private static void fillFillableList(HttpServletRequest request, Set<String> fillable, String headerKey) {
        if (!StringUtils.hasText((String)request.getHeader(headerKey))) {
            return;
        }
        request.getHeaders(headerKey).asIterator().forEachRemaining(data -> {
            try {
                fillable.add((String)data);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        });
    }

    private static void validateHeader(HttpServletRequest request) {
        if (!StringUtils.hasText((String)request.getHeader("x-ca-uid"))) {
            throw new ClashAccessDeniedException("Missing middle layer user id header", 403);
        }
        if (!StringUtils.hasText((String)request.getHeader("x-ca-ups"))) {
            throw new ClashAccessDeniedException("Missing middle layer user permission header", 403);
        }
        if (!StringUtils.hasText((String)request.getHeader("x-ca-urs"))) {
            throw new ClashAccessDeniedException("Missing middle layer user roles header", 403);
        }
    }
}

