/*
 * Decompiled with CFR 0.152.
 */
package studio.clashbuddy.clashaccess.metadata;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import studio.clashbuddy.clashaccess.metadata.ClashScannedEndpointMetadata;
import studio.clashbuddy.clashaccess.metadata.OrganizedEndpoints;
import studio.clashbuddy.clashaccess.properties.ClashBuddySecurityClashAccessAppProperties;

@Component
class ScannedMetadataEndpoints {
    private final Set<ClashScannedEndpointMetadata> endpoints = new HashSet<ClashScannedEndpointMetadata>();
    private boolean loaded = false;
    private final ClashBuddySecurityClashAccessAppProperties clashBuddySecurityClashAccessAppProperties;

    public ScannedMetadataEndpoints(ClashBuddySecurityClashAccessAppProperties clashBuddySecurityClashAccessAppProperties) {
        this.clashBuddySecurityClashAccessAppProperties = clashBuddySecurityClashAccessAppProperties;
    }

    public Set<ClashScannedEndpointMetadata> getMetaEndpoints() {
        if (!this.clashBuddySecurityClashAccessAppProperties.isScan()) {
            throw new IllegalStateException("\u274c ClashAccess scanning is disabled.\n\ud83d\udd27 To enable endpoint scanning, set the following property in your configuration:\n\n    clashbuddy.clashaccess.application.scan=true\n\n\ud83d\udcc4 Location: application.yml or application.properties");
        }
        return this.endpoints;
    }

    public Set<OrganizedEndpoints> getOrganizedMetadataEndpoint() {
        Map<String, List<ClashScannedEndpointMetadata>> organizedEndpointsGroups = this.getMetaEndpoints().stream().collect(Collectors.groupingBy(ClashScannedEndpointMetadata::getFullControllerName));
        HashSet<OrganizedEndpoints> organizedEndpointsSet = new HashSet<OrganizedEndpoints>();
        organizedEndpointsGroups.forEach((key, value) -> {
            OrganizedEndpoints organizedEndpoints = new OrganizedEndpoints((String)key, (List<ClashScannedEndpointMetadata>)value);
            organizedEndpointsSet.add(organizedEndpoints);
        });
        return organizedEndpointsSet;
    }

    void setEndpoints(Set<ClashScannedEndpointMetadata> endpoints) {
        if (this.loaded) {
            return;
        }
        this.endpoints.addAll(endpoints);
        this.loaded = true;
    }
}

