/*
 * Decompiled with CFR 0.152.
 */
package studio.clashbuddy.clashaccess.metadata;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import studio.clashbuddy.clashaccess.metadata.EndpointMetadataHandler;
import studio.clashbuddy.clashaccess.properties.ClashBuddyClashAccessProperties;
import studio.clashbuddy.clashaccess.properties.ClashBuddySecurityClashAccessAppProperties;
import studio.clashbuddy.clashaccess.properties.ServiceType;

@Component
class MetaDataAccessController
implements ApplicationListener<ApplicationReadyEvent> {
    private final RequestMappingHandlerMapping handlerMapping;
    private final EndpointMetadataHandler handler;
    private final ClashBuddySecurityClashAccessAppProperties props;
    private final Logger logger = LoggerFactory.getLogger(MetaDataAccessController.class);
    private final ClashBuddyClashAccessProperties clashBuddyClashAccessProperties;

    public MetaDataAccessController(RequestMappingHandlerMapping handlerMapping, EndpointMetadataHandler handler, ClashBuddySecurityClashAccessAppProperties clashBuddySecurityClashAccessAppProperties, ClashBuddyClashAccessProperties clashBuddyClashAccessProperties) {
        this.handlerMapping = handlerMapping;
        this.handler = handler;
        this.props = clashBuddySecurityClashAccessAppProperties;
        this.clashBuddyClashAccessProperties = clashBuddyClashAccessProperties;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (!this.clashBuddyClashAccessProperties.getServiceType().equals((Object)ServiceType.APPLICATION)) {
            return;
        }
        String path = this.props.getEndpointMetadata();
        String key = this.props.getApiKey();
        if (!this.props.isEnabled()) {
            return;
        }
        if (this.props.isNotChanged()) {
            this.logger.warn("\u26a0\ufe0f ClashAccess metadata endpoint is using the default insecure API key: 'access'.\n\ud83d\udd10 Please update it by setting a strong key in your configuration:\n\n    clashbuddy.clashaccess.application.access.key=your-secure-key\n\n\ud83d\udcc4 Location: application.yml or application.properties");
        }
        if (!StringUtils.hasText((String)key) || !StringUtils.hasText((String)path)) {
            path = this.props.getDefaultEndpoint();
            key = this.props.getDefaultApiKey();
            this.props.setDefaults();
        }
        RequestMappingInfo mappingInfo = RequestMappingInfo.paths((String[])new String[]{path}).methods(new RequestMethod[]{RequestMethod.GET}).build();
        HandlerMethod method = new HandlerMethod((Object)this.handler, this.findHandleMethod());
        this.handlerMapping.registerMapping(mappingInfo, (Object)this.handler, method.getMethod());
    }

    private Method findHandleMethod() {
        try {
            return EndpointMetadataHandler.class.getMethod("handle", HttpServletRequest.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find handler method", e);
        }
    }
}

