/*
 * Decompiled with CFR 0.152.
 */
package studio.clashbuddy.clashaccess.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import studio.clashbuddy.clashaccess.metadata.ClashScannedEndpointMetadata;
import studio.clashbuddy.clashaccess.metadata.ScannedMetadataEndpoints;
import studio.clashbuddy.clashaccess.properties.ClashBuddyClashAccessProperties;
import studio.clashbuddy.clashaccess.properties.ClashBuddySecurityClashAccessAppProperties;
import studio.clashbuddy.clashaccess.properties.ServiceType;
import studio.clashbuddy.clashaccess.security.RequireAccess;

@Order(value=-2147483648)
@Component
class EndpointScanner
implements ApplicationListener<ApplicationReadyEvent> {
    private final ScannedMetadataEndpoints endPoints;
    private final ClashBuddySecurityClashAccessAppProperties securityProperties;
    @Value(value="${server.servlet.context-path:/}")
    private String prefixPath;
    private final ClashBuddyClashAccessProperties clashBuddyClashAccessProperties;
    private final Logger logger = LoggerFactory.getLogger(EndpointScanner.class);

    public EndpointScanner(ScannedMetadataEndpoints endPoints, ClashBuddySecurityClashAccessAppProperties clashBuddySecurityClashAccessAppProperties, ClashBuddyClashAccessProperties clashBuddyClashAccessProperties) {
        this.endPoints = endPoints;
        this.securityProperties = clashBuddySecurityClashAccessAppProperties;
        this.clashBuddyClashAccessProperties = clashBuddyClashAccessProperties;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (!this.clashBuddyClashAccessProperties.getServiceType().equals((Object)ServiceType.APPLICATION)) {
            return;
        }
        String scanStatus = this.securityProperties.isScan() ? "\ud83d\udce6 Ready to process metadata endpoints." : "\u26a0\ufe0f  Endpoint scanning is disabled. No endpoints will be processed.";
        this.logger.info("\n\u2705 ClashAccess Initialization Summary:\n   \ud83d\udd27 Mode:              APPLICATION\n   \ud83d\udd17 Endpoint :         {}\n   \ud83d\udd0d Endpoint Scan:     {}\n   \u2705 Module Enabled:     {}\n   {}\n", new Object[]{this.securityProperties.getEndpointMetadata(), this.securityProperties.isScan(), this.securityProperties.isEnabled(), scanStatus});
        if (!this.securityProperties.isScan()) {
            return;
        }
        ConfigurableApplicationContext context = event.getApplicationContext();
        Map controllers = context.getBeansWithAnnotation(RestController.class);
        HashSet<ClashScannedEndpointMetadata> securedEndpoints = new HashSet<ClashScannedEndpointMetadata>();
        for (Object bean : controllers.values()) {
            Class clazz = AopUtils.getTargetClass(bean);
            String basePath = Optional.ofNullable(clazz.getAnnotation(RequestMapping.class)).map(a -> a.value().length > 0 ? a.value()[0] : "").orElse("");
            for (Method method : clazz.getDeclaredMethods()) {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                RequireAccess access = method.getAnnotation(RequireAccess.class);
                boolean isPublic = access == null;
                String[] methodPath = new String[]{};
                RequestMethod httpMethod = RequestMethod.GET;
                if (method.isAnnotationPresent(GetMapping.class)) {
                    methodPath = method.getAnnotation(GetMapping.class).value();
                    httpMethod = RequestMethod.GET;
                } else if (method.isAnnotationPresent(PostMapping.class)) {
                    methodPath = method.getAnnotation(PostMapping.class).value();
                    httpMethod = RequestMethod.POST;
                } else if (method.isAnnotationPresent(DeleteMapping.class)) {
                    methodPath = method.getAnnotation(DeleteMapping.class).value();
                    httpMethod = RequestMethod.DELETE;
                } else if (method.isAnnotationPresent(PutMapping.class)) {
                    methodPath = method.getAnnotation(PutMapping.class).value();
                    httpMethod = RequestMethod.PUT;
                } else if (method.isAnnotationPresent(PatchMapping.class)) {
                    methodPath = method.getAnnotation(PatchMapping.class).value();
                    httpMethod = RequestMethod.PATCH;
                } else if (method.isAnnotationPresent(RequestMapping.class)) {
                    methodPath = method.getAnnotation(RequestMapping.class).value();
                    httpMethod = method.getAnnotation(RequestMapping.class).method()[0];
                }
                if (access != null) {
                    HashSet<String> roles = new HashSet<String>(Arrays.asList(access.roles()));
                    HashSet<String> excludedRoles = new HashSet<String>(Arrays.asList(access.excludedRoles()));
                    HashSet<String> intersection = new HashSet<String>(roles);
                    intersection.retainAll(excludedRoles);
                    if (!intersection.isEmpty()) {
                        throw new IllegalStateException("Conflict: Role(s) appear in both 'roles' and 'excludedRoles' in method: " + method.getName() + " \u2192 " + String.valueOf(intersection));
                    }
                }
                ClashScannedEndpointMetadata meta = new ClashScannedEndpointMetadata();
                meta.setEndpoints(methodPath);
                meta.setBasePath(basePath);
                meta.setHttpMethod(httpMethod.name());
                meta.setPublic(isPublic);
                meta.setController(clazz.getSimpleName());
                meta.setFullControllerName(clazz.getName());
                meta.setMethod(method.getName());
                meta.setContextPath(this.prefixPath);
                if (!isPublic) {
                    meta.setRoles(Set.of(access.roles()));
                    meta.setPermissions(Set.of(access.permissions()));
                }
                securedEndpoints.add(meta);
            }
        }
        this.endPoints.setEndpoints(securedEndpoints);
    }
}

