/*
 * Decompiled with CFR 0.152.
 */
package studio.clashbuddy.clashaccess.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public class ClashScannedEndpointMetadata {
    private String httpMethod;
    private String[] endpoints;
    private String basePath;
    private String contextPath;
    private boolean isPublic;
    private String controller;
    private String fullControllerName;
    private String method;
    private Set<String> roles;
    private Set<String> permissions;

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getMainEndpoint() {
        if (this.basePath == null) {
            this.basePath = "";
        }
        if (this.endpoints == null || this.endpoints.length == 0 || this.endpoints[0] == null) {
            return this.removeDuplicateSlashes(this.contextPath + "/" + this.basePath.replaceAll("^/+", "").replaceAll("/+$", "") + "/");
        }
        String cleanBase = this.basePath.replaceAll("^/+", "").replaceAll("/+$", "");
        String cleanEndpoint = this.endpoints[0].replaceAll("^/+", "").replaceAll("/+$", "");
        return this.removeDuplicateSlashes(this.contextPath + "/" + cleanBase + "/" + cleanEndpoint);
    }

    private String removeDuplicateSlashes(String path) {
        if (path == null) {
            return null;
        }
        String cleaned = path.replaceAll("/{2,}", "/");
        if (cleaned.length() > 1 && cleaned.endsWith("/")) {
            cleaned = cleaned.replaceAll("/+$", "");
        }
        return cleaned;
    }

    public String[] getEndpoints() {
        return this.endpoints;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setEndpoints(String[] endpoints) {
        this.endpoints = endpoints;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean aPublic) {
        this.isPublic = aPublic;
    }

    public String getController() {
        return this.controller;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Set<String> getRoles() {
        return this.roles == null ? Collections.emptySet() : this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Set<String> getPermissions() {
        return this.permissions == null ? Collections.emptySet() : this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public String getFullControllerName() {
        return this.fullControllerName;
    }

    public void setFullControllerName(String fullControllerName) {
        this.fullControllerName = fullControllerName;
    }

    public String toString() {
        return "SecuredEndpointMetadata{httpMethod='" + this.httpMethod + "', endpoints=" + Arrays.toString(this.endpoints) + ", basePath='" + this.basePath + "', contextPath='" + this.contextPath + "', isPublic=" + this.isPublic + ", controller='" + this.controller + "', fullControllerName='" + this.fullControllerName + "', method='" + this.method + "', roles=" + String.valueOf(this.roles) + ", mainEndpoint='" + this.getMainEndpoint() + "', permissions=" + String.valueOf(this.permissions) + "}";
    }
}

