/*
 * Decompiled with CFR 0.152.
 */
package stream.alwaysbecrafting.flare;

import stream.alwaysbecrafting.flare.GameEngine;

public abstract class GameSystem
implements Comparable<GameSystem> {
    int priority = Integer.MIN_VALUE;
    boolean isPaused = true;

    @Override
    public int compareTo(GameSystem other) {
        return Integer.compare(this.priority, other.priority);
    }

    public void resume() {
        if (this.isPaused) {
            this.onResume();
        }
        this.isPaused = false;
    }

    public void pause() {
        if (!this.isPaused) {
            this.onPause();
        }
        this.isPaused = true;
    }

    public void onStart(GameEngine engine) {
    }

    public void onResume() {
    }

    public void onUpdate(GameEngine engine, float deltaTime) {
    }

    public void onPause() {
    }

    public void onStop(GameEngine engine) {
    }

    void update(GameEngine engine, float deltaTime) {
        this.onUpdate(engine, deltaTime);
    }
}

