/*
 * Decompiled with CFR 0.152.
 */
package solutions.viae.oauth2validation.services;

import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import solutions.viae.coreutils.domain.Response;
import solutions.viae.oauth2validation.domain.OAuth2ServerConfig;
import solutions.viae.oauth2validation.domain.UserAccessToken;
import solutions.viae.oauth2validation.domain.UserContext;
import solutions.viae.oauth2validation.services.UserContextBuildingException;
import solutions.viae.oauth2validation.utils.ViaeBodyPublishers;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lsolutions/viae/oauth2validation/services/UserContextHolder;", "", "oAuth2ServerConfig", "Lsolutions/viae/oauth2validation/domain/OAuth2ServerConfig;", "getCurrentUserAccessToken", "Lkotlin/Function0;", "Lsolutions/viae/oauth2validation/domain/UserAccessToken;", "(Lsolutions/viae/oauth2validation/domain/OAuth2ServerConfig;Lkotlin/jvm/functions/Function0;)V", "httpClient", "Ljava/net/http/HttpClient;", "isAuthenticated", "", "()Z", "userContext", "Lsolutions/viae/coreutils/domain/Response;", "Lsolutions/viae/oauth2validation/domain/UserContext;", "getUserContext", "()Lsolutions/viae/coreutils/domain/Response;", "verifyAccessToken", "token", "", "viae-oauth2.0-validator"})
public final class UserContextHolder {
    private final HttpClient httpClient;
    private final OAuth2ServerConfig oAuth2ServerConfig;
    private final Function0<UserAccessToken> getCurrentUserAccessToken;

    @NotNull
    public final Response<UserContext> getUserContext() throws UserContextBuildingException {
        UserAccessToken token = (UserAccessToken)this.getCurrentUserAccessToken.invoke();
        return this.verifyAccessToken(token.getToken());
    }

    public final boolean isAuthenticated() {
        boolean bl;
        try {
            ((UserContext)this.getUserContext().getData()).getUserName();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Response<UserContext> verifyAccessToken(String token) {
        Response response;
        try {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String lastName;
            JsonElement it;
            Object object;
            Object object2;
            String string;
            Object object3;
            JsonObject json;
            block11: {
                block10: {
                    void $this$mapTo$iv$iv22;
                    HttpRequest request = HttpRequest.newBuilder().POST(ViaeBodyPublishers.INSTANCE.ofFormData(TuplesKt.to((Object)"grant_type", (Object)"client_credentials"), TuplesKt.to((Object)"client_id", (Object)this.oAuth2ServerConfig.getClientId()), TuplesKt.to((Object)"client_secret", (Object)this.oAuth2ServerConfig.getClientSecret()), TuplesKt.to((Object)"token", (Object)token))).header("Content-Type", "application/x-www-form-urlencoded").uri(URI.create(this.oAuth2ServerConfig.getServerUrl() + "/realms/" + this.oAuth2ServerConfig.getRealm() + "/protocol/openid-connect/token/introspect")).build();
                    HttpResponse<String> response2 = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                    if (response2.statusCode() != 200) {
                        throw (Throwable)new UserContextBuildingException("could not validate token => " + response2.statusCode() + ": " + response2.body(), null, 2, null);
                    }
                    String string2 = response2.body();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"response.body()");
                    json = Json.Default.parseJson(string2).getJsonObject();
                    if (!json.getPrimitive("active").getBoolean()) {
                        throw (Throwable)new UserContextBuildingException("token is expired/not active", null, 2, null);
                    }
                    object3 = (JsonElement)json.get((Object)"resource_access");
                    if (object3 == null || (object3 = object3.getJsonObject()) == null || (object3 = object3.getContent()) == null) break block10;
                    Object $this$map$iv2 = object3;
                    boolean $i$f$map = false;
                    Object object4 = $this$map$iv2;
                    Collection destination$iv$iv = new ArrayList($this$map$iv2.size());
                    boolean $i$f$mapTo = false;
                    string = $this$mapTo$iv$iv22;
                    boolean bl = false;
                    object2 = string.entrySet().iterator();
                    while (object2.hasNext()) {
                        Collection<String> collection2;
                        void $this$mapTo$iv$iv3;
                        void $this$map$iv3;
                        Map.Entry item$iv$iv;
                        Map.Entry entry = item$iv$iv = object2.next();
                        object = destination$iv$iv;
                        boolean bl2 = false;
                        Iterable iterable = (Iterable)((JsonElement)it.getValue()).getJsonObject().getArray("roles");
                        Object k = it.getKey();
                        boolean $i$f$map2 = false;
                        void var20_27 = $this$map$iv3;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                            void it2;
                            JsonElement jsonElement = (JsonElement)item$iv$iv2;
                            collection2 = destination$iv$iv2;
                            boolean bl3 = false;
                            String string3 = it2.getPrimitive().getContent();
                            collection2.add(string3);
                        }
                        collection2 = (List)destination$iv$iv2;
                        Pair pair = TuplesKt.to(k, (Object)CollectionsKt.toSet((Iterable)collection2));
                        object.add(pair);
                    }
                    object3 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                    if (object3 != null) break block11;
                }
                object3 = MapsKt.emptyMap();
            }
            Object applicationPermissions = object3;
            JsonPrimitive jsonPrimitive = json.getPrimitiveOrNull("given_name");
            String firstName = jsonPrimitive != null ? jsonPrimitive.getContent() : null;
            JsonPrimitive jsonPrimitive2 = json.getPrimitiveOrNull("family_name");
            String string4 = lastName = jsonPrimitive2 != null ? jsonPrimitive2.getContent() : null;
            String string5 = firstName;
            object = Response.Companion;
            boolean $this$mapTo$iv$iv22 = false;
            Map map = new LinkedHashMap();
            JsonPrimitive jsonPrimitive3 = json.getPrimitiveOrNull("email");
            Iterable $this$mapTo$iv$iv22 = (Iterable)json.getObject("realm_access").getArray("roles");
            String string6 = json.getPrimitive("username").getContent();
            String string7 = jsonPrimitive3 != null ? jsonPrimitive3.getContent() : null;
            boolean $i$f$map = false;
            void $i$f$mapTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                it = (JsonElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string8 = it.getPrimitive().getContent();
                collection.add(string8);
            }
            collection = (List)destination$iv$iv;
            Object object5 = applicationPermissions;
            Set set = CollectionsKt.toSet((Iterable)collection);
            String string9 = string6;
            string = string7;
            Map map2 = map;
            object2 = string4;
            String string10 = string5;
            Map map3 = map2;
            Object object6 = object5;
            Set set2 = set;
            Object object7 = object2;
            String string11 = string10;
            String string12 = string;
            String string13 = string9;
            response = object.success((Object)new UserContext(string13, string12, string11, (String)object7, set2, (Map<String, ? extends Set<String>>)object6, map3));
        }
        catch (Exception exception) {
            response = Response.Companion.failure(Reflection.getOrCreateKotlinClass(UserContextHolder.class), "could not build user context: " + exception.getLocalizedMessage());
        }
        return response;
    }

    public UserContextHolder(@NotNull OAuth2ServerConfig oAuth2ServerConfig, @NotNull Function0<UserAccessToken> getCurrentUserAccessToken) {
        Intrinsics.checkParameterIsNotNull((Object)oAuth2ServerConfig, (String)"oAuth2ServerConfig");
        Intrinsics.checkParameterIsNotNull(getCurrentUserAccessToken, (String)"getCurrentUserAccessToken");
        this.oAuth2ServerConfig = oAuth2ServerConfig;
        this.getCurrentUserAccessToken = getCurrentUserAccessToken;
        HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(1L));
        if (this.oAuth2ServerConfig.getProxySettings() != null) {
            builder = builder.proxy(ProxySelector.of(new InetSocketAddress(this.oAuth2ServerConfig.getProxySettings().getHost(), this.oAuth2ServerConfig.getProxySettings().getPort())));
        }
        HttpClient httpClient = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpClient, (String)"builder.build()");
        this.httpClient = httpClient;
    }
}

