package solutions.viae.databasemanagement.mongodb.factories

import com.mongodb.MongoClientSettings
import com.mongodb.MongoCredential
import com.mongodb.ServerAddress
import com.mongodb.client.MongoClient
import com.mongodb.client.MongoClients
//import com.mongodb.connection.netty.NettyStreamFactoryFactory
//import io.netty.channel.nio.NioEventLoopGroup
import solutions.viae.coreutils.service.Logger
import solutions.viae.coreutils.domain.Environment
import solutions.viae.coreutils.domain.Environment.IN_MEMORY
import solutions.viae.coreutils.domain.Environment.LOCAL
import solutions.viae.databasemanagement.core.api.factories.DatabaseManagementRepositoryFactory
import solutions.viae.databasemanagement.core.api.repositories.ReadOnlyDatabasesRepository
import solutions.viae.databasemanagement.core.impl.factories.DatabaseManagementCrudRepositoryFactory
import solutions.viae.databasemanagement.core.impl.repositories.CrudDatabasesRepository
import solutions.viae.databasemanagement.mongodb.repositories.DefaultDatabasesRepository
import solutions.viae.databasemanagement.mongodb.repositories.InMemoryDatabasesRepository
import java.util.stream.Collectors

class DbManagementRepositoryFactory(
    private val environment: Environment,
    private val mongoServerAddresses: List<String>,
    private val mongoUserName: String,
    private val mongoPassword: String,
    private val mongoSource: String,
    private val logger: Logger
) : DatabaseManagementRepositoryFactory, DatabaseManagementCrudRepositoryFactory {
    private val databasesRepository: CrudDatabasesRepository

    override val readOnlyDatabasesRepository: ReadOnlyDatabasesRepository
        get() = databasesRepository
    override val crudDatabasesRepository: CrudDatabasesRepository
        get() = databasesRepository

    init {
        if (IN_MEMORY == environment) {
            databasesRepository = InMemoryDatabasesRepository()
        } else {
            val mongoSyncClient: MongoClient
            if (LOCAL == environment) {
                mongoSyncClient = MongoClients.create(System.getenv("MONGODB_HOST")?: "mongodb://localhost:27017")
            } else {
//                val eventLoopGroup = NioEventLoopGroup()
                val settings = MongoClientSettings.builder()
                    .applyToClusterSettings { builder ->
                        builder.hosts(
                            mongoServerAddresses.stream().map { msa -> ServerAddress(msa) }.collect(Collectors.toList())
                        )
                    }
                    .applyToSslSettings { builder -> builder.enabled(true) }
//                    .streamFactoryFactory(NettyStreamFactoryFactory.builder().eventLoopGroup(eventLoopGroup).build())
                    .credential(
                        MongoCredential.createScramSha1Credential(
                            mongoUserName,
                            mongoSource,
                            mongoPassword.toCharArray()
                        )
                    )
                    .build()
                mongoSyncClient = MongoClients.create(settings)
            }
            databasesRepository = DefaultDatabasesRepository(mongoSyncClient)
        }
    }

}
