package solutions.viae.databasemanagement.mongodb.config

import solutions.viae.coreutils.service.Logger
import solutions.viae.databasemanagement.core.api.domain.ApplicationDatabasePrefixRegistry
import solutions.viae.coreutils.domain.Environment
import solutions.viae.databasemanagement.core.api.factories.DatabaseManagementUseCaseFactory
import solutions.viae.databasemanagement.core.api.repositories.ReadOnlyDatabasesRepository
import solutions.viae.databasemanagement.core.impl.repositories.CrudDatabasesRepository
import solutions.viae.databasemanagement.mongodb.factories.DbManagementRepositoryFactory

data class MongoConnectionProps (
    val mongoServerAddresses: List<String>,
    val mongoUser: String,
    val mongoPassword: String,
    val mongoSource: String
)

class MongoDbBasedDatabaseManagementConfig(
    mongoConnectionProps: MongoConnectionProps,
    logger: Logger,
    environment: Environment,
    private val applicationDatabasePrefixRegistry: ApplicationDatabasePrefixRegistry
) {
    private val dbManagementRepositoryFactory = DbManagementRepositoryFactory(
        environment = environment,
        mongoUserName = mongoConnectionProps.mongoUser,
        mongoSource = mongoConnectionProps.mongoSource,
        mongoPassword = mongoConnectionProps.mongoPassword,
        mongoServerAddresses = mongoConnectionProps.mongoServerAddresses,
        logger = logger
    )

    fun initDatabaseManagementUseCaseFactory(): DatabaseManagementUseCaseFactory {
        return DatabaseManagementUseCaseFactory(
            readOnlyRepositoryFactory = dbManagementRepositoryFactory,
            crudRepositoryFactory = dbManagementRepositoryFactory,
            applicationDatabasePrefixRegistry = applicationDatabasePrefixRegistry
        )
    }

    fun initReadOnlyDatabaseManagementRepository(): ReadOnlyDatabasesRepository {
        return dbManagementRepositoryFactory.readOnlyDatabasesRepository
    }

    fun initCrudDatabaseManagementRepository(): CrudDatabasesRepository {
        return dbManagementRepositoryFactory.crudDatabasesRepository
    }
}
