/*
 * Decompiled with CFR 0.152.
 */
package solutions.deepfield.spark.itcase.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transfer.TransferResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletOutTransferListener
extends AbstractTransferListener {
    private static final Logger logger = LoggerFactory.getLogger(ServletOutTransferListener.class);
    private OutputStream out;
    TransferListener delegate;
    private Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
    private int lastLength;

    public ServletOutTransferListener(OutputStream out, TransferListener delegate) {
        this.out = out;
        this.delegate = delegate;
    }

    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        this.delegate.transferInitiated(event);
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        this.delegate.transferStarted(event);
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.downloads.put(resource, event.getTransferredBytes());
        StringBuilder buffer = new StringBuilder(64);
        for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
            long total = entry.getKey().getContentLength();
            long complete = entry.getValue();
            buffer.append(this.getStatus(complete, total)).append("  ");
        }
        int pad = this.lastLength - buffer.length();
        this.lastLength = buffer.length();
        this.pad(buffer, pad);
        buffer.append('\r');
        this.writeToServletOut(buffer.toString());
        this.delegate.transferProgressed(event);
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        this.delegate.transferCorrupted(event);
        try (ByteArrayOutputStream temp = new ByteArrayOutputStream();
             PrintStream ps = new PrintStream(temp);){
            event.getException().printStackTrace(ps);
            String stackTraceText = temp.toString();
            this.writeToServletOut("Error transfering [" + event.getResource().getRepositoryUrl() + "]: " + event.getException().getMessage() + "\n" + stackTraceText);
        }
        catch (IOException e) {
            logger.error("Unable to print error to servlet output stream: " + e.getMessage(), (Throwable)e);
        }
    }

    public void transferSucceeded(TransferEvent event) {
        this.delegate.transferSucceeded(event);
        this.transferCompleted(event);
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            String throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                long bytes = contentLength - resource.getResumeOffset();
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)bytes / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            this.writeToServletOut(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + throughput + ")");
        }
    }

    public void transferFailed(TransferEvent event) {
        this.delegate.transferFailed(event);
    }

    private void transferCompleted(TransferEvent event) {
        this.downloads.remove(event.getResource());
        StringBuilder buffer = new StringBuilder(64);
        this.pad(buffer, this.lastLength);
        buffer.append('\r');
        String stringToWrite = buffer.toString();
        this.writeToServletOut(stringToWrite);
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B ";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB ";
        }
        return complete + " B ";
    }

    private void writeToServletOut(String message) {
        try {
            this.out.write(message.getBytes("UTF-8"));
            this.out.flush();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Unable to write message to servlet stream: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to write message to servlet stream: " + e.getMessage(), (Throwable)e);
        }
    }

    private void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, block.length());
            buffer.append(block, 0, n);
            spaces -= n;
        }
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

