/*
 * Decompiled with CFR 0.152.
 */
package solutions.deepfield.spark.itcase.core.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.TransferListener;
import solutions.deepfield.spark.itcase.core.util.ConsoleRepositoryListener;
import solutions.deepfield.spark.itcase.core.util.ConsoleTransferListener;
import solutions.deepfield.spark.itcase.core.util.ManualRepositorySystemFactory;
import solutions.deepfield.spark.itcase.core.util.ServletOutTransferListener;

public class Booter {
    private static final String REPO_LOC_DEFAULT = System.getProperty("user.home") + File.separator + ".spark_itcase/repo";

    public static RepositorySystem newRepositorySystem() {
        return ManualRepositorySystemFactory.newRepositorySystem();
    }

    public static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, ServletOutTransferListener listener) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(REPO_LOC_DEFAULT);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        if (listener == null) {
            session.setTransferListener((TransferListener)new ConsoleTransferListener());
        } else {
            session.setTransferListener((TransferListener)listener);
        }
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        return session;
    }

    public static List<RemoteRepository> newRepositories(RepositorySystem system, RepositorySystemSession session) {
        return new ArrayList<RemoteRepository>(Arrays.asList(Booter.newCentralRepository()));
    }

    private static RemoteRepository newCentralRepository() {
        return new RemoteRepository.Builder("central", "default", "http://central.maven.org/maven2/").build();
    }
}

