/*
 * Decompiled with CFR 0.152.
 */
package solutions.deepfield.spark.itcase.core.util;

import java.io.InputStream;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import solutions.deepfield.spark.itcase.exceptions.SparkITCaseException;

@Component
public class AppUtil {
    private static final Logger logger = LoggerFactory.getLogger(AppUtil.class);
    private static final String APP_PROPERTIES_FILE = "/app.properties";
    private static final String BUILD_VERSION_PROP = "build.version";
    private static final String BUILD_TIMESTAMP_PROP = "build.timestamp";
    private Properties props;

    @PostConstruct
    public void loadProperties() {
        try (InputStream is = this.getClass().getResourceAsStream(APP_PROPERTIES_FILE);){
            this.props = new Properties();
            this.props.load(is);
        }
        catch (Exception e) {
            throw new SparkITCaseException("Unable to load application properties: " + e.getMessage(), e);
        }
        this.testProperty(BUILD_VERSION_PROP);
        this.testProperty(BUILD_TIMESTAMP_PROP);
    }

    private void testProperty(String propertyName) {
        String propValue = this.props.getProperty(propertyName);
        if (StringUtils.isBlank((String)propValue)) {
            throw new SparkITCaseException("Property [" + propertyName + "] is blank");
        }
        logger.info("Property [{}] is [{}]", (Object)propertyName, (Object)propValue);
    }

    public String getVersion() {
        return this.props.getProperty(BUILD_VERSION_PROP);
    }

    public String getTimestamp() {
        return this.props.getProperty(BUILD_TIMESTAMP_PROP);
    }
}

