/*
 * Decompiled with CFR 0.152.
 */
package solutions.deepfield.spark.itcase.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.transfer.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import solutions.deepfield.spark.itcase.core.util.Booter;
import solutions.deepfield.spark.itcase.core.util.ConsoleTransferListener;
import solutions.deepfield.spark.itcase.core.util.ServletOutTransferListener;

public class LocalRepository {
    private static final Logger logger = LoggerFactory.getLogger(LocalRepository.class);
    RepositorySystem system;

    public void initialize() {
        this.system = Booter.newRepositorySystem();
    }

    public void retrieveArtifact(String groupId, String artifactId, String version, OutputStream outStream) {
        ArtifactDescriptorResult descriptorResult;
        ServletOutTransferListener listener = new ServletOutTransferListener(outStream, (TransferListener)new ConsoleTransferListener());
        DefaultRepositorySystemSession session = Booter.newRepositorySystemSession(this.system, listener);
        DefaultArtifact artifact = new DefaultArtifact(groupId + ":" + artifactId + ":" + version);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        List<RemoteRepository> repositories = Booter.newRepositories(this.system, (RepositorySystemSession)session);
        artifactRequest.setRepositories(repositories);
        try {
            ArtifactResult artifactResult = this.system.resolveArtifact((RepositorySystemSession)session, artifactRequest);
            artifact = artifactResult.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            logger.error("Unable to retrieve artifact: " + e.getMessage(), (Throwable)e);
            return;
        }
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact((Artifact)artifact);
        descriptorRequest.setRepositories(Booter.newRepositories(this.system, (RepositorySystemSession)session));
        try {
            descriptorResult = this.system.readArtifactDescriptor((RepositorySystemSession)session, descriptorRequest);
        }
        catch (ArtifactDescriptorException e) {
            logger.error("Unable to retrieve hierarchy: " + e.getMessage(), (Throwable)e);
            return;
        }
        CollectRequest request = new CollectRequest();
        request.setRootArtifact((Artifact)artifact);
        request.setRepositories(repositories);
        request.setDependencies(descriptorResult.getDependencies());
        request.setManagedDependencies(descriptorResult.getManagedDependencies());
        try {
            this.system.collectDependencies((RepositorySystemSession)session, request);
        }
        catch (DependencyCollectionException e) {
            logger.error("Unable to retrieve dependencies: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployArtifact(String groupId, String artifactId, String version, InputStream jarInStream, InputStream pomInStream) throws InstallationException, IOException {
        DefaultRepositorySystemSession session = Booter.newRepositorySystemSession(this.system, null);
        File tmp = File.createTempFile("jar-deploy-tmp-", ".jar");
        try (FileOutputStream fout = new FileOutputStream(tmp);){
            IOUtils.copy((InputStream)jarInStream, (OutputStream)fout);
        }
        File pomTmp = File.createTempFile("jar-deploy-tmp-", ".xml");
        try (FileOutputStream fout = new FileOutputStream(pomTmp);){
            IOUtils.copy((InputStream)pomInStream, (OutputStream)fout);
        }
        DefaultArtifact jarArtifact = new DefaultArtifact(groupId, artifactId, "", "jar", version, null, tmp);
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version, null, pomTmp);
        try {
            InstallRequest installRequest = new InstallRequest();
            installRequest.addArtifact((Artifact)jarArtifact).addArtifact((Artifact)pomArtifact);
            this.system.install((RepositorySystemSession)session, installRequest);
        }
        finally {
            tmp.delete();
        }
    }

    public String buildFile(String groupId, String artifactId, String version) throws RepositoryException {
        DefaultRepositorySystemSession session = Booter.newRepositorySystemSession(this.system, null);
        DefaultArtifact artifact = new DefaultArtifact(groupId + ":" + artifactId + ":" + version);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        List<RemoteRepository> repositories = Booter.newRepositories(this.system, (RepositorySystemSession)session);
        artifactRequest.setRepositories(repositories);
        ArtifactResult artifactResult = this.system.resolveArtifact((RepositorySystemSession)session, artifactRequest);
        artifact = artifactResult.getArtifact();
        return artifact.getFile().getAbsolutePath();
    }

    public List<String> buildFiles(String groupId, String artifactId, String version) throws RepositoryException, ArtifactDescriptorException {
        DefaultRepositorySystemSession session = Booter.newRepositorySystemSession(this.system, null);
        DefaultArtifact artifact = new DefaultArtifact(groupId + ":" + artifactId + ":" + version);
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact((Artifact)artifact);
        descriptorRequest.setRepositories(Booter.newRepositories(this.system, (RepositorySystemSession)session));
        ArtifactDescriptorResult descriptorResult = this.system.readArtifactDescriptor((RepositorySystemSession)session, descriptorRequest);
        CollectRequest request = new CollectRequest();
        request.setRootArtifact((Artifact)artifact);
        request.setDependencies(descriptorResult.getDependencies());
        request.setManagedDependencies(descriptorResult.getManagedDependencies());
        CollectResult result = this.system.collectDependencies((RepositorySystemSession)session, request);
        ArrayList<String> resultPaths = new ArrayList<String>();
        DependencyRequest artifactRequest = new DependencyRequest(result.getRoot(), new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                if (node.getDependency() == null) {
                    return true;
                }
                String scope = node.getDependency().getScope();
                return StringUtils.isBlank((String)scope) || !scope.equalsIgnoreCase("provided") && !scope.equalsIgnoreCase("test");
            }
        });
        DependencyResult dependencyResult = this.system.resolveDependencies((RepositorySystemSession)session, artifactRequest);
        for (ArtifactResult artifactResult : dependencyResult.getArtifactResults()) {
            resultPaths.add(artifactResult.getArtifact().getFile().getAbsolutePath());
        }
        return resultPaths;
    }
}

