/*
 * Decompiled with CFR 0.152.
 */
package solutions.bkit.k8sportforward;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import solutions.bkit.k8sportforward.PortForwardItem;

@Configuration
@ConfigurationProperties(prefix="spring.cloud.discovery.client.simple")
@ConditionalOnProperty(prefix="k8s-port-forward", name={"enabled"}, havingValue="true")
public class PortForwardAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PortForwardAutoConfiguration.class);
    private Map<String, List<PortForwardItem>> instances;

    @Bean
    CommandLineRunner run() {
        return args -> {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            log.info("==================================");
            log.info("Will run kubectl port-forward");
            this.instances.forEach((serviceId, serviceInstances) -> {
                try {
                    PortForwardItem hostPort = (PortForwardItem)serviceInstances.get(0);
                    String command = String.format("kubectl port-forward svc/%s %d:%d", serviceId, hostPort.getPort(), hostPort.getSvcPort());
                    log.info("{}", (Object)command);
                    Process process = Runtime.getRuntime().exec(command);
                    StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println);
                    executorService.submit(streamGobbler);
                }
                catch (IOException exception) {
                    log.error("port-forward error", (Throwable)exception);
                }
            });
            log.info("Finished running kubectl port-forward");
            log.info("==================================");
        };
    }

    public Map<String, List<PortForwardItem>> getInstances() {
        return this.instances;
    }

    public void setInstances(Map<String, List<PortForwardItem>> instances) {
        this.instances = instances;
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

