/*
 * Decompiled with CFR 0.152.
 */
package solutions.bkit.configurableloadbalanced;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import reactor.core.publisher.Flux;
import solutions.bkit.configurableloadbalanced.HostPortItem;
import solutions.bkit.configurableloadbalanced.MappedServiceInstanceListSuppler;
import solutions.bkit.configurableloadbalanced.MappedServicesConfig;

@Configuration
@ConditionalOnProperty(prefix="property-source-lb", name={"enabled"}, havingValue="true")
@Import(value={MappedServicesConfig.class})
public class PropertySourceLbConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PropertySourceLbConfiguration.class);

    @Bean
    @Primary
    ServiceInstanceListSupplier serviceInstanceListSupplier(MappedServicesConfig mappedServicesConfig) {
        Map<String, HostPortItem> servicesMap = this.mapToHostPort(mappedServicesConfig);
        return new MappedServiceInstanceListSuppler("local-port-forward", servicesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> Flux.just(Arrays.asList(new DefaultServiceInstance((String)it.getKey(), (String)it.getKey(), ((HostPortItem)it.getValue()).getHost(), ((HostPortItem)it.getValue()).getPort(), false))))));
    }

    @Bean
    @ConditionalOnProperty(prefix="property-source-lb", name={"auto-port-forward"}, havingValue="true", matchIfMissing=true)
    CommandLineRunner run(MappedServicesConfig mappedServicesConfig) {
        return args -> {
            Map<String, HostPortItem> servicesMap = this.mapToHostPort(mappedServicesConfig);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            log.info("==================================");
            log.info("Will run kubect port-forward");
            servicesMap.forEach((serviceId, hostPort) -> {
                try {
                    String command = String.format("kubectl port-forward svc/%s %d:%d", serviceId, hostPort.getPort(), hostPort.getSvcPort());
                    log.info("{}", (Object)command);
                    Process process = Runtime.getRuntime().exec(command);
                    StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println);
                    executorService.submit(streamGobbler);
                }
                catch (IOException exception) {
                    log.error("port-forward error", (Throwable)exception);
                }
            });
            log.info("Finished running kubect port-forward");
            log.info("==================================");
        };
    }

    private Map<String, HostPortItem> mapToHostPort(MappedServicesConfig mappedServicesConfig) {
        return mappedServicesConfig.getServices().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> {
            String value = (String)it.getValue();
            String[] split = value.split(":");
            String host = split[0].length() == 0 ? "localhost" : split[0];
            int port = Integer.parseInt(split[1]);
            int svcPort = split.length == 3 ? Integer.parseInt(split[2]) : 8080;
            return new HostPortItem(host, port, svcPort);
        }));
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

