/*
 * Decompiled with CFR 0.152.
 */
package solutions.bkit.configurableloadbalanced;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Flux;

class MappedServiceInstanceListSuppler
implements ServiceInstanceListSupplier {
    private final String serviceId;
    private final Map<String, Flux<List<ServiceInstance>>> serviceMap;

    public MappedServiceInstanceListSuppler(String serviceId, Map<String, Flux<List<ServiceInstance>>> serviceMap) {
        this.serviceId = serviceId;
        this.serviceMap = serviceMap;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public Flux<List<ServiceInstance>> get(Request request) {
        DefaultRequestContext context = (DefaultRequestContext)request.getContext();
        RequestData clientRequest = (RequestData)context.getClientRequest();
        return this.serviceMap.get(clientRequest.getUrl().getHost());
    }

    public Flux<List<ServiceInstance>> get() {
        return Flux.just(Arrays.asList(new DefaultServiceInstance(this.serviceId + "1", this.serviceId, "localhost", 8090, false), new DefaultServiceInstance(this.serviceId + "2", this.serviceId, "localhost", 9092, false), new DefaultServiceInstance(this.serviceId + "3", this.serviceId, "localhost", 9999, false)));
    }
}

