/*
 * Decompiled with CFR 0.152.
 */
package solutions.a2.oracle.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import solutions.a2.oracle.jdbc.OraProxyResultSet;
import solutions.a2.oracle.jdbc.OraProxySqlTranslator;

public class OraProxyCallableStatement
implements OracleCallableStatement,
CallableStatement {
    final OracleConnection connection;
    final OracleCallableStatement oracle;
    final OraProxySqlTranslator translator;

    OraProxyCallableStatement(OracleConnection connection, OracleCallableStatement statement, OraProxySqlTranslator translator) {
        this.connection = connection;
        this.oracle = statement;
        this.translator = translator;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return new OraProxyResultSet(this, (OracleResultSet)this.oracle.executeQuery());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return new OraProxyResultSet(this, (OracleResultSet)this.oracle.executeQuery(this.translator.translate(sql)));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql));
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql));
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return new OraProxyResultSet(this, (OracleResultSet)this.oracle.getResultSet());
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.oracle.addBatch(this.translator.translate(sql));
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return new OraProxyResultSet(this, (OracleResultSet)this.oracle.getGeneratedKeys());
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql), autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql), columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql), columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql), autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql), columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql), columnNames);
    }

    public ResultSet getReturnResultSet() throws SQLException {
        return new OraProxyResultSet(this, (OracleResultSet)this.oracle.getReturnResultSet());
    }

    public ResultSet getCursor(int parameterIndex) throws SQLException {
        return new OraProxyResultSet(this, (OracleResultSet)this.oracle.getCursor(parameterIndex));
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.oracle.executeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.oracle.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.oracle.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.oracle.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.oracle.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.oracle.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.oracle.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.oracle.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.oracle.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.oracle.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.oracle.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.oracle.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.oracle.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.oracle.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.oracle.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.oracle.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.oracle.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.oracle.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.oracle.clearParameters();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.oracle.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.oracle.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.oracle.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this.oracle.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.oracle.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.oracle.setRef(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.oracle.setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.oracle.setClob(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.oracle.setArray(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.oracle.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.oracle.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.oracle.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.oracle.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.oracle.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.oracle.setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.oracle.getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.oracle.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.oracle.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.oracle.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.oracle.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.oracle.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.oracle.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.oracle.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.oracle.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.oracle.setObject(parameterIndex, x, scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.oracle.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.oracle.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.oracle.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.oracle.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.oracle.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.oracle.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.oracle.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.oracle.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.oracle.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.oracle.setNClob(parameterIndex, reader);
    }

    @Override
    public void close() throws SQLException {
        this.oracle.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.oracle.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.oracle.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.oracle.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.oracle.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.oracle.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.oracle.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.oracle.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.oracle.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.oracle.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.oracle.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.oracle.setCursorName(name);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.oracle.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.oracle.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.oracle.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.oracle.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.oracle.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.oracle.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.oracle.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.oracle.getResultSetType();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.oracle.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.oracle.executeBatch();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.oracle.getMoreResults(current);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.oracle.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.oracle.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.oracle.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.oracle.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.oracle.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.oracle.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.oracle.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.oracle.isWrapperFor(iface);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.oracle.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.oracle.registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.oracle.wasNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return this.oracle.getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.oracle.getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return this.oracle.getByte(parameterIndex);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return this.oracle.getShort(parameterIndex);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return this.oracle.getInt(parameterIndex);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return this.oracle.getLong(parameterIndex);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return this.oracle.getFloat(parameterIndex);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return this.oracle.getDouble(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.oracle.getBigDecimal(parameterIndex);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.oracle.getBytes(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.oracle.getDate(parameterIndex);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.oracle.getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.oracle.getTimestamp(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        return this.oracle.getObject(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.oracle.getBigDecimal(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return this.oracle.getObject(parameterIndex, map);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        return this.oracle.getRef(parameterIndex);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return this.oracle.getBlob(parameterIndex);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return this.oracle.getClob(parameterIndex);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        return this.oracle.getArray(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.oracle.getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.oracle.getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.oracle.getTimestamp(parameterIndex, cal);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.oracle.registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.oracle.registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.oracle.registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.oracle.registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return this.oracle.getURL(parameterIndex);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.oracle.setURL(parameterName, val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.oracle.setNull(parameterName, sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.oracle.setBoolean(parameterName, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.oracle.setByte(parameterName, x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.oracle.setShort(parameterName, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.oracle.setInt(parameterName, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.oracle.setLong(parameterName, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.oracle.setFloat(parameterName, x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.oracle.setDouble(parameterName, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.oracle.setBigDecimal(parameterName, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.oracle.setString(parameterName, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.oracle.setBytes(parameterName, x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.oracle.setDate(parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.oracle.setTime(parameterName, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.oracle.setTimestamp(parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.oracle.setAsciiStream(parameterName, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.oracle.setBinaryStream(parameterName, x, length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.oracle.setObject(parameterName, x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.oracle.setObject(parameterName, x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.oracle.setObject(parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.oracle.setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.oracle.setDate(parameterName, x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.oracle.setTime(parameterName, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.oracle.setTimestamp(parameterName, x, cal);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.oracle.setNull(parameterName, sqlType, typeName);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.oracle.getString(parameterName);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.oracle.getBoolean(parameterName);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.oracle.getByte(parameterName);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.oracle.getShort(parameterName);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.oracle.getInt(parameterName);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.oracle.getLong(parameterName);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.oracle.getFloat(parameterName);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.oracle.getDouble(parameterName);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.oracle.getBytes(parameterName);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.oracle.getDate(parameterName);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.oracle.getTime(parameterName);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.oracle.getTimestamp(parameterName);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.oracle.getObject(parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.oracle.getBigDecimal(parameterName);
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.oracle.getObject(parameterName, map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.oracle.getRef(parameterName);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.oracle.getBlob(parameterName);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.oracle.getClob(parameterName);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.oracle.getArray(parameterName);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.oracle.getDate(parameterName, cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.oracle.getTime(parameterName, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.oracle.getTimestamp(parameterName, cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.oracle.getURL(parameterName);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        return this.oracle.getRowId(parameterIndex);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return this.oracle.getRowId(parameterName);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.oracle.setRowId(parameterName, x);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.oracle.setNString(parameterName, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setNCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.oracle.setNClob(parameterName, value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setClob(parameterName, reader, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.oracle.setBlob(parameterName, inputStream, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setNClob(parameterName, reader, length);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return this.oracle.getNClob(parameterIndex);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.oracle.getNClob(parameterName);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.oracle.setSQLXML(parameterName, xmlObject);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return this.oracle.getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.oracle.getSQLXML(parameterName);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.oracle.getNString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.oracle.getNString(parameterName);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.oracle.getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.oracle.getNCharacterStream(parameterName);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.oracle.getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.oracle.getCharacterStream(parameterName);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.oracle.setBlob(parameterName, x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.oracle.setClob(parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.oracle.setAsciiStream(parameterName, inputStream, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.oracle.setBinaryStream(parameterName, inputStream, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream inputStream) throws SQLException {
        this.oracle.setAsciiStream(parameterName, inputStream);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream inputStream) throws SQLException {
        this.oracle.setBinaryStream(parameterName, inputStream);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.oracle.setCharacterStream(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.oracle.setNCharacterStream(parameterName, reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.oracle.setClob(parameterName, reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.oracle.setBlob(parameterName, inputStream);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.oracle.setNClob(parameterName, reader);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return (T)this.oracle.getObject(parameterIndex, type);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return (T)this.oracle.getObject(parameterName, type);
    }

    public OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
        return this.oracle.OracleGetParameterMetaData();
    }

    public void defineParameterType(int parameterIndex, int type, int maxSize) throws SQLException {
        this.oracle.defineParameterType(parameterIndex, type, maxSize);
    }

    public void defineParameterTypeBytes(int parameterIndex, int type, int maxSize) throws SQLException {
        this.oracle.defineParameterTypeBytes(parameterIndex, type, maxSize);
    }

    public void defineParameterTypeChars(int parameterIndex, int type, int maxSize) throws SQLException {
        this.oracle.defineParameterTypeChars(parameterIndex, type, maxSize);
    }

    @Deprecated
    public int getExecuteBatch() {
        return this.oracle.getExecuteBatch();
    }

    public void registerReturnParameter(int parameterIndex, int externalType) throws SQLException {
        this.oracle.registerReturnParameter(parameterIndex, externalType);
    }

    public void registerReturnParameter(int parameterIndex, int externalType, int maxSize) throws SQLException {
        this.oracle.registerReturnParameter(parameterIndex, externalType, maxSize);
    }

    public void registerReturnParameter(int parameterIndex, int externalType, String typeName) throws SQLException {
        this.oracle.registerReturnParameter(parameterIndex, externalType, typeName);
    }

    public void setARRAY(int parameterIndex, ARRAY value) throws SQLException {
        this.oracle.setARRAY(parameterIndex, value);
    }

    public void setARRAYAtName(String parameterName, ARRAY value) throws SQLException {
        this.oracle.setARRAYAtName(parameterName, value);
    }

    public void setArrayAtName(String parameterName, Array value) throws SQLException {
        this.oracle.setArrayAtName(parameterName, value);
    }

    public void setAsciiStreamAtName(String parameterName, InputStream stream) throws SQLException {
        this.oracle.setAsciiStreamAtName(parameterName, stream);
    }

    public void setAsciiStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
        this.oracle.setAsciiStreamAtName(parameterName, stream, length);
    }

    public void setAsciiStreamAtName(String parameterName, InputStream stream, long length) throws SQLException {
        this.oracle.setAsciiStreamAtName(parameterName, stream, length);
    }

    public void setBFILE(int parameterIndex, BFILE value) throws SQLException {
        this.oracle.setBFILE(parameterIndex, value);
    }

    public void setBFILEAtName(String parameterName, BFILE value) throws SQLException {
        this.oracle.setBFILEAtName(parameterName, value);
    }

    public void setBLOB(int parameterIndex, BLOB value) throws SQLException {
        this.oracle.setBLOB(parameterIndex, value);
    }

    public void setBLOBAtName(String parameterName, BLOB value) throws SQLException {
        this.oracle.setBLOBAtName(parameterName, value);
    }

    public void setBfile(int parameterIndex, BFILE value) throws SQLException {
        this.oracle.setBfile(parameterIndex, value);
    }

    public void setBfileAtName(String parameterName, BFILE value) throws SQLException {
        this.oracle.setBfileAtName(parameterName, value);
    }

    public void setBigDecimalAtName(String parameterName, BigDecimal value) throws SQLException {
        this.oracle.setBigDecimalAtName(parameterName, value);
    }

    public void setBinaryDouble(int parameterIndex, double value) throws SQLException {
        this.oracle.setBinaryDouble(parameterIndex, value);
    }

    public void setBinaryDouble(int parameterIndex, BINARY_DOUBLE value) throws SQLException {
        this.oracle.setBinaryDouble(parameterIndex, value);
    }

    public void setBinaryDoubleAtName(String parameterName, double value) throws SQLException {
        this.oracle.setBinaryDoubleAtName(parameterName, value);
    }

    public void setBinaryDoubleAtName(String parameterName, BINARY_DOUBLE value) throws SQLException {
        this.oracle.setBinaryDoubleAtName(parameterName, value);
    }

    public void setBinaryFloat(int parameterIndex, float value) throws SQLException {
        this.oracle.setBinaryFloat(parameterIndex, value);
    }

    public void setBinaryFloat(int parameterIndex, BINARY_FLOAT value) throws SQLException {
        this.oracle.setBinaryFloat(parameterIndex, value);
    }

    public void setBinaryFloatAtName(String parameterName, float value) throws SQLException {
        this.oracle.setBinaryFloatAtName(parameterName, value);
    }

    public void setBinaryFloatAtName(String parameterName, BINARY_FLOAT value) throws SQLException {
        this.oracle.setBinaryFloatAtName(parameterName, value);
    }

    public void setBinaryStreamAtName(String parameterName, InputStream stream) throws SQLException {
        this.oracle.setBinaryStreamAtName(parameterName, stream);
    }

    public void setBinaryStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
        this.oracle.setBinaryStreamAtName(parameterName, stream, length);
    }

    public void setBinaryStreamAtName(String parameterName, InputStream stream, long length) throws SQLException {
        this.oracle.setBinaryStreamAtName(parameterName, stream, length);
    }

    public void setBlobAtName(String parameterName, Blob value) throws SQLException {
        this.oracle.setBlobAtName(parameterName, value);
    }

    public void setBlobAtName(String parameterName, InputStream stream) throws SQLException {
        this.oracle.setBlobAtName(parameterName, stream);
    }

    public void setBlobAtName(String parameterName, InputStream stream, long length) throws SQLException {
        this.oracle.setBlobAtName(parameterName, stream, length);
    }

    public void setBooleanAtName(String parameterName, boolean value) throws SQLException {
        this.oracle.setBooleanAtName(parameterName, value);
    }

    public void setByteAtName(String parameterName, byte value) throws SQLException {
        this.oracle.setByteAtName(parameterName, value);
    }

    public void setBytesAtName(String parameterName, byte[] value) throws SQLException {
        this.oracle.setBytesAtName(parameterName, value);
    }

    public void setBytesForBlob(int parameterIndex, byte[] value) throws SQLException {
        this.oracle.setBytesForBlob(parameterIndex, value);
    }

    public void setBytesForBlobAtName(String parameterName, byte[] value) throws SQLException {
        this.oracle.setBytesForBlobAtName(parameterName, value);
    }

    public void setCHAR(int parameterIndex, CHAR value) throws SQLException {
        this.oracle.setCHAR(parameterIndex, value);
    }

    public void setCHARAtName(String parameterName, CHAR value) throws SQLException {
        this.oracle.setCHARAtName(parameterName, value);
    }

    public void setCLOB(int parameterIndex, CLOB value) throws SQLException {
        this.oracle.setCLOB(parameterIndex, value);
    }

    public void setCLOBAtName(String parameterName, CLOB value) throws SQLException {
        this.oracle.setCLOBAtName(parameterName, value);
    }

    public void setCharacterStreamAtName(String parameterName, Reader reader) throws SQLException {
        this.oracle.setCharacterStreamAtName(parameterName, reader);
    }

    public void setCharacterStreamAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setCharacterStreamAtName(parameterName, reader, length);
    }

    public void setCheckBindTypes(boolean flag) {
        this.oracle.setCheckBindTypes(flag);
    }

    public void setClobAtName(String parameterName, Clob value) throws SQLException {
        this.oracle.setClobAtName(parameterName, value);
    }

    public void setClobAtName(String parameterName, Reader reader) throws SQLException {
        this.oracle.setClobAtName(parameterName, reader);
    }

    public void setClobAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setClobAtName(parameterName, reader, length);
    }

    @Deprecated
    public void setCursor(int parameterIndex, ResultSet value) throws SQLException {
        this.oracle.setCursor(parameterIndex, value);
    }

    public void setCursorAtName(String parameterName, ResultSet value) throws SQLException {
        this.oracle.setCursorAtName(parameterName, value);
    }

    @Deprecated
    public void setCustomDatum(int parameterIndex, CustomDatum value) throws SQLException {
        this.oracle.setCustomDatum(parameterIndex, value);
    }

    public void setCustomDatumAtName(String parameterName, CustomDatum value) throws SQLException {
        this.oracle.setCustomDatumAtName(parameterName, value);
    }

    public void setDATE(int parameterIndex, DATE value) throws SQLException {
        this.oracle.setDATE(parameterIndex, value);
    }

    public void setDATEAtName(String parameterName, DATE value) throws SQLException {
        this.oracle.setDATEAtName(parameterName, value);
    }

    public void setDateAtName(String parameterName, Date value) throws SQLException {
        this.oracle.setDateAtName(parameterName, value);
    }

    public void setDateAtName(String parameterName, Date value, Calendar cal) throws SQLException {
        this.oracle.setDateAtName(parameterName, value, cal);
    }

    public void setDisableStmtCaching(boolean cache) {
        this.oracle.setDisableStmtCaching(cache);
    }

    public void setDoubleAtName(String parameterName, double value) throws SQLException {
        this.oracle.setDoubleAtName(parameterName, value);
    }

    public void setFixedCHAR(int parameterIndex, String value) throws SQLException {
        this.oracle.setFixedCHAR(parameterIndex, value);
    }

    public void setFixedCHARAtName(String parameterName, String value) throws SQLException {
        this.oracle.setFixedCHARAtName(parameterName, value);
    }

    public void setFloatAtName(String parameterName, float value) throws SQLException {
        this.oracle.setFloatAtName(parameterName, value);
    }

    public void setFormOfUse(int parameterIndex, short formOfUse) {
        this.oracle.setFormOfUse(parameterIndex, formOfUse);
    }

    public void setINTERVALDS(int parameterIndex, INTERVALDS value) throws SQLException {
        this.oracle.setINTERVALDS(parameterIndex, value);
    }

    public void setINTERVALDSAtName(String parameterName, INTERVALDS value) throws SQLException {
        this.oracle.setINTERVALDSAtName(parameterName, value);
    }

    public void setINTERVALYM(int parameterIndex, INTERVALYM value) throws SQLException {
        this.oracle.setINTERVALYM(parameterIndex, value);
    }

    public void setINTERVALYMAtName(String parameterName, INTERVALYM value) throws SQLException {
        this.oracle.setINTERVALYMAtName(parameterName, value);
    }

    public void setIntAtName(String parameterName, int value) throws SQLException {
        this.oracle.setIntAtName(parameterName, value);
    }

    public void setLongAtName(String parameterName, long value) throws SQLException {
        this.oracle.setLongAtName(parameterName, value);
    }

    public void setNCharacterStreamAtName(String parameterName, Reader reader) throws SQLException {
        this.oracle.setNCharacterStreamAtName(parameterName, reader);
    }

    public void setNCharacterStreamAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setNCharacterStreamAtName(parameterName, reader, length);
    }

    public void setNClobAtName(String parameterName, NClob value) throws SQLException {
        this.oracle.setNClobAtName(parameterName, value);
    }

    public void setNClobAtName(String parameterName, Reader reader) throws SQLException {
        this.oracle.setNClobAtName(parameterName, reader);
    }

    public void setNClobAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setNClobAtName(parameterName, reader, length);
    }

    public void setNStringAtName(String parameterName, String value) throws SQLException {
        this.oracle.setNStringAtName(parameterName, value);
    }

    public void setNUMBER(int parameterIndex, NUMBER value) throws SQLException {
        this.oracle.setNUMBER(parameterIndex, value);
    }

    public void setNUMBERAtName(String parameterName, NUMBER value) throws SQLException {
        this.oracle.setNUMBERAtName(parameterName, value);
    }

    public void setNullAtName(String parameterName, int value) throws SQLException {
        this.oracle.setNullAtName(parameterName, value);
    }

    public void setNullAtName(String parameterName, int sqlType, String sqlName) throws SQLException {
        this.oracle.setNullAtName(parameterName, sqlType, sqlName);
    }

    public void setOPAQUE(int parameterIndex, OPAQUE value) throws SQLException {
        this.oracle.setOPAQUE(parameterIndex, value);
    }

    public void setOPAQUEAtName(String parameterName, OPAQUE value) throws SQLException {
        this.oracle.setOPAQUEAtName(parameterName, value);
    }

    public void setORAData(int parameterIndex, ORAData value) throws SQLException {
        this.oracle.setORAData(parameterIndex, value);
    }

    public void setORADataAtName(String parameterName, ORAData value) throws SQLException {
        this.oracle.setORADataAtName(parameterName, value);
    }

    public void setObjectAtName(String parameterName, Object value) throws SQLException {
        this.oracle.setObjectAtName(parameterName, value);
    }

    public void setObjectAtName(String parameterName, Object value, int targetSqlType) throws SQLException {
        this.oracle.setObjectAtName(parameterName, value, targetSqlType);
    }

    public void setObjectAtName(String parameterName, Object value, int targetSqlType, int scale) throws SQLException {
        this.oracle.setObjectAtName(parameterName, value, targetSqlType, scale);
    }

    public void setOracleObject(int parameterIndex, Datum value) throws SQLException {
        this.oracle.setOracleObject(parameterIndex, value);
    }

    public void setOracleObjectAtName(String parameterName, Datum value) throws SQLException {
        this.oracle.setOracleObjectAtName(parameterName, value);
    }

    public void setPlsqlIndexTable(int parameterIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        this.oracle.setPlsqlIndexTable(parameterIndex, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
    }

    public void setRAW(int parameterIndex, RAW value) throws SQLException {
        this.oracle.setRAW(parameterIndex, value);
    }

    public void setRAWAtName(String parameterName, RAW value) throws SQLException {
        this.oracle.setRAWAtName(parameterName, value);
    }

    public void setREF(int parameterIndex, REF value) throws SQLException {
        this.oracle.setREF(parameterIndex, value);
    }

    public void setREFAtName(String parameterName, REF value) throws SQLException {
        this.oracle.setREFAtName(parameterName, value);
    }

    public void setROWID(int parameterIndex, ROWID value) throws SQLException {
        this.oracle.setROWID(parameterIndex, value);
    }

    public void setROWIDAtName(String parameterName, ROWID value) throws SQLException {
        this.oracle.setROWIDAtName(parameterName, value);
    }

    public void setRefAtName(String parameterName, Ref value) throws SQLException {
        this.oracle.setRefAtName(parameterName, value);
    }

    public void setRefType(int parameterIndex, REF value) throws SQLException {
        this.oracle.setRefType(parameterIndex, value);
    }

    public void setRefTypeAtName(String parameterName, REF value) throws SQLException {
        this.oracle.setRefTypeAtName(parameterName, value);
    }

    public void setRowIdAtName(String parameterName, RowId value) throws SQLException {
        this.oracle.setRowIdAtName(parameterName, value);
    }

    public void setSQLXMLAtName(String parameterName, SQLXML value) throws SQLException {
        this.oracle.setSQLXMLAtName(parameterName, value);
    }

    public void setSTRUCT(int parameterIndex, STRUCT value) throws SQLException {
        this.oracle.setSTRUCT(parameterIndex, value);
    }

    public void setSTRUCTAtName(String parameterName, STRUCT value) throws SQLException {
        this.oracle.setSTRUCTAtName(parameterName, value);
    }

    public void setShortAtName(String parameterName, short value) throws SQLException {
        this.oracle.setShortAtName(parameterName, value);
    }

    public void setStringAtName(String parameterName, String value) throws SQLException {
        this.oracle.setStringAtName(parameterName, value);
    }

    public void setStringForClob(int parameterIndex, String value) throws SQLException {
        this.oracle.setStringForClob(parameterIndex, value);
    }

    public void setStringForClobAtName(String parameterName, String value) throws SQLException {
        this.oracle.setStringForClobAtName(parameterName, value);
    }

    public void setStructDescriptor(int parameterIndex, StructDescriptor value) throws SQLException {
        this.oracle.setStructDescriptor(parameterIndex, value);
    }

    public void setStructDescriptorAtName(String parameterName, StructDescriptor value) throws SQLException {
        this.oracle.setStructDescriptorAtName(parameterName, value);
    }

    public void setTIMESTAMP(int parameterIndex, TIMESTAMP value) throws SQLException {
        this.oracle.setTIMESTAMP(parameterIndex, value);
    }

    public void setTIMESTAMPAtName(String parameterName, TIMESTAMP value) throws SQLException {
        this.oracle.setTIMESTAMPAtName(parameterName, value);
    }

    public void setTIMESTAMPLTZ(int parameterIndex, TIMESTAMPLTZ value) throws SQLException {
        this.oracle.setTIMESTAMPLTZ(parameterIndex, value);
    }

    public void setTIMESTAMPLTZAtName(String parameterName, TIMESTAMPLTZ value) throws SQLException {
        this.oracle.setTIMESTAMPLTZAtName(parameterName, value);
    }

    public void setTIMESTAMPTZ(int parameterIndex, TIMESTAMPTZ value) throws SQLException {
        this.oracle.setTIMESTAMPTZ(parameterIndex, value);
    }

    public void setTIMESTAMPTZAtName(String parameterName, TIMESTAMPTZ value) throws SQLException {
        this.oracle.setTIMESTAMPTZAtName(parameterName, value);
    }

    public void setTimeAtName(String parameterName, Time value) throws SQLException {
        this.oracle.setTimeAtName(parameterName, value);
    }

    public void setTimeAtName(String parameterName, Time value, Calendar cal) throws SQLException {
        this.oracle.setTimeAtName(parameterName, value, cal);
    }

    public void setTimestampAtName(String parameterName, Timestamp value) throws SQLException {
        this.oracle.setTimestampAtName(parameterName, value);
    }

    public void setTimestampAtName(String parameterName, Timestamp value, Calendar cal) throws SQLException {
        this.oracle.setTimestampAtName(parameterName, value, cal);
    }

    public void setURLAtName(String parameterName, URL value) throws SQLException {
        this.oracle.setURLAtName(parameterName, value);
    }

    public void setUnicodeStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
        this.oracle.setUnicodeStreamAtName(parameterName, stream, length);
    }

    public void clearDefines() throws SQLException {
        this.oracle.clearDefines();
    }

    public void closeWithKey(String key) throws SQLException {
        this.oracle.closeWithKey(key);
    }

    @Deprecated
    public int creationState() {
        return this.oracle.creationState();
    }

    public void defineColumnType(int columnIndex, int type) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type);
    }

    public void defineColumnType(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type, lobPrefetchSize);
    }

    public void defineColumnType(int columnIndex, int type, String typeName) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type, typeName);
    }

    @Deprecated
    public void defineColumnType(int columnIndex, int type, int lobPrefetchSize, short formOfUse) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type, lobPrefetchSize, formOfUse);
    }

    @Deprecated
    public void defineColumnTypeBytes(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.oracle.defineColumnTypeBytes(columnIndex, type, lobPrefetchSize);
    }

    @Deprecated
    public void defineColumnTypeChars(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.oracle.defineColumnTypeChars(columnIndex, type, lobPrefetchSize);
    }

    public int getLobPrefetchSize() throws SQLException {
        return this.oracle.getLobPrefetchSize();
    }

    public long getRegisteredQueryId() throws SQLException {
        return this.oracle.getRegisteredQueryId();
    }

    public String[] getRegisteredTableNames() throws SQLException {
        return this.oracle.getRegisteredTableNames();
    }

    public int getRowPrefetch() {
        return this.oracle.getRowPrefetch();
    }

    public boolean isNCHAR(int parameterIndex) throws SQLException {
        return this.oracle.isNCHAR(parameterIndex);
    }

    public void setDatabaseChangeRegistration(DatabaseChangeRegistration registration) throws SQLException {
        this.oracle.setDatabaseChangeRegistration(registration);
    }

    public void setLobPrefetchSize(int size) throws SQLException {
        this.oracle.setLobPrefetchSize(size);
    }

    public void setRowPrefetch(int size) throws SQLException {
        this.oracle.setRowPrefetch(size);
    }

    public ARRAY getARRAY(int parameterIndex) throws SQLException {
        return this.oracle.getARRAY(parameterIndex);
    }

    @Deprecated
    public Object getAnyDataEmbeddedObject(int parameterIndex) throws SQLException {
        return this.oracle.getAnyDataEmbeddedObject(parameterIndex);
    }

    public InputStream getAsciiStream(int parameterIndex) throws SQLException {
        return this.oracle.getAsciiStream(parameterIndex);
    }

    public BFILE getBFILE(int parameterIndex) throws SQLException {
        return this.oracle.getBFILE(parameterIndex);
    }

    public BLOB getBLOB(int parameterIndex) throws SQLException {
        return this.oracle.getBLOB(parameterIndex);
    }

    public BFILE getBfile(int parameterIndex) throws SQLException {
        return this.oracle.getBfile(parameterIndex);
    }

    public InputStream getBinaryStream(int parameterIndex) throws SQLException {
        return this.oracle.getBinaryStream(parameterIndex);
    }

    public InputStream getBinaryStream(String parameterName) throws SQLException {
        return this.oracle.getBinaryStream(parameterName);
    }

    public CHAR getCHAR(int parameterIndex) throws SQLException {
        return this.oracle.getCHAR(parameterIndex);
    }

    public CLOB getCLOB(int parameterIndex) throws SQLException {
        return this.oracle.getCLOB(parameterIndex);
    }

    @Deprecated
    public Object getCustomDatum(int parameterIndex, CustomDatumFactory factory) throws SQLException {
        return this.oracle.getCustomDatum(parameterIndex, factory);
    }

    public DATE getDATE(int parameterIndex) throws SQLException {
        return this.oracle.getDATE(parameterIndex);
    }

    public INTERVALDS getINTERVALDS(int parameterIndex) throws SQLException {
        return this.oracle.getINTERVALDS(parameterIndex);
    }

    public INTERVALYM getINTERVALYM(int parameterIndex) throws SQLException {
        return this.oracle.getINTERVALYM(parameterIndex);
    }

    public NUMBER getNUMBER(int parameterIndex) throws SQLException {
        return this.oracle.getNUMBER(parameterIndex);
    }

    public OPAQUE getOPAQUE(int parameterIndex) throws SQLException {
        return this.oracle.getOPAQUE(parameterIndex);
    }

    public Object getORAData(int parameterIndex, ORADataFactory factory) throws SQLException {
        return this.oracle.getORAData(parameterIndex, factory);
    }

    public Object getObject(int parameterIndex, OracleDataFactory factory) throws SQLException {
        return this.oracle.getObject(parameterIndex, factory);
    }

    public Datum getOracleObject(int parameterIndex) throws SQLException {
        return this.oracle.getOracleObject(parameterIndex);
    }

    public Datum[] getOraclePlsqlIndexTable(int parameterIndex) throws SQLException {
        return this.oracle.getOraclePlsqlIndexTable(parameterIndex);
    }

    public Object getPlsqlIndexTable(int paramIndex) throws SQLException {
        return this.oracle.getPlsqlIndexTable(paramIndex);
    }

    public Object getPlsqlIndexTable(int paramIndex, Class primitiveType) throws SQLException {
        return this.oracle.getPlsqlIndexTable(paramIndex, primitiveType);
    }

    public RAW getRAW(int parameterIndex) throws SQLException {
        return this.oracle.getRAW(parameterIndex);
    }

    public REF getREF(int parameterIndex) throws SQLException {
        return this.oracle.getREF(parameterIndex);
    }

    public ROWID getROWID(int parameterIndex) throws SQLException {
        return this.oracle.getROWID(parameterIndex);
    }

    public STRUCT getSTRUCT(int parameterIndex) throws SQLException {
        return this.oracle.getSTRUCT(parameterIndex);
    }

    public TIMESTAMP getTIMESTAMP(int parameterIndex) throws SQLException {
        return this.oracle.getTIMESTAMP(parameterIndex);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int parameterIndex) throws SQLException {
        return this.oracle.getTIMESTAMPLTZ(parameterIndex);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int parameterIndex) throws SQLException {
        return this.oracle.getTIMESTAMPTZ(parameterIndex);
    }

    public InputStream getUnicodeStream(int parameterIndex) throws SQLException {
        return this.oracle.getUnicodeStream(parameterIndex);
    }

    public InputStream getUnicodeStream(String parameterName) throws SQLException {
        return this.oracle.getUnicodeStream(parameterName);
    }

    public void registerIndexTableOutParameter(int parameterIndex, int maxLen, int elemSqlType, int elemMaxLen) throws SQLException {
        this.oracle.registerIndexTableOutParameter(parameterIndex, maxLen, elemSqlType, elemMaxLen);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale, int maxLength) throws SQLException {
        this.oracle.registerOutParameter(parameterIndex, sqlType, scale, maxLength);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale, int maxLength) throws SQLException {
        this.oracle.registerOutParameter(parameterName, sqlType, scale, maxLength);
    }

    @Deprecated
    public void registerOutParameterBytes(int parameterIndex, int sqlType, int scale, int maxLength) throws SQLException {
        this.oracle.registerOutParameterBytes(parameterIndex, sqlType, scale, maxLength);
    }

    @Deprecated
    public void registerOutParameterChars(int parameterIndex, int sqlType, int scale, int maxLength) throws SQLException {
        this.oracle.registerOutParameterChars(parameterIndex, sqlType, scale, maxLength);
    }

    public int sendBatch() throws SQLException {
        return this.oracle.sendBatch();
    }

    public void setARRAY(String parameterName, ARRAY x) throws SQLException {
        this.oracle.setARRAY(parameterName, x);
    }

    public void setArray(String parameterName, Array x) throws SQLException {
        this.oracle.setArray(parameterName, x);
    }

    public void setBFILE(String parameterName, BFILE x) throws SQLException {
        this.oracle.setBFILE(parameterName, x);
    }

    public void setBLOB(String parameterName, BLOB x) throws SQLException {
        this.oracle.setBLOB(parameterName, x);
    }

    public void setBfile(String parameterName, BFILE x) throws SQLException {
        this.oracle.setBfile(parameterName, x);
    }

    public void setBinaryDouble(String parameterName, BINARY_DOUBLE x) throws SQLException {
        this.oracle.setBinaryDouble(parameterName, x);
    }

    public void setBinaryDouble(String parameterName, double x) throws SQLException {
        this.oracle.setBinaryDouble(parameterName, x);
    }

    public void setBinaryFloat(String parameterName, BINARY_FLOAT x) throws SQLException {
        this.oracle.setBinaryFloat(parameterName, x);
    }

    public void setBinaryFloat(String parameterName, float x) throws SQLException {
        this.oracle.setBinaryFloat(parameterName, x);
    }

    public void setBytesForBlob(String parameterName, byte[] x) throws SQLException {
        this.oracle.setBytesForBlob(parameterName, x);
    }

    public void setCHAR(String parameterName, CHAR x) throws SQLException {
        this.oracle.setCHAR(parameterName, x);
    }

    public void setCLOB(String parameterName, CLOB x) throws SQLException {
        this.oracle.setCLOB(parameterName, x);
    }

    public void setCursor(String parameterName, ResultSet x) throws SQLException {
        this.oracle.setCursor(parameterName, x);
    }

    public void setCustomDatum(String parameterName, CustomDatum x) throws SQLException {
        this.oracle.setCustomDatum(parameterName, x);
    }

    public void setDATE(String parameterName, DATE x) throws SQLException {
        this.oracle.setDATE(parameterName, x);
    }

    @Deprecated
    public void setExecuteBatch(int nrows) throws SQLException {
        this.oracle.setExecuteBatch(nrows);
    }

    public void setFixedCHAR(String parameterName, String x) throws SQLException {
        this.oracle.setFixedCHAR(parameterName, x);
    }

    public void setINTERVALDS(String parameterName, INTERVALDS x) throws SQLException {
        this.oracle.setINTERVALDS(parameterName, x);
    }

    public void setINTERVALYM(String parameterName, INTERVALYM x) throws SQLException {
        this.oracle.setINTERVALYM(parameterName, x);
    }

    public void setNUMBER(String parameterName, NUMBER x) throws SQLException {
        this.oracle.setNUMBER(parameterName, x);
    }

    public void setOPAQUE(String parameterName, OPAQUE x) throws SQLException {
        this.oracle.setOPAQUE(parameterName, x);
    }

    public void setORAData(String parameterName, ORAData x) throws SQLException {
        this.oracle.setORAData(parameterName, x);
    }

    public void setOracleObject(String parameterName, Datum x) throws SQLException {
        this.oracle.setOracleObject(parameterName, x);
    }

    public void setRAW(String parameterName, RAW x) throws SQLException {
        this.oracle.setRAW(parameterName, x);
    }

    public void setREF(String parameterName, REF x) throws SQLException {
        this.oracle.setREF(parameterName, x);
    }

    public void setROWID(String parameterName, ROWID x) throws SQLException {
        this.oracle.setROWID(parameterName, x);
    }

    public void setRef(String parameterName, Ref x) throws SQLException {
        this.oracle.setRef(parameterName, x);
    }

    public void setRefType(String parameterName, REF x) throws SQLException {
        this.oracle.setRefType(parameterName, x);
    }

    public void setSTRUCT(String parameterName, STRUCT x) throws SQLException {
        this.oracle.setSTRUCT(parameterName, x);
    }

    public void setStringForClob(String parameterName, String x) throws SQLException {
        this.oracle.setStringForClob(parameterName, x);
    }

    public void setStructDescriptor(String parameterName, StructDescriptor x) throws SQLException {
        this.oracle.setStructDescriptor(parameterName, x);
    }

    public void setTIMESTAMP(String parameterName, TIMESTAMP x) throws SQLException {
        this.oracle.setTIMESTAMP(parameterName, x);
    }

    public void setTIMESTAMPLTZ(String parameterName, TIMESTAMPLTZ x) throws SQLException {
        this.oracle.setTIMESTAMPLTZ(parameterName, x);
    }

    public void setTIMESTAMPTZ(String parameterName, TIMESTAMPTZ x) throws SQLException {
        this.oracle.setTIMESTAMPTZ(parameterName, x);
    }

    public void setUnicodeStream(String parameterName, InputStream stream, int length) throws SQLException {
        this.oracle.setUnicodeStream(parameterName, stream, length);
    }

    public void registerOutParameterAtName(String parameterMarkerName, int sqlType) throws SQLException {
        this.oracle.registerOutParameterAtName(parameterMarkerName, sqlType);
    }

    public void registerOutParameterAtName(String parameterMarkerName, int sqlType, int scale) throws SQLException {
        this.oracle.registerOutParameterAtName(parameterMarkerName, sqlType, scale);
    }

    public void registerOutParameterAtName(String parameterMarkerName, int sqlType, String typeName) throws SQLException {
        this.oracle.registerOutParameterAtName(parameterMarkerName, sqlType, typeName);
    }
}

