/**
 * Copyright (c) 2018-present, A2 Rešitve d.o.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See
 * the License for the specific language governing permissions and limitations under the License.
 */

package solutions.a2.oracle.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

/**
 * 
 * Oracle JDBC Proxy PreparedStatement implementation
 * @author <a href="mailto:averemee@a2.solutions">Aleksei Veremeev</a>
 * 
 */
public class OraProxyPreparedStatement implements OraclePreparedStatement {

	final OracleConnection connection;
	final OraclePreparedStatement oracle;
	final OraProxySqlTranslator translator;

	OraProxyPreparedStatement(OracleConnection connection, OraclePreparedStatement statement, OraProxySqlTranslator translator) {
		this.connection = connection;
		this.oracle = statement;
		this.translator = translator;
	}

	@Override
	public ResultSet executeQuery(String sql) throws SQLException {
		return new OraProxyResultSet(this, (OracleResultSet) oracle.executeQuery(translator.translate(sql)));
	}

	@Override
	public int executeUpdate(String sql) throws SQLException {
		return oracle.executeUpdate(translator.translate(sql));
	}

	@Override
	public boolean execute(String sql) throws SQLException {
		return oracle.execute(translator.translate(sql));
	}

	@Override
	public void addBatch(String sql) throws SQLException {
		oracle.addBatch(translator.translate(sql));
	}

	@Override
	public Connection getConnection() throws SQLException {
		return connection;
	}

	@Override
	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		return oracle.executeUpdate(translator.translate(sql), autoGeneratedKeys);
	}

	@Override
	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		return oracle.executeUpdate(translator.translate(sql), columnIndexes);
	}

	@Override
	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		return oracle.executeUpdate(translator.translate(sql), columnNames);
	}

	@Override
	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		return oracle.execute(translator.translate(sql), autoGeneratedKeys);
	}

	@Override
	public boolean execute(String sql, int[] columnIndexes) throws SQLException {
		return oracle.execute(translator.translate(sql), columnIndexes);
	}

	@Override
	public boolean execute(String sql, String[] columnNames) throws SQLException {
		return oracle.execute(translator.translate(sql), columnNames);
	}

	@Override
	public ResultSet executeQuery() throws SQLException {
		return new OraProxyResultSet(this, (OracleResultSet) oracle.executeQuery());
	}

	@Override
	public ResultSet getResultSet() throws SQLException {
		return new OraProxyResultSet(this, (OracleResultSet) oracle.getResultSet());
	}

	@Override
	public ResultSet getGeneratedKeys() throws SQLException {
		return new OraProxyResultSet(this, (OracleResultSet) oracle.getGeneratedKeys());
	}

	@Override
	public ResultSet getReturnResultSet() throws SQLException {
		return new OraProxyResultSet(this, (OracleResultSet) oracle.getReturnResultSet());
	}

	@Override
	public void close() throws SQLException {
		oracle.close();
	}

	@Override
	public int getMaxFieldSize() throws SQLException {
		return oracle.getMaxFieldSize();
	}

	@Override
	public void setMaxFieldSize(int max) throws SQLException {
		oracle.setMaxFieldSize(max);
	}

	@Override
	public int getMaxRows() throws SQLException {
		return oracle.getMaxRows();
	}

	@Override
	public void setMaxRows(int max) throws SQLException {
		oracle.setMaxRows(max);
	}

	@Override
	public void setEscapeProcessing(boolean enable) throws SQLException {
		oracle.setEscapeProcessing(enable);
	}

	@Override
	public int getQueryTimeout() throws SQLException {
		return oracle.getQueryTimeout();
	}

	@Override
	public void setQueryTimeout(int seconds) throws SQLException {
		oracle.setQueryTimeout(seconds);
	}

	@Override
	public void cancel() throws SQLException {
		oracle.cancel();
	}

	@Override
	public SQLWarning getWarnings() throws SQLException {
		return oracle.getWarnings();
	}

	@Override
	public void clearWarnings() throws SQLException {
		oracle.clearWarnings();
	}

	@Override
	public void setCursorName(String name) throws SQLException {
		oracle.setCursorName(name);
	}

	@Override
	public int getUpdateCount() throws SQLException {
		return oracle.getUpdateCount();
	}

	@Override
	public boolean getMoreResults() throws SQLException {
		return oracle.getMoreResults();
	}

	@Override
	public void setFetchDirection(int direction) throws SQLException {
		oracle.setFetchDirection(direction);
	}

	@Override
	public int getFetchDirection() throws SQLException {
		return oracle.getFetchDirection();
	}

	@Override
	public void setFetchSize(int rows) throws SQLException {
		oracle.setFetchDirection(rows);
	}

	@Override
	public int getFetchSize() throws SQLException {
		return oracle.getFetchSize();
	}

	@Override
	public int getResultSetConcurrency() throws SQLException {
		return oracle.getResultSetConcurrency();
	}

	@Override
	public int getResultSetType() throws SQLException {
		return oracle.getResultSetType();
	}

	@Override
	public void clearBatch() throws SQLException {
		oracle.clearBatch();
	}

	@Override
	public int[] executeBatch() throws SQLException {
		return oracle.executeBatch();
	}

	@Override
	public boolean getMoreResults(int current) throws SQLException {
		return oracle.getMoreResults();
	}

	@Override
	public int getResultSetHoldability() throws SQLException {
		return oracle.getResultSetHoldability();
	}

	@Override
	public boolean isClosed() throws SQLException {
		return oracle.isClosed();
	}

	@Override
	public void setPoolable(boolean poolable) throws SQLException {
		oracle.setPoolable(poolable);
	}

	@Override
	public boolean isPoolable() throws SQLException {
		return oracle.isPoolable();
	}

	@Override
	public void closeOnCompletion() throws SQLException {
		oracle.closeOnCompletion();
	}

	@Override
	public boolean isCloseOnCompletion() throws SQLException {
		return oracle.isCloseOnCompletion();
	}

	@Override
	public <T> T unwrap(Class<T> iface) throws SQLException {
		return oracle.unwrap(iface);
	}

	@Override
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		return oracle.isWrapperFor(iface);
	}

	@Override
	public int executeUpdate() throws SQLException {
		return oracle.executeUpdate();
	}

	@Override
	public void setNull(int parameterIndex, int sqlType) throws SQLException {
		oracle.setNull(parameterIndex, sqlType);
	}

	@Override
	public void setBoolean(int parameterIndex, boolean x) throws SQLException {
		oracle.setBoolean(parameterIndex, x);
	}

	@Override
	public void setByte(int parameterIndex, byte x) throws SQLException {
		oracle.setByte(parameterIndex, x);
	}

	@Override
	public void setShort(int parameterIndex, short x) throws SQLException {
		oracle.setShort(parameterIndex, x);
	}

	@Override
	public void setInt(int parameterIndex, int x) throws SQLException {
		oracle.setInt(parameterIndex, x);
	}

	@Override
	public void setLong(int parameterIndex, long x) throws SQLException {
		oracle.setLong(parameterIndex, x);
	}

	@Override
	public void setFloat(int parameterIndex, float x) throws SQLException {
		oracle.setFloat(parameterIndex, x);
	}

	@Override
	public void setDouble(int parameterIndex, double x) throws SQLException {
		oracle.setDouble(parameterIndex, x);
	}

	@Override
	public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
		oracle.setBigDecimal(parameterIndex, x);
	}

	@Override
	public void setString(int parameterIndex, String x) throws SQLException {
		oracle.setString(parameterIndex, x);
	}

	@Override
	public void setBytes(int parameterIndex, byte[] x) throws SQLException {
		oracle.setBytes(parameterIndex, x);
	}

	@Override
	public void setDate(int parameterIndex, Date x) throws SQLException {
		oracle.setDate(parameterIndex, x);
	}

	@Override
	public void setTime(int parameterIndex, Time x) throws SQLException {
		oracle.setTime(parameterIndex, x);
	}

	@Override
	public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
		oracle.setTimestamp(parameterIndex, x);
	}

	@Override
	public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
		oracle.setAsciiStream(parameterIndex, x, length);
	}

	@Deprecated
	@Override
	public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
		oracle.setUnicodeStream(parameterIndex, x, length);
	}

	@Override
	public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
		oracle.setBinaryStream(parameterIndex, x, length);
	}

	@Override
	public void clearParameters() throws SQLException {
		oracle.clearParameters();
		
	}

	@Override
	public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
		oracle.setObject(parameterIndex, x, targetSqlType);
	}

	@Override
	public void setObject(int parameterIndex, Object x) throws SQLException {
		oracle.setObject(parameterIndex, x);
	}

	@Override
	public boolean execute() throws SQLException {
		return oracle.execute();
	}

	@Override
	public void addBatch() throws SQLException {
		oracle.addBatch();
	}

	@Override
	public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
		oracle.setCharacterStream(parameterIndex, reader, length);
	}

	@Override
	public void setRef(int parameterIndex, Ref x) throws SQLException {
		oracle.setRef(parameterIndex, x);
	}

	@Override
	public void setBlob(int parameterIndex, Blob x) throws SQLException {
		oracle.setBlob(parameterIndex, x);
	}

	@Override
	public void setClob(int parameterIndex, Clob x) throws SQLException {
		oracle.setClob(parameterIndex, x);
	}

	@Override
	public void setArray(int parameterIndex, Array x) throws SQLException {
		oracle.setArray(parameterIndex, x);
	}

	@Override
	public ResultSetMetaData getMetaData() throws SQLException {
		return oracle.getMetaData();
	}

	@Override
	public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
		oracle.setDate(parameterIndex, x, cal);
	}

	@Override
	public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
		oracle.setTime(parameterIndex, x, cal);
	}

	@Override
	public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
		oracle.setTimestamp(parameterIndex, x, cal);
	}

	@Override
	public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
		oracle.setNull(parameterIndex, sqlType, typeName);
	}

	@Override
	public void setURL(int parameterIndex, URL x) throws SQLException {
		oracle.setURL(parameterIndex, x);
	}

	@Override
	public ParameterMetaData getParameterMetaData() throws SQLException {
		return oracle.getParameterMetaData();
	}

	@Override
	public void setRowId(int parameterIndex, RowId x) throws SQLException {
		oracle.setRowId(parameterIndex, x);
	}

	@Override
	public void setNString(int parameterIndex, String value) throws SQLException {
		oracle.setNString(parameterIndex, value);
	}

	@Override
	public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
		oracle.setNCharacterStream(parameterIndex, value, length);
	}

	@Override
	public void setNClob(int parameterIndex, NClob value) throws SQLException {
		oracle.setNClob(parameterIndex, value);
	}

	@Override
	public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
		oracle.setClob(parameterIndex, reader, length);
	}

	@Override
	public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
		oracle.setBlob(parameterIndex, inputStream, length);
	}

	@Override
	public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
		oracle.setNClob(parameterIndex, reader, length);
	}

	@Override
	public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
		oracle.setSQLXML(parameterIndex, xmlObject);
	}

	@Override
	public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
		oracle.setObject(parameterIndex, x, scaleOrLength);
	}

	@Override
	public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
		oracle.setAsciiStream(parameterIndex, x, length);
	}

	@Override
	public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
		oracle.setBinaryStream(parameterIndex, x, length);
	}

	@Override
	public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
		oracle.setCharacterStream(parameterIndex, reader, length);
	}

	@Override
	public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
		oracle.setAsciiStream(parameterIndex, x);
	}

	@Override
	public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
		oracle.setBinaryStream(parameterIndex, x);
	}

	@Override
	public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
		oracle.setCharacterStream(parameterIndex, reader);
	}

	@Override
	public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
		oracle.setNCharacterStream(parameterIndex, value);
	}

	@Override
	public void setClob(int parameterIndex, Reader reader) throws SQLException {
		oracle.setClob(parameterIndex, reader);
	}

	@Override
	public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
		oracle.setBlob(parameterIndex, inputStream);
	}

	@Override
	public void setNClob(int parameterIndex, Reader reader) throws SQLException {
		oracle.setNClob(parameterIndex, reader);
	}

	@Override
	public void clearDefines() throws SQLException {
		oracle.clearDefines();
	}

	@Override
	public void closeWithKey(String key) throws SQLException {
		oracle.closeWithKey(key);
	}

	@Deprecated
	@Override
	public int creationState() {
		return oracle.creationState();
	}

	@Override
	public void defineColumnType(int columnIndex, int type) throws SQLException {
		oracle.defineColumnType(columnIndex, type);
	}

	@Override
	public void defineColumnType(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
		oracle.defineColumnType(columnIndex, type, lobPrefetchSize);		
	}

	@Override
	public void defineColumnType(int columnIndex, int type, String typeName) throws SQLException {
		oracle.defineColumnType(columnIndex, type, typeName);
	}

	@Deprecated
	@Override
	public void defineColumnType(int columnIndex, int type, int lobPrefetchSize, short formOfUse) throws SQLException {
		oracle.defineColumnType(columnIndex, type, lobPrefetchSize, formOfUse);
	}

	@Deprecated
	@Override
	public void defineColumnTypeBytes(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
		oracle.defineColumnTypeBytes(columnIndex, type, lobPrefetchSize);
	}

	@Deprecated
	@Override
	public void defineColumnTypeChars(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
		oracle.defineColumnTypeChars(columnIndex, type, lobPrefetchSize);
	}

	@Override
	public int getLobPrefetchSize() throws SQLException {
		return oracle.getLobPrefetchSize();
	}

	@Override
	public long getRegisteredQueryId() throws SQLException {
		return oracle.getRegisteredQueryId();
	}

	@Override
	public String[] getRegisteredTableNames() throws SQLException {
		return oracle.getRegisteredTableNames();
	}

	@Override
	public int getRowPrefetch() {
		return oracle.getRowPrefetch();
	}

	@Override
	public boolean isNCHAR(int index) throws SQLException {
		return oracle.isNCHAR(index);
	}

	@Override
	public void setDatabaseChangeRegistration(DatabaseChangeRegistration registration) throws SQLException {
		oracle.setDatabaseChangeRegistration(registration);
	}

	@Override
	public void setLobPrefetchSize(int size) throws SQLException {
		oracle.setLobPrefetchSize(size);
	}

	@Override
	public void setRowPrefetch(int size) throws SQLException {
		oracle.setRowPrefetch(size);
	}

	@Override
	public OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
		return oracle.OracleGetParameterMetaData();
	}

	@Override
	public void defineParameterType(int parameterIndex, int type, int maxSize) throws SQLException {
		oracle.defineParameterType(parameterIndex, type, maxSize);
	}

	@Override
	public void defineParameterTypeBytes(int parameterIndex, int type, int maxSize) throws SQLException {
		oracle.defineParameterTypeBytes(parameterIndex, type, maxSize);
	}

	@Override
	public void defineParameterTypeChars(int parameterIndex, int type, int maxSize) throws SQLException {
		oracle.defineParameterTypeChars(parameterIndex, type, maxSize);
	}

	@Deprecated
	@Override
	public int getExecuteBatch() {
		return oracle.getExecuteBatch();
	}

	@Override
	public void registerReturnParameter(int parameterIndex, int externalType) throws SQLException {
		oracle.registerReturnParameter(parameterIndex, externalType);
	}

	@Override
	public void registerReturnParameter(int parameterIndex, int externalType, int maxSize) throws SQLException {
		oracle.registerReturnParameter(parameterIndex, externalType, maxSize);
	}

	@Override
	public void registerReturnParameter(int parameterIndex, int externalType, String typeName) throws SQLException {
		oracle.registerReturnParameter(parameterIndex, externalType, typeName);
	}

	@Deprecated
	@Override
	public int sendBatch() throws SQLException {
		return oracle.sendBatch();
	}

	@Override
	public void setARRAY(int parameterIndex, ARRAY value) throws SQLException {
		oracle.setARRAY(parameterIndex, value);
	}

	@Override
	public void setARRAYAtName(String parameterName, ARRAY value) throws SQLException {
		oracle.setARRAYAtName(parameterName, value);
	}

	@Override
	public void setArrayAtName(String parameterName, Array value) throws SQLException {
		oracle.setArrayAtName(parameterName, value);
	}

	@Override
	public void setAsciiStreamAtName(String parameterName, InputStream stream) throws SQLException {
		oracle.setAsciiStreamAtName(parameterName, stream);
	}

	@Override
	public void setAsciiStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
		oracle.setAsciiStreamAtName(parameterName, stream, length);
	}

	@Override
	public void setAsciiStreamAtName(String parameterName, InputStream stream, long length) throws SQLException {
		oracle.setAsciiStreamAtName(parameterName, stream, length);
	}

	@Override
	public void setBFILE(int parameterIndex, BFILE value) throws SQLException {
		oracle.setBFILE(parameterIndex, value);
	}

	@Override
	public void setBFILEAtName(String parameterName, BFILE value) throws SQLException {
		oracle.setBFILEAtName(parameterName, value);
	}

	@Override
	public void setBLOB(int parameterIndex, BLOB value) throws SQLException {
		oracle.setBLOB(parameterIndex, value);
	}

	@Override
	public void setBLOBAtName(String parameterName, BLOB value) throws SQLException {
		oracle.setBLOBAtName(parameterName, value);
	}

	@Override
	public void setBfile(int parameterIndex, BFILE value) throws SQLException {
		oracle.setBfile(parameterIndex, value);
	}

	@Override
	public void setBfileAtName(String parameterName, BFILE value) throws SQLException {
		oracle.setBfileAtName(parameterName, value);
	}

	@Override
	public void setBigDecimalAtName(String parameterName, BigDecimal value) throws SQLException {
		oracle.setBigDecimalAtName(parameterName, value);
	}

	@Override
	public void setBinaryDouble(int parameterIndex, double value) throws SQLException {
		oracle.setBinaryDouble(parameterIndex, value);
	}

	@Override
	public void setBinaryDouble(int parameterIndex, BINARY_DOUBLE value) throws SQLException {
		oracle.setBinaryDouble(parameterIndex, value);
	}

	@Override
	public void setBinaryDoubleAtName(String parameterName, double value) throws SQLException {
		oracle.setBinaryDoubleAtName(parameterName, value);
	}

	@Override
	public void setBinaryDoubleAtName(String parameterName, BINARY_DOUBLE value) throws SQLException {
		oracle.setBinaryDoubleAtName(parameterName, value);
	}

	@Override
	public void setBinaryFloat(int parameterIndex, float value) throws SQLException {
		oracle.setBinaryFloat(parameterIndex, value);
	}

	@Override
	public void setBinaryFloat(int parameterIndex, BINARY_FLOAT value) throws SQLException {
		oracle.setBinaryFloat(parameterIndex, value);
	}

	@Override
	public void setBinaryFloatAtName(String parameterName, float value) throws SQLException {
		oracle.setBinaryFloatAtName(parameterName, value);
	}

	@Override
	public void setBinaryFloatAtName(String parameterName, BINARY_FLOAT value) throws SQLException {
		oracle.setBinaryFloatAtName(parameterName, value);
	}

	@Override
	public void setBinaryStreamAtName(String parameterName, InputStream stream) throws SQLException {
		oracle.setBinaryStreamAtName(parameterName, stream);
	}

	@Override
	public void setBinaryStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
		oracle.setBinaryStreamAtName(parameterName, stream, length);
	}

	@Override
	public void setBinaryStreamAtName(String parameterName, InputStream stream, long length) throws SQLException {
		oracle.setBinaryStreamAtName(parameterName, stream, length);
	}

	@Override
	public void setBlobAtName(String parameterName, Blob value) throws SQLException {
		oracle.setBlobAtName(parameterName, value);
	}

	@Override
	public void setBlobAtName(String parameterName, InputStream stream) throws SQLException {
		oracle.setBlobAtName(parameterName, stream);
	}

	@Override
	public void setBlobAtName(String parameterName, InputStream stream, long length) throws SQLException {
		oracle.setBlobAtName(parameterName, stream, length);
	}

	@Override
	public void setBooleanAtName(String parameterName, boolean value) throws SQLException {
		oracle.setBooleanAtName(parameterName, value);
	}

	@Override
	public void setByteAtName(String parameterName, byte value) throws SQLException {
		oracle.setByteAtName(parameterName, value);
	}

	@Override
	public void setBytesAtName(String parameterName, byte[] value) throws SQLException {
		oracle.setBytesAtName(parameterName, value);
	}

	@Override
	public void setBytesForBlob(int parameterIndex, byte[] value) throws SQLException {
		oracle.setBytesForBlob(parameterIndex, value);
	}

	@Override
	public void setBytesForBlobAtName(String parameterName, byte[] value) throws SQLException {
		oracle.setBytesForBlobAtName(parameterName, value);
	}

	@Override
	public void setCHAR(int parameterIndex, CHAR value) throws SQLException {
		oracle.setCHAR(parameterIndex, value);
	}

	@Override
	public void setCHARAtName(String parameterName, CHAR value) throws SQLException {
		oracle.setCHARAtName(parameterName, value);
	}

	@Override
	public void setCLOB(int parameterIndex, CLOB value) throws SQLException {
		oracle.setCLOB(parameterIndex, value);
	}

	@Override
	public void setCLOBAtName(String parameterName, CLOB value) throws SQLException {
		oracle.setCLOBAtName(parameterName, value);
	}

	@Override
	public void setCharacterStreamAtName(String parameterName, Reader reader) throws SQLException {
		oracle.setCharacterStreamAtName(parameterName, reader);
	}

	@Override
	public void setCharacterStreamAtName(String parameterName, Reader reader, long length) throws SQLException {
		oracle.setCharacterStreamAtName(parameterName, reader, length);
	}

	@Override
	public void setCheckBindTypes(boolean flag) {
		oracle.setCheckBindTypes(flag);
	}

	@Override
	public void setClobAtName(String parameterName, Clob value) throws SQLException {
		oracle.setClobAtName(parameterName, value);
	}

	@Override
	public void setClobAtName(String parameterName, Reader reader) throws SQLException {
		oracle.setClobAtName(parameterName, reader);
	}

	@Override
	public void setClobAtName(String parameterName, Reader reader, long length) throws SQLException {
		oracle.setClobAtName(parameterName, reader, length);
	}

	@Deprecated
	@Override
	public void setCursor(int parameterIndex, ResultSet value) throws SQLException {
		oracle.setCursor(parameterIndex, value);
	}

	@Override
	public void setCursorAtName(String parameterName, ResultSet value) throws SQLException {
		oracle.setCursorAtName(parameterName, value);
	}

	@Deprecated
	@Override
	public void setCustomDatum(int parameterIndex, CustomDatum value) throws SQLException {
		oracle.setCustomDatum(parameterIndex, value);
	}

	@Override
	public void setCustomDatumAtName(String parameterName, CustomDatum value) throws SQLException {
		oracle.setCustomDatumAtName(parameterName, value);
	}

	@Override
	public void setDATE(int parameterIndex, DATE value) throws SQLException {
		oracle.setDATE(parameterIndex, value);
	}

	@Override
	public void setDATEAtName(String parameterName, DATE value) throws SQLException {
		oracle.setDATEAtName(parameterName, value);
	}

	@Override
	public void setDateAtName(String parameterName, Date value) throws SQLException {
		oracle.setDateAtName(parameterName, value);
	}

	@Override
	public void setDateAtName(String parameterName, Date value, Calendar cal) throws SQLException {
		oracle.setDateAtName(parameterName, value, cal);
	}

	@Override
	public void setDisableStmtCaching(boolean cache) {
		oracle.setDisableStmtCaching(cache);
	}

	@Override
	public void setDoubleAtName(String parameterName, double value) throws SQLException {
		oracle.setDoubleAtName(parameterName, value);
	}

	@Deprecated
	@Override
	public void setExecuteBatch(int batchValue) throws SQLException {
		oracle.setExecuteBatch(batchValue);
	}

	@Override
	public void setFixedCHAR(int parameterIndex, String value) throws SQLException {
		oracle.setFixedCHAR(parameterIndex, value);
	}

	@Override
	public void setFixedCHARAtName(String parameterName, String value) throws SQLException {
		oracle.setFixedCHARAtName(parameterName, value);
	}

	@Override
	public void setFloatAtName(String parameterName, float value) throws SQLException {
		oracle.setFloatAtName(parameterName, value);
	}

	@Override
	public void setFormOfUse(int parameterIndex, short formOfUse) {
		oracle.setFormOfUse(parameterIndex, formOfUse);
	}

	@Override
	public void setINTERVALDS(int parameterIndex, INTERVALDS value) throws SQLException {
		oracle.setINTERVALDS(parameterIndex, value);
	}

	@Override
	public void setINTERVALDSAtName(String parameterName, INTERVALDS value) throws SQLException {
		oracle.setINTERVALDSAtName(parameterName, value);
	}

	@Override
	public void setINTERVALYM(int parameterIndex, INTERVALYM value) throws SQLException {
		oracle.setINTERVALYM(parameterIndex, value);
	}

	@Override
	public void setINTERVALYMAtName(String parameterName, INTERVALYM value) throws SQLException {
		oracle.setINTERVALYMAtName(parameterName, value);
	}

	@Override
	public void setIntAtName(String parameterName, int value) throws SQLException {
		oracle.setIntAtName(parameterName, value);
	}

	@Override
	public void setLongAtName(String parameterName, long value) throws SQLException {
		oracle.setLongAtName(parameterName, value);
	}

	@Override
	public void setNCharacterStreamAtName(String parameterName, Reader reader) throws SQLException {
		oracle.setNCharacterStreamAtName(parameterName, reader);
	}

	@Override
	public void setNCharacterStreamAtName(String parameterName, Reader reader, long length) throws SQLException {
		oracle.setNCharacterStreamAtName(parameterName, reader, length);
	}

	@Override
	public void setNClobAtName(String parameterName, NClob value) throws SQLException {
		oracle.setNClobAtName(parameterName, value);
	}

	@Override
	public void setNClobAtName(String parameterName, Reader reader) throws SQLException {
		oracle.setNClobAtName(parameterName, reader);
	}

	@Override
	public void setNClobAtName(String parameterName, Reader reader, long length) throws SQLException {
		oracle.setNClobAtName(parameterName, reader, length);
	}

	@Override
	public void setNStringAtName(String parameterName, String value) throws SQLException {
		oracle.setNStringAtName(parameterName, value);
	}

	@Override
	public void setNUMBER(int parameterIndex, NUMBER value) throws SQLException {
		oracle.setNUMBER(parameterIndex, value);
	}

	@Override
	public void setNUMBERAtName(String parameterName, NUMBER value) throws SQLException {
		oracle.setNUMBERAtName(parameterName, value);
	}

	@Override
	public void setNullAtName(String parameterName, int value) throws SQLException {
		oracle.setNullAtName(parameterName, value);
	}

	@Override
	public void setNullAtName(String parameterName, int sqlType, String sqlName) throws SQLException {
		oracle.setNullAtName(parameterName, sqlType, sqlName);
	}

	@Override
	public void setOPAQUE(int parameterIndex, OPAQUE value) throws SQLException {
		oracle.setOPAQUE(parameterIndex, value);
	}

	@Override
	public void setOPAQUEAtName(String parameterName, OPAQUE value) throws SQLException {
		oracle.setOPAQUEAtName(parameterName, value);
	}

	@Override
	public void setORAData(int parameterIndex, ORAData value) throws SQLException {
		oracle.setORAData(parameterIndex, value);
	}

	@Override
	public void setORADataAtName(String parameterName, ORAData value) throws SQLException {
		oracle.setORADataAtName(parameterName, value);
	}

	@Override
	public void setObjectAtName(String parameterName, Object value) throws SQLException {
		oracle.setObjectAtName(parameterName, value);
	}

	@Override
	public void setObjectAtName(String parameterName, Object value, int targetSqlType) throws SQLException {
		oracle.setObjectAtName(parameterName, value, targetSqlType);
	}

	@Override
	public void setObjectAtName(String parameterName, Object value, int targetSqlType, int scale) throws SQLException {
		oracle.setObjectAtName(parameterName, value, targetSqlType, scale);
	}

	@Override
	public void setOracleObject(int parameterIndex, Datum value) throws SQLException {
		oracle.setOracleObject(parameterIndex, value);
	}

	@Override
	public void setOracleObjectAtName(String parameterName, Datum value) throws SQLException {
		oracle.setOracleObjectAtName(parameterName, value);
	}

	@Override
	public void setPlsqlIndexTable(int parameterIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
		oracle.setPlsqlIndexTable(parameterIndex, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
	}

	@Override
	public void setRAW(int parameterIndex, RAW value) throws SQLException {
		oracle.setRAW(parameterIndex, value);
	}

	@Override
	public void setRAWAtName(String parameterName, RAW value) throws SQLException {
		oracle.setRAWAtName(parameterName, value);
	}

	@Override
	public void setREF(int parameterIndex, REF value) throws SQLException {
		oracle.setREF(parameterIndex, value);
	}

	@Override
	public void setREFAtName(String parameterName, REF value) throws SQLException {
		oracle.setREFAtName(parameterName, value);
	}

	@Override
	public void setROWID(int parameterIndex, ROWID value) throws SQLException {
		oracle.setROWID(parameterIndex, value);
	}

	@Override
	public void setROWIDAtName(String parameterName, ROWID value) throws SQLException {
		oracle.setROWIDAtName(parameterName, value);
	}

	@Override
	public void setRefAtName(String parameterName, Ref value) throws SQLException {
		oracle.setRefAtName(parameterName, value);
	}

	@Override
	public void setRefType(int parameterIndex, REF value) throws SQLException {
		oracle.setRefType(parameterIndex, value);
	}

	@Override
	public void setRefTypeAtName(String parameterName, REF value) throws SQLException {
		oracle.setRefTypeAtName(parameterName, value);
	}

	@Override
	public void setRowIdAtName(String parameterName, RowId value) throws SQLException {
		oracle.setRowIdAtName(parameterName, value);
	}

	@Override
	public void setSQLXMLAtName(String parameterName, SQLXML value) throws SQLException {
		oracle.setSQLXMLAtName(parameterName, value);
	}

	@Override
	public void setSTRUCT(int parameterIndex, STRUCT value) throws SQLException {
		oracle.setSTRUCT(parameterIndex, value);
	}

	@Override
	public void setSTRUCTAtName(String parameterName, STRUCT value) throws SQLException {
		oracle.setSTRUCTAtName(parameterName, value);
	}

	@Override
	public void setShortAtName(String parameterName, short value) throws SQLException {
		oracle.setShortAtName(parameterName, value);
	}

	@Override
	public void setStringAtName(String parameterName, String value) throws SQLException {
		oracle.setStringAtName(parameterName, value);
	}

	@Override
	public void setStringForClob(int parameterIndex, String value) throws SQLException {
		oracle.setStringForClob(parameterIndex, value);
	}

	@Override
	public void setStringForClobAtName(String parameterName, String value) throws SQLException {
		oracle.setStringForClobAtName(parameterName, value);
	}

	@Override
	public void setStructDescriptor(int parameterIndex, StructDescriptor value) throws SQLException {
		oracle.setStructDescriptor(parameterIndex, value);
	}

	@Override
	public void setStructDescriptorAtName(String parameterName, StructDescriptor value) throws SQLException {
		oracle.setStructDescriptorAtName(parameterName, value);
	}

	@Override
	public void setTIMESTAMP(int parameterIndex, TIMESTAMP value) throws SQLException {
		oracle.setTIMESTAMP(parameterIndex, value);
	}

	@Override
	public void setTIMESTAMPAtName(String parameterName, TIMESTAMP value) throws SQLException {
		oracle.setTIMESTAMPAtName(parameterName, value);
	}

	@Override
	public void setTIMESTAMPLTZ(int parameterIndex, TIMESTAMPLTZ value) throws SQLException {
		oracle.setTIMESTAMPLTZ(parameterIndex, value);
	}

	@Override
	public void setTIMESTAMPLTZAtName(String parameterName, TIMESTAMPLTZ value) throws SQLException {
		oracle.setTIMESTAMPLTZAtName(parameterName, value);
	}

	@Override
	public void setTIMESTAMPTZ(int parameterIndex, TIMESTAMPTZ value) throws SQLException {
		oracle.setTIMESTAMPTZ(parameterIndex, value);
	}

	@Override
	public void setTIMESTAMPTZAtName(String parameterName, TIMESTAMPTZ value) throws SQLException {
		oracle.setTIMESTAMPTZAtName(parameterName, value);
	}

	@Override
	public void setTimeAtName(String parameterName, Time value) throws SQLException {
		oracle.setTimeAtName(parameterName, value);
	}

	@Override
	public void setTimeAtName(String parameterName, Time value, Calendar cal) throws SQLException {
		oracle.setTimeAtName(parameterName, value, cal);
	}

	@Override
	public void setTimestampAtName(String parameterName, Timestamp value) throws SQLException {
		oracle.setTimestampAtName(parameterName, value);
	}

	@Override
	public void setTimestampAtName(String parameterName, Timestamp value, Calendar cal) throws SQLException {
		oracle.setTimestampAtName(parameterName, value, cal);
	}

	@Override
	public void setURLAtName(String parameterName, URL value) throws SQLException {
		oracle.setURLAtName(parameterName, value);
	}

	@Override
	public void setUnicodeStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
		oracle.setUnicodeStreamAtName(parameterName, stream, length);
	}

}
