/*
 * Decompiled with CFR 0.152.
 */
package solutions.a2.oracle.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import solutions.a2.oracle.jdbc.OraProxyResultSet;
import solutions.a2.oracle.jdbc.OraProxySqlTranslator;

public class OraProxyStatement
implements OracleStatement {
    final OracleConnection connection;
    final OracleStatement oracle;
    final OraProxySqlTranslator translator;

    OraProxyStatement(OracleConnection connection, OracleStatement statement, OraProxySqlTranslator translator) {
        this.connection = connection;
        this.oracle = statement;
        this.translator = translator;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return new OraProxyResultSet((Statement)((Object)this), (OracleResultSet)this.oracle.executeQuery(this.translator.translate(sql)));
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql));
    }

    public boolean execute(String sql) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql));
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql), autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql), columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql), columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql), autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql), columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql), columnNames);
    }

    public ResultSet getResultSet() throws SQLException {
        return new OraProxyResultSet((Statement)((Object)this), (OracleResultSet)this.oracle.getResultSet());
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return new OraProxyResultSet((Statement)((Object)this), (OracleResultSet)this.oracle.getGeneratedKeys());
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.oracle.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.oracle.isWrapperFor(iface);
    }

    public void close() throws SQLException {
        this.oracle.close();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.oracle.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.oracle.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.oracle.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.oracle.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.oracle.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.oracle.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.oracle.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.oracle.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.oracle.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.oracle.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.oracle.setCursorName(name);
    }

    public int getUpdateCount() throws SQLException {
        return this.oracle.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.oracle.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.oracle.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.oracle.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.oracle.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.oracle.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.oracle.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.oracle.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.oracle.addBatch(this.translator.translate(sql));
    }

    public void clearBatch() throws SQLException {
        this.oracle.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.oracle.executeBatch();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.oracle.getMoreResults(current);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.oracle.getResultSetHoldability();
    }

    public boolean isClosed() throws SQLException {
        return this.oracle.isClosed();
    }

    public void setPoolable(boolean poolable) throws SQLException {
        this.oracle.setPoolable(poolable);
    }

    public boolean isPoolable() throws SQLException {
        return this.oracle.isPoolable();
    }

    public void closeOnCompletion() throws SQLException {
        this.oracle.closeOnCompletion();
    }

    public boolean isCloseOnCompletion() throws SQLException {
        return this.oracle.isCloseOnCompletion();
    }

    public void clearDefines() throws SQLException {
        this.oracle.clearDefines();
    }

    public void closeWithKey(String key) throws SQLException {
        this.oracle.closeWithKey(key);
    }

    @Deprecated
    public int creationState() {
        return this.oracle.creationState();
    }

    public void defineColumnType(int columnIndex, int type) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type);
    }

    public void defineColumnType(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type, lobPrefetchSize);
    }

    public void defineColumnType(int columnIndex, int type, String typeName) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type, typeName);
    }

    @Deprecated
    public void defineColumnType(int columnIndex, int type, int lobPrefetchSize, short formOfUse) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type, lobPrefetchSize, formOfUse);
    }

    @Deprecated
    public void defineColumnTypeBytes(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.oracle.defineColumnTypeBytes(columnIndex, type, lobPrefetchSize);
    }

    @Deprecated
    public void defineColumnTypeChars(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.oracle.defineColumnTypeChars(columnIndex, type, lobPrefetchSize);
    }

    public int getLobPrefetchSize() throws SQLException {
        return this.oracle.getLobPrefetchSize();
    }

    public long getRegisteredQueryId() throws SQLException {
        return this.oracle.getRegisteredQueryId();
    }

    public String[] getRegisteredTableNames() throws SQLException {
        return this.oracle.getRegisteredTableNames();
    }

    public int getRowPrefetch() {
        return this.oracle.getRowPrefetch();
    }

    public boolean isNCHAR(int index) throws SQLException {
        return this.oracle.isNCHAR(index);
    }

    public void setDatabaseChangeRegistration(DatabaseChangeRegistration registration) throws SQLException {
        this.oracle.setDatabaseChangeRegistration(registration);
    }

    public void setLobPrefetchSize(int size) throws SQLException {
        this.oracle.setLobPrefetchSize(size);
    }

    public void setRowPrefetch(int size) throws SQLException {
        this.oracle.setRowPrefetch(size);
    }
}

