/*
 * Decompiled with CFR 0.152.
 */
package solutions.a2.oracle.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQNotificationRegistration;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.sql.ARRAY;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;
import solutions.a2.oracle.jdbc.OraProxyCallableStatement;
import solutions.a2.oracle.jdbc.OraProxyPreparedStatement;
import solutions.a2.oracle.jdbc.OraProxySqlTranslator;
import solutions.a2.oracle.jdbc.OraProxyStatement;

public class OraProxyConnection
implements oracle.jdbc.OracleConnection {
    final oracle.jdbc.OracleConnection oracle;
    final OraProxySqlTranslator translator;

    OraProxyConnection(oracle.jdbc.OracleConnection connection, OraProxySqlTranslator translator) {
        this.oracle = connection;
        this.translator = translator;
    }

    public Statement createStatement() throws SQLException {
        return new OraProxyStatement(this, (OracleStatement)this.oracle.createStatement(), this.translator);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new OraProxyStatement(this, (OracleStatement)this.oracle.createStatement(resultSetType, resultSetConcurrency), this.translator);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new OraProxyStatement(this, (OracleStatement)this.oracle.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this.translator);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return new OraProxyCallableStatement(this, (OracleCallableStatement)this.oracle.prepareCall(this.translator.translate(sql)), this.translator);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new OraProxyCallableStatement(this, (OracleCallableStatement)this.oracle.prepareCall(this.translator.translate(sql), resultSetType, resultSetConcurrency), this.translator);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new OraProxyCallableStatement(this, (OracleCallableStatement)this.oracle.prepareCall(this.translator.translate(sql), resultSetType, resultSetConcurrency, resultSetHoldability), this.translator);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new OraProxyPreparedStatement(this, (OraclePreparedStatement)this.oracle.prepareStatement(this.translator.translate(sql)), this.translator);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new OraProxyPreparedStatement(this, (OraclePreparedStatement)this.oracle.prepareStatement(this.translator.translate(sql), resultSetType, resultSetConcurrency), this.translator);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new OraProxyPreparedStatement(this, (OraclePreparedStatement)this.oracle.prepareStatement(this.translator.translate(sql), resultSetType, resultSetConcurrency, resultSetHoldability), this.translator);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new OraProxyPreparedStatement(this, (OraclePreparedStatement)this.oracle.prepareStatement(this.translator.translate(sql), autoGeneratedKeys), this.translator);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new OraProxyPreparedStatement(this, (OraclePreparedStatement)this.oracle.prepareStatement(this.translator.translate(sql), columnIndexes), this.translator);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new OraProxyPreparedStatement(this, (OraclePreparedStatement)this.oracle.prepareStatement(this.translator.translate(sql), columnNames), this.translator);
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.oracle.nativeSQL(this.translator.translate(sql));
    }

    public PreparedStatement getStatementWithKey(String key) throws SQLException {
        return new OraProxyPreparedStatement(this, (OraclePreparedStatement)this.oracle.getStatementWithKey(key), this.translator);
    }

    @Deprecated
    public CallableStatement prepareCallWithKey(String key) throws SQLException {
        return new OraProxyCallableStatement(this, (OracleCallableStatement)this.oracle.prepareCallWithKey(key), this.translator);
    }

    @Deprecated
    public PreparedStatement prepareStatementWithKey(String key) throws SQLException {
        return new OraProxyPreparedStatement(this, (OraclePreparedStatement)this.oracle.prepareStatementWithKey(key), this.translator);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.oracle.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.oracle.isWrapperFor(iface);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.oracle.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.oracle.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.oracle.commit();
    }

    public void rollback() throws SQLException {
        this.oracle.rollback();
    }

    public void close() throws SQLException {
        this.oracle.close();
    }

    public boolean isClosed() throws SQLException {
        return this.oracle.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.oracle.getMetaData();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.oracle.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        return this.oracle.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.oracle.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        return this.oracle.getCatalog();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.oracle.setTransactionIsolation(level);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.oracle.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.oracle.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.oracle.clearWarnings();
    }

    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.oracle.getTypeMap();
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.oracle.setTypeMap(map);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.oracle.setHoldability(holdability);
    }

    public int getHoldability() throws SQLException {
        return this.oracle.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.oracle.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.oracle.setSavepoint(name);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.oracle.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.oracle.releaseSavepoint(savepoint);
    }

    public Clob createClob() throws SQLException {
        return this.oracle.createClob();
    }

    public Blob createBlob() throws SQLException {
        return this.oracle.createBlob();
    }

    public NClob createNClob() throws SQLException {
        return this.oracle.createNClob();
    }

    public SQLXML createSQLXML() throws SQLException {
        return this.oracle.createSQLXML();
    }

    public boolean isValid(OracleConnection.ConnectionValidation effort, int timeout) throws SQLException {
        return this.oracle.isValid(effort, timeout);
    }

    public boolean isValid(int timeout) throws SQLException {
        return this.oracle.isValid(timeout);
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.oracle.setClientInfo(name, value);
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.oracle.setClientInfo(properties);
    }

    public String getClientInfo(String name) throws SQLException {
        return this.oracle.getClientInfo(name);
    }

    public Properties getClientInfo() throws SQLException {
        return this.oracle.getClientInfo();
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.oracle.createArrayOf(typeName, elements);
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.oracle.createStruct(typeName, attributes);
    }

    public void setSchema(String schema) throws SQLException {
        this.oracle.setSchema(schema);
    }

    public String getSchema() throws SQLException {
        return this.oracle.getSchema();
    }

    public void abort(Executor executor) throws SQLException {
        this.oracle.abort(executor);
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.oracle.setNetworkTimeout(executor, milliseconds);
    }

    public int getNetworkTimeout() throws SQLException {
        return this.oracle.getNetworkTimeout();
    }

    public Connection _getPC() {
        return this.oracle._getPC();
    }

    public void abort() throws SQLException {
        this.oracle.abort();
    }

    public void applyConnectionAttributes(Properties connAttr) throws SQLException {
        this.oracle.applyConnectionAttributes(connAttr);
    }

    @Deprecated
    public void archive(int mode, int aseq, String acstext) throws SQLException {
        this.oracle.archive(mode, aseq, acstext);
    }

    public void cancel() throws SQLException {
        this.oracle.cancel();
    }

    @Deprecated
    public void clearAllApplicationContext(String nameSpace) throws SQLException {
        this.oracle.clearAllApplicationContext(nameSpace);
    }

    public void close(Properties connAttr) throws SQLException {
        this.oracle.close(connAttr);
    }

    public void close(int opt) throws SQLException {
        this.oracle.close(opt);
    }

    public void commit(EnumSet<OracleConnection.CommitOption> options) throws SQLException {
        this.oracle.commit(options);
    }

    public ARRAY createARRAY(String typeName, Object elements) throws SQLException {
        return this.oracle.createARRAY(typeName, elements);
    }

    public BINARY_DOUBLE createBINARY_DOUBLE(double value) throws SQLException {
        return this.oracle.createBINARY_DOUBLE(value);
    }

    public BINARY_FLOAT createBINARY_FLOAT(float value) throws SQLException {
        return this.oracle.createBINARY_FLOAT(value);
    }

    public DATE createDATE(Date value) throws SQLException {
        return this.oracle.createDATE(value);
    }

    public DATE createDATE(Time value) throws SQLException {
        return this.oracle.createDATE(value);
    }

    public DATE createDATE(Timestamp value) throws SQLException {
        return this.oracle.createDATE(value);
    }

    public DATE createDATE(String value) throws SQLException {
        return this.oracle.createDATE(value);
    }

    public DATE createDATE(Date value, Calendar cal) throws SQLException {
        return this.oracle.createDATE(value, cal);
    }

    public DATE createDATE(Time value, Calendar cal) throws SQLException {
        return this.oracle.createDATE(value, cal);
    }

    public DATE createDATE(Timestamp value, Calendar cal) throws SQLException {
        return this.oracle.createDATE(value, cal);
    }

    public INTERVALDS createINTERVALDS(String value) throws SQLException {
        return this.oracle.createINTERVALDS(value);
    }

    public INTERVALYM createINTERVALYM(String value) throws SQLException {
        return this.oracle.createINTERVALYM(value);
    }

    public NUMBER createNUMBER(boolean value) throws SQLException {
        return this.oracle.createNUMBER(value);
    }

    public NUMBER createNUMBER(byte value) throws SQLException {
        return this.oracle.createNUMBER(value);
    }

    public NUMBER createNUMBER(short value) throws SQLException {
        return this.oracle.createNUMBER(value);
    }

    public NUMBER createNUMBER(int value) throws SQLException {
        return this.oracle.createNUMBER(value);
    }

    public NUMBER createNUMBER(long value) throws SQLException {
        return this.oracle.createNUMBER(value);
    }

    public NUMBER createNUMBER(float value) throws SQLException {
        return this.oracle.createNUMBER(value);
    }

    public NUMBER createNUMBER(double value) throws SQLException {
        return this.oracle.createNUMBER(value);
    }

    public NUMBER createNUMBER(BigDecimal value) throws SQLException {
        return this.oracle.createNUMBER(value);
    }

    public NUMBER createNUMBER(BigInteger value) throws SQLException {
        return this.oracle.createNUMBER(value);
    }

    public NUMBER createNUMBER(String value, int scale) throws SQLException {
        return this.oracle.createNUMBER(value, scale);
    }

    public Array createOracleArray(String arrayTypeName, Object elements) throws SQLException {
        return this.oracle.createOracleArray(arrayTypeName, elements);
    }

    public TIMESTAMP createTIMESTAMP(Date value) throws SQLException {
        return this.oracle.createTIMESTAMP(value);
    }

    public TIMESTAMP createTIMESTAMP(DATE value) throws SQLException {
        return this.oracle.createTIMESTAMP(value);
    }

    public TIMESTAMP createTIMESTAMP(Time value) throws SQLException {
        return this.oracle.createTIMESTAMP(value);
    }

    public TIMESTAMP createTIMESTAMP(Timestamp value) throws SQLException {
        return this.oracle.createTIMESTAMP(value);
    }

    public TIMESTAMP createTIMESTAMP(String value) throws SQLException {
        return this.oracle.createTIMESTAMP(value);
    }

    public TIMESTAMPLTZ createTIMESTAMPLTZ(Date value, Calendar cal) throws SQLException {
        return this.oracle.createTIMESTAMPLTZ(value, cal);
    }

    public TIMESTAMPLTZ createTIMESTAMPLTZ(Time value, Calendar cal) throws SQLException {
        return this.oracle.createTIMESTAMPLTZ(value, cal);
    }

    public TIMESTAMPLTZ createTIMESTAMPLTZ(Timestamp value, Calendar cal) throws SQLException {
        return this.oracle.createTIMESTAMPLTZ(value, cal);
    }

    public TIMESTAMPLTZ createTIMESTAMPLTZ(String value, Calendar cal) throws SQLException {
        return this.oracle.createTIMESTAMPLTZ(value, cal);
    }

    public TIMESTAMPLTZ createTIMESTAMPLTZ(DATE value, Calendar cal) throws SQLException {
        return this.oracle.createTIMESTAMPLTZ(value, cal);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Date value) throws SQLException {
        return this.oracle.createTIMESTAMPTZ(value);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Time value) throws SQLException {
        return this.oracle.createTIMESTAMPTZ(value);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value) throws SQLException {
        return this.oracle.createTIMESTAMPTZ(value);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(String value) throws SQLException {
        return this.oracle.createTIMESTAMPTZ(value);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(DATE value) throws SQLException {
        return this.oracle.createTIMESTAMPTZ(value);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Date value, Calendar cal) throws SQLException {
        return this.oracle.createTIMESTAMPTZ(value, cal);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Time value, Calendar cal) throws SQLException {
        return this.oracle.createTIMESTAMPTZ(value, cal);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value, Calendar cal) throws SQLException {
        return this.oracle.createTIMESTAMPTZ(value, cal);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(String value, Calendar cal) throws SQLException {
        return this.oracle.createTIMESTAMPTZ(value, cal);
    }

    public AQMessage dequeue(String queueName, AQDequeueOptions opt, byte[] tdo) throws SQLException {
        return this.oracle.dequeue(queueName, opt, tdo);
    }

    public AQMessage dequeue(String queueName, AQDequeueOptions opt, String typeName) throws SQLException {
        return this.oracle.dequeue(queueName, opt, typeName);
    }

    public AQMessage dequeue(String queueName, AQDequeueOptions opt, byte[] tdo, int version) throws SQLException {
        return this.oracle.dequeue(queueName, opt, tdo, version);
    }

    public void enqueue(String queueName, AQEnqueueOptions opt, AQMessage mesg) throws SQLException {
        this.oracle.enqueue(queueName, opt, mesg);
    }

    public TypeDescriptor[] getAllTypeDescriptorsInCurrentSchema() throws SQLException {
        return this.oracle.getAllTypeDescriptorsInCurrentSchema();
    }

    public String getAuthenticationAdaptorName() throws SQLException {
        return this.oracle.getAuthenticationAdaptorName();
    }

    public boolean getAutoClose() throws SQLException {
        return this.oracle.getAutoClose();
    }

    public CallableStatement getCallWithKey(String key) throws SQLException {
        return this.oracle.getCallWithKey(key);
    }

    public Properties getConnectionAttributes() throws SQLException {
        return this.oracle.getConnectionAttributes();
    }

    public int getConnectionReleasePriority() throws SQLException {
        return this.oracle.getConnectionReleasePriority();
    }

    public boolean getCreateStatementAsRefCursor() {
        return this.oracle.getCreateStatementAsRefCursor();
    }

    public String getCurrentSchema() throws SQLException {
        return this.oracle.getCurrentSchema();
    }

    public String getDataIntegrityAlgorithmName() throws SQLException {
        return this.oracle.getDataIntegrityAlgorithmName();
    }

    public DatabaseChangeRegistration getDatabaseChangeRegistration(int regid) throws SQLException {
        return this.oracle.getDatabaseChangeRegistration(regid);
    }

    @Deprecated
    public int getDefaultExecuteBatch() {
        return this.oracle.getDefaultExecuteBatch();
    }

    public int getDefaultRowPrefetch() {
        return this.oracle.getDefaultRowPrefetch();
    }

    public TimeZone getDefaultTimeZone() throws SQLException {
        return this.oracle.getDefaultTimeZone();
    }

    public Object getDescriptor(String sqlName) {
        return this.oracle.getDescriptor(sqlName);
    }

    public String getEncryptionAlgorithmName() throws SQLException {
        return this.oracle.getEncryptionAlgorithmName();
    }

    @Deprecated
    public short getEndToEndECIDSequenceNumber() throws SQLException {
        return this.oracle.getEndToEndECIDSequenceNumber();
    }

    @Deprecated
    public String[] getEndToEndMetrics() throws SQLException {
        return this.oracle.getEndToEndMetrics();
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.oracle.getExplicitCachingEnabled();
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.oracle.getImplicitCachingEnabled();
    }

    public boolean getIncludeSynonyms() {
        return this.oracle.getIncludeSynonyms();
    }

    @Deprecated
    public Object getJavaObject(String sqlName) throws SQLException {
        return this.oracle.getJavaObject(sqlName);
    }

    public Properties getProperties() {
        return this.oracle.getProperties();
    }

    public boolean getRemarksReporting() {
        return this.oracle.getRemarksReporting();
    }

    public boolean getRestrictGetTables() {
        return this.oracle.getRestrictGetTables();
    }

    @Deprecated
    public String getSQLType(Object obj) throws SQLException {
        return this.oracle.getSQLType(obj);
    }

    public String getSessionTimeZone() {
        return this.oracle.getSessionTimeZone();
    }

    public String getSessionTimeZoneOffset() throws SQLException {
        return this.oracle.getSessionTimeZoneOffset();
    }

    public int getStatementCacheSize() throws SQLException {
        return this.oracle.getStatementCacheSize();
    }

    @Deprecated
    public int getStmtCacheSize() {
        return this.oracle.getStmtCacheSize();
    }

    public short getStructAttrCsId() throws SQLException {
        return this.oracle.getStructAttrCsId();
    }

    public TypeDescriptor[] getTypeDescriptorsFromList(String[][] schemaAndTypeNamePairs) throws SQLException {
        return this.oracle.getTypeDescriptorsFromList(schemaAndTypeNamePairs);
    }

    public TypeDescriptor[] getTypeDescriptorsFromListInCurrentSchema(String[] typeNames) throws SQLException {
        return this.oracle.getTypeDescriptorsFromListInCurrentSchema(typeNames);
    }

    public Properties getUnMatchedConnectionAttributes() throws SQLException {
        return this.oracle.getUnMatchedConnectionAttributes();
    }

    public String getUserName() throws SQLException {
        return this.oracle.getUserName();
    }

    @Deprecated
    public boolean getUsingXAFlag() {
        return this.oracle.getUsingXAFlag();
    }

    @Deprecated
    public boolean getXAErrorFlag() {
        return this.oracle.getXAErrorFlag();
    }

    public boolean isLogicalConnection() {
        return this.oracle.isLogicalConnection();
    }

    public boolean isProxySession() {
        return this.oracle.isProxySession();
    }

    public boolean isUsable() {
        return this.oracle.isUsable();
    }

    public void openProxySession(int type, Properties prop) throws SQLException {
        this.oracle.openProxySession(type, prop);
    }

    public void oracleReleaseSavepoint(OracleSavepoint savepoint) throws SQLException {
        this.oracle.oracleReleaseSavepoint(savepoint);
    }

    public void oracleRollback(OracleSavepoint savepoint) throws SQLException {
        this.oracle.oracleRollback(savepoint);
    }

    public OracleSavepoint oracleSetSavepoint() throws SQLException {
        return this.oracle.oracleSetSavepoint();
    }

    public OracleSavepoint oracleSetSavepoint(String name) throws SQLException {
        return this.oracle.oracleSetSavepoint(name);
    }

    @Deprecated
    public OracleConnection physicalConnectionWithin() {
        return this.oracle.physicalConnectionWithin();
    }

    public int pingDatabase() throws SQLException {
        return this.oracle.pingDatabase();
    }

    @Deprecated
    public int pingDatabase(int timeOut) throws SQLException {
        return this.oracle.pingDatabase(timeOut);
    }

    public void purgeExplicitCache() throws SQLException {
        this.oracle.purgeExplicitCache();
    }

    public void purgeImplicitCache() throws SQLException {
        this.oracle.purgeImplicitCache();
    }

    public void putDescriptor(String sqlName, Object desc) throws SQLException {
        this.oracle.putDescriptor(sqlName, desc);
    }

    public AQNotificationRegistration[] registerAQNotification(String[] name, Properties[] options, Properties globalOptions) throws SQLException {
        return this.oracle.registerAQNotification(name, options, globalOptions);
    }

    public void registerConnectionCacheCallback(OracleConnectionCacheCallback occc, Object userObj, int cbkFlag) throws SQLException {
        this.oracle.registerConnectionCacheCallback(occc, userObj, cbkFlag);
    }

    public DatabaseChangeRegistration registerDatabaseChangeNotification(Properties options) throws SQLException {
        return this.oracle.registerDatabaseChangeNotification(options);
    }

    @Deprecated
    public void registerSQLType(String sqlName, Class javaClass) throws SQLException {
        this.oracle.registerSQLType(sqlName, javaClass);
    }

    @Deprecated
    public void registerSQLType(String sqlName, String javaClassName) throws SQLException {
        this.oracle.registerSQLType(sqlName, javaClassName);
    }

    public void registerTAFCallback(OracleOCIFailover cbk, Object obj) throws SQLException {
        this.oracle.registerTAFCallback(cbk, obj);
    }

    @Deprecated
    public void setApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        this.oracle.setApplicationContext(nameSpace, attribute, value);
    }

    public void setAutoClose(boolean autoClose) throws SQLException {
        this.oracle.setAutoClose(autoClose);
    }

    public void setConnectionReleasePriority(int priority) throws SQLException {
        this.oracle.setConnectionReleasePriority(priority);
    }

    public void setCreateStatementAsRefCursor(boolean value) {
        this.oracle.setCreateStatementAsRefCursor(value);
    }

    @Deprecated
    public void setDefaultExecuteBatch(int batch) throws SQLException {
        this.oracle.setDefaultExecuteBatch(batch);
    }

    public void setDefaultRowPrefetch(int value) throws SQLException {
        this.oracle.setDefaultRowPrefetch(value);
    }

    public void setDefaultTimeZone(TimeZone tz) throws SQLException {
        this.oracle.setDefaultTimeZone(tz);
    }

    @Deprecated
    public void setEndToEndMetrics(String[] metrics, short sequenceNumber) throws SQLException {
        this.oracle.setEndToEndMetrics(metrics, sequenceNumber);
    }

    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        this.oracle.setExplicitCachingEnabled(cache);
    }

    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        this.oracle.setImplicitCachingEnabled(cache);
    }

    public void setIncludeSynonyms(boolean synonyms) {
        this.oracle.setIncludeSynonyms(synonyms);
    }

    public void setPlsqlWarnings(String setting) throws SQLException {
        this.oracle.setPlsqlWarnings(setting);
    }

    public void setRemarksReporting(boolean reportRemarks) {
        this.oracle.setRemarksReporting(reportRemarks);
    }

    public void setRestrictGetTables(boolean restrict) {
        this.oracle.setRestrictGetTables(restrict);
    }

    public void setSessionTimeZone(String regionName) throws SQLException {
        this.oracle.setSessionTimeZone(regionName);
    }

    public void setStatementCacheSize(int size) throws SQLException {
        this.oracle.setStatementCacheSize(size);
    }

    @Deprecated
    public void setStmtCacheSize(int size) throws SQLException {
        this.oracle.setStmtCacheSize(size);
    }

    @Deprecated
    public void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        this.oracle.setStmtCacheSize(size, clearMetaData);
    }

    @Deprecated
    public void setUsingXAFlag(boolean value) {
        this.oracle.setUsingXAFlag(value);
    }

    public void setWrapper(oracle.jdbc.OracleConnection wrapper) {
        this.oracle.setWrapper(wrapper);
    }

    @Deprecated
    public void setXAErrorFlag(boolean value) {
        this.oracle.setXAErrorFlag(value);
    }

    public void shutdown(OracleConnection.DatabaseShutdownMode mode) throws SQLException {
        this.oracle.shutdown(mode);
    }

    public void startup(OracleConnection.DatabaseStartupMode mode) throws SQLException {
        this.oracle.startup(mode);
    }

    @Deprecated
    public void startup(String startupString, int mode) throws SQLException {
        this.oracle.startup(startupString, mode);
    }

    public void unregisterAQNotification(AQNotificationRegistration registration) throws SQLException {
        this.oracle.unregisterAQNotification(registration);
    }

    public void unregisterDatabaseChangeNotification(DatabaseChangeRegistration registration) throws SQLException {
        this.oracle.unregisterDatabaseChangeNotification(registration);
    }

    @Deprecated
    public void unregisterDatabaseChangeNotification(int registrationId) throws SQLException {
        this.oracle.unregisterDatabaseChangeNotification(registrationId);
    }

    public void unregisterDatabaseChangeNotification(long registrationId, String callback) throws SQLException {
        this.oracle.unregisterDatabaseChangeNotification(registrationId, callback);
    }

    @Deprecated
    public void unregisterDatabaseChangeNotification(int registrationId, String host, int tcpPort) throws SQLException {
        this.oracle.unregisterDatabaseChangeNotification(registrationId, host, tcpPort);
    }

    public oracle.jdbc.OracleConnection unwrap() {
        return this.oracle.unwrap();
    }

    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener listener) throws SQLException {
        this.oracle.addLogicalTransactionIdEventListener(listener);
    }

    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener listener, Executor executor) throws SQLException {
        this.oracle.addLogicalTransactionIdEventListener(listener, executor);
    }

    public boolean attachServerConnection() throws SQLException {
        return this.oracle.attachServerConnection();
    }

    public void beginRequest() throws SQLException {
        this.oracle.beginRequest();
    }

    public TIMESTAMP createTIMESTAMP(Timestamp value, Calendar cal) throws SQLException {
        return this.oracle.createTIMESTAMP(value, cal);
    }

    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value, ZoneId tzid) throws SQLException {
        return this.oracle.createTIMESTAMPTZ(value, tzid);
    }

    public void detachServerConnection(String tag) throws SQLException {
        this.oracle.detachServerConnection(tag);
    }

    public void endRequest() throws SQLException {
        this.oracle.endRequest();
    }

    public String getDRCPPLSQLCallbackName() throws SQLException {
        return this.oracle.getDRCPPLSQLCallbackName();
    }

    public String getDRCPReturnTag() throws SQLException {
        return this.oracle.getDRCPReturnTag();
    }

    public OracleConnection.DRCPState getDRCPState() throws SQLException {
        return this.oracle.getDRCPState();
    }

    public LogicalTransactionId getLogicalTransactionId() throws SQLException {
        return this.oracle.getLogicalTransactionId();
    }

    public boolean isDRCPEnabled() throws SQLException {
        return this.oracle.isDRCPEnabled();
    }

    public boolean isDRCPMultitagEnabled() throws SQLException {
        return this.oracle.isDRCPMultitagEnabled();
    }

    public boolean needToPurgeStatementCache() throws SQLException {
        return this.oracle.needToPurgeStatementCache();
    }

    public void removeLogicalTransactionIdEventListener(LogicalTransactionIdEventListener listener) throws SQLException {
        this.oracle.removeLogicalTransactionIdEventListener(listener);
    }

    public void setShardingKey(OracleShardingKey shardingKey, OracleShardingKey superShardingKey) throws SQLException {
        this.oracle.setShardingKey(shardingKey, superShardingKey);
    }

    public void setShardingKey(OracleShardingKey shardingKey) throws SQLException {
        this.oracle.setShardingKey(shardingKey);
    }

    public boolean setShardingKeyIfValid(OracleShardingKey shardingKey, OracleShardingKey superShardingKey, int timeout) throws SQLException {
        return this.oracle.setShardingKeyIfValid(shardingKey, superShardingKey, timeout);
    }

    public boolean setShardingKeyIfValid(OracleShardingKey shardingKey, int timeout) throws SQLException {
        return this.oracle.setShardingKeyIfValid(shardingKey, timeout);
    }

    public void startup(OracleConnection.DatabaseStartupMode mode, String pfileName) throws SQLException {
        this.oracle.startup(mode, pfileName);
    }

    public String getChecksumProviderName() throws SQLException {
        return this.oracle.getChecksumProviderName();
    }

    public String getEncryptionProviderName() throws SQLException {
        return this.oracle.getEncryptionProviderName();
    }
}

