/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.MethodSpec;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.HeapMemberGenerator;
import net.openhft.chronicle.values.PrimitiveFieldModel;
import net.openhft.chronicle.values.Primitives;
import net.openhft.chronicle.values.Utils;
import net.openhft.chronicle.values.ValueBuilder;

class PrimitiveBackedHeapMemberGenerator
extends HeapMemberGenerator {
    final String capType;
    private final String upperType;
    private final Class fieldType;

    PrimitiveBackedHeapMemberGenerator(FieldModel fieldModel) {
        super(fieldModel);
        this.fieldType = this.determineFieldType();
        assert (this.fieldType.isPrimitive());
        this.capType = Utils.capitalize(this.fieldType.getName());
        this.upperType = this.fieldType.getName().toUpperCase();
    }

    PrimitiveBackedHeapMemberGenerator(FieldModel fieldModel, Class fieldType) {
        super(fieldModel);
        this.fieldType = fieldType;
        assert (fieldType.isPrimitive());
        this.capType = Utils.capitalize(fieldType.getName());
        this.upperType = fieldType.getName().toUpperCase();
    }

    @Override
    Class fieldType() {
        return this.fieldType;
    }

    private Class determineFieldType() {
        Class modelType = super.fieldType();
        if (modelType == Long.TYPE || modelType == Integer.TYPE) {
            return modelType;
        }
        PrimitiveFieldModel fieldModel = (PrimitiveFieldModel)this.fieldModel;
        if (fieldModel.setOrdered != null || fieldModel.compareAndSwap != null || fieldModel.addAtomic != null) {
            if (modelType == Double.TYPE) {
                return Long.TYPE;
            }
            return Integer.TYPE;
        }
        return modelType;
    }

    String getVolatile() {
        return "get" + this.capType + "Volatile";
    }

    @Override
    String putVolatile() {
        return "put" + this.capType + "Volatile";
    }

    @Override
    String putOrdered() {
        return "putOrdered" + this.capType;
    }

    @Override
    String compareAndSwap() {
        return "compareAndSwap" + this.capType;
    }

    @Override
    String arrayBase() {
        return "ARRAY_" + this.upperType + "_BASE_OFFSET";
    }

    @Override
    String arrayScale() {
        return "ARRAY_" + this.upperType + "_INDEX_SCALE";
    }

    @Override
    String wrap(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String rawStoredValue) {
        if (this.fieldType() == this.fieldModel.type) {
            return rawStoredValue;
        }
        if (this.fieldModel.type == Float.TYPE) {
            return "java.lang.Float.intBitsToFloat(" + rawStoredValue + ")";
        }
        if (this.fieldModel.type == Double.TYPE) {
            return "java.lang.Double.longBitsToDouble(" + rawStoredValue + ")";
        }
        if (this.fieldModel.type == Boolean.TYPE) {
            return "(" + rawStoredValue + " != 0)";
        }
        assert (this.fieldModel.type == Byte.TYPE || this.fieldModel.type == Short.TYPE || this.fieldModel.type == Character.TYPE);
        return "((" + this.fieldModel.type.getSimpleName() + ") " + rawStoredValue + ")";
    }

    @Override
    String unwrap(MethodSpec.Builder methodBuilder, String inputValue) {
        if (this.fieldType() == this.fieldModel.type) {
            return inputValue;
        }
        if (this.fieldModel.type == Float.TYPE) {
            return "java.lang.Float.floatToRawIntBits(" + inputValue + ")";
        }
        if (this.fieldModel.type == Double.TYPE) {
            return "java.lang.Double.doubleToRawLongBits(" + inputValue + ")";
        }
        if (this.fieldModel.type == Boolean.TYPE) {
            return "(" + inputValue + " ? 1 : 0)";
        }
        assert (this.fieldModel.type == Byte.TYPE || this.fieldModel.type == Short.TYPE || this.fieldModel.type == Character.TYPE);
        return inputValue;
    }

    @Override
    public void generateGetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String rawValue = "raw" + Utils.capitalize(this.field.name) + "Value";
        methodBuilder.addStatement("$T $N = $N.$N(this, $N)", this.fieldType(), rawValue, valueBuilder.unsafe(), this.getVolatile(), this.fieldOffset(valueBuilder));
        methodBuilder.addStatement("return $N", this.wrap(valueBuilder, methodBuilder, rawValue));
    }

    @Override
    public void generateArrayElementGetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        String rawValue = "raw" + Utils.capitalize(this.field.name) + "Value";
        Class type = Utils.UNSAFE_CLASS;
        methodBuilder.addStatement("$T $N = $N.$N($N, (long) $T.$N + (index * (long) $T.$N))", this.fieldType(), rawValue, valueBuilder.unsafe(), this.getVolatile(), this.field, type, this.arrayBase(), type, this.arrayScale());
        methodBuilder.addStatement("return $N", this.wrap(valueBuilder, methodBuilder, rawValue));
    }

    @Override
    void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        if (this.fieldModel.type != Character.TYPE || this.fieldType() != this.fieldModel.type) {
            methodBuilder.addStatement("$N = " + this.unwrap(methodBuilder, "bytes.$N()"), this.field, this.fieldModel.readMethod());
        } else {
            methodBuilder.addStatement("$N = (char) bytes.readUnsignedShort()", this.field);
        }
    }

    @Override
    void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        if (this.fieldModel.type != Character.TYPE || this.fieldType() != this.fieldModel.type) {
            methodBuilder.addStatement("$N[index] = " + this.unwrap(methodBuilder, "bytes.$N()"), this.field, this.fieldModel.readMethod());
        } else {
            methodBuilder.addStatement("$N[index] = (char) bytes.readUnsignedShort()", this.field);
        }
    }

    @Override
    void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addCode("if ($N() != other.$N()) return false;\n", this.fieldModel.getOrGetVolatile().getName(), this.fieldModel.getOrGetVolatile().getName());
    }

    @Override
    void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String get = arrayFieldModel.getOrGetVolatile().getName();
        methodBuilder.addCode("if ($N(index) != other.$N(index)) return false;\n", get, get);
    }

    @Override
    String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        return String.format("%s.hashCode(%s())", Primitives.boxed(this.fieldModel.type).getName(), this.fieldModel.getOrGetVolatile().getName());
    }

    @Override
    String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        return String.format("%s.hashCode(%s(index))", Primitives.boxed(this.fieldModel.type).getName(), arrayFieldModel.getOrGetVolatile().getName());
    }
}

