/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.MethodSpec;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.FieldModel;
import net.openhft.chronicle.values.IntegerFieldModel;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.ValueBuilder;

abstract class IntegerBackedNativeMemberGenerator
extends MemberGenerator {
    final IntegerFieldModel backingFieldModel;

    IntegerBackedNativeMemberGenerator(FieldModel fieldModel, IntegerFieldModel backingFieldModel) {
        super(fieldModel);
        this.backingFieldModel = backingFieldModel;
    }

    abstract void finishGet(ValueBuilder var1, MethodSpec.Builder var2, String var3);

    abstract String startSet(MethodSpec.Builder var1);

    @Override
    public void generateGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String value = this.backingFieldModel.genGet(valueBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
        this.finishGet(valueBuilder, methodBuilder, value);
    }

    @Override
    public void generateArrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        String value = this.backingFieldModel.genArrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
        this.finishGet(valueBuilder, methodBuilder, value);
    }

    @Override
    public void generateGetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String value = this.backingFieldModel.genGet(valueBuilder, IntegerFieldModel.VOLATILE_ACCESS_TYPE);
        this.finishGet(valueBuilder, methodBuilder, value);
    }

    @Override
    public void generateArrayElementGetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        String value = this.backingFieldModel.genArrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.VOLATILE_ACCESS_TYPE);
        this.finishGet(valueBuilder, methodBuilder, value);
    }

    @Override
    public void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String valueToWrite = this.startSet(methodBuilder);
        this.backingFieldModel.genSet(valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE, valueToWrite);
    }

    @Override
    public void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        String valueToWrite = this.startSet(methodBuilder);
        this.backingFieldModel.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE, valueToWrite);
    }

    @Override
    public void generateSetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String valueToWrite = this.startSet(methodBuilder);
        this.backingFieldModel.genSet(valueBuilder, methodBuilder, IntegerFieldModel.VOLATILE_ACCESS_TYPE, valueToWrite);
    }

    @Override
    public void generateArrayElementSetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        String valueToWrite = this.startSet(methodBuilder);
        this.backingFieldModel.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.VOLATILE_ACCESS_TYPE, valueToWrite);
    }

    @Override
    public void generateSetOrdered(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String valueToWrite = this.startSet(methodBuilder);
        this.backingFieldModel.genSet(valueBuilder, methodBuilder, IntegerFieldModel.ORDERED_ACCESS_TYPE, valueToWrite);
    }

    @Override
    public void generateArrayElementSetOrdered(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        arrayFieldModel.checkBounds(methodBuilder);
        String valueToWrite = this.startSet(methodBuilder);
        this.backingFieldModel.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.ORDERED_ACCESS_TYPE, valueToWrite);
    }

    @Override
    void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        if (this.fieldModel.set != null) {
            methodBuilder.addStatement("$N(from.$N())", this.fieldModel.set.getName(), this.fieldModel.getOrGetVolatile().getName());
        } else {
            methodBuilder.addStatement("$T $N = from.$N()", this.fieldModel.type, this.fieldModel.varName(), this.fieldModel.getOrGetVolatile().getName());
            this.generateSet(valueBuilder, methodBuilder);
        }
    }

    @Override
    void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        if (arrayFieldModel.set != null) {
            methodBuilder.addStatement("$N(index, from.$N(index))", arrayFieldModel.set.getName(), arrayFieldModel.getOrGetVolatile().getName());
        } else {
            methodBuilder.addStatement("$T $N = from.$N(index)", this.fieldModel.type, this.fieldModel.varName(), arrayFieldModel.getOrGetVolatile().getName());
            this.generateArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder);
        }
    }

    @Override
    void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        methodBuilder.addStatement("bytes.$N($N)", this.backingFieldModel.writeMethod(), this.backingFieldModel.genGet(valueBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE));
    }

    @Override
    void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        String value = this.backingFieldModel.genArrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
        methodBuilder.addStatement("bytes.$N($N)", this.backingFieldModel.writeMethod(), value);
    }

    @Override
    void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        this.backingFieldModel.genSet(valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE, this.readValue());
    }

    @Override
    void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
        this.backingFieldModel.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE, this.readValue());
    }

    private String readValue() {
        return String.format("bytes.%s()", this.backingFieldModel.readMethod());
    }
}

