/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import net.openhft.chronicle.map.AbstractChronicleMap;
import net.openhft.chronicle.map.ChronicleMapIterator;
import org.jetbrains.annotations.NotNull;

class ChronicleMapEntrySet<K, V>
extends AbstractSet<Map.Entry<K, V>> {
    private final AbstractChronicleMap<K, V> map;

    public ChronicleMapEntrySet(AbstractChronicleMap<K, V> map) {
        this.map = map;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> iterator() {
        return new ChronicleMapIterator.OfEntries<K, V>(this.map);
    }

    @Override
    public final boolean contains(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        try {
            Object v = this.map.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }
        catch (ClassCastException | NullPointerException ex) {
            return false;
        }
    }

    @Override
    public final boolean remove(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        try {
            Object key = e.getKey();
            Object value = e.getValue();
            return this.map.remove(key, value);
        }
        catch (ClassCastException | NullPointerException ex) {
            return false;
        }
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final void clear() {
        this.map.clear();
    }
}

