/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.data.bytes;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.impl.stage.hash.KeyBytesInterop;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public class InputKeyBytesData<K>
extends AbstractData<K> {
    @Stage(value="InputKeyBytes")
    private final VanillaBytes inputKeyBytes = VanillaBytes.vanillaBytes();
    @StageRef
    KeyBytesInterop<K> ki;
    @StageRef
    CheckOnEachPublicOperation checkOnEachPublicOperation;
    @Stage(value="InputKeyBytesStore")
    private BytesStore inputKeyBytesStore = null;
    @Stage(value="InputKeyBytesStore")
    private long inputKeyBytesOffset;
    @Stage(value="InputKeyBytesStore")
    private long inputKeyBytesSize;
    @Stage(value="InputKeyBytes")
    private boolean inputKeyBytesUsed = false;
    @Stage(value="CachedInputKey")
    private K cachedInputKey;
    @Stage(value="CachedInputKey")
    private boolean cachedInputKeyRead = false;

    public void initInputKeyBytesStore(BytesStore bytesStore, long offset, long size) {
        this.inputKeyBytesStore = bytesStore;
        this.inputKeyBytesOffset = offset;
        this.inputKeyBytesSize = size;
    }

    boolean inputKeyBytesInit() {
        return this.inputKeyBytesUsed;
    }

    void initInputKeyBytes() {
        this.inputKeyBytes.bytesStore(this.inputKeyBytesStore, this.inputKeyBytesOffset, this.inputKeyBytesSize);
        this.inputKeyBytesUsed = true;
    }

    void closeInputKeyBytes() {
        this.inputKeyBytes.bytesStore(NoBytesStore.NO_BYTES_STORE, 0L, 0L);
        this.inputKeyBytesUsed = false;
    }

    private void initCachedInputKey() {
        this.cachedInputKey = this.innerGetUsing(this.cachedInputKey);
        this.cachedInputKeyRead = true;
    }

    @Override
    public RandomDataInput bytes() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.inputKeyBytes.bytesStore();
    }

    @Override
    public long offset() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.inputKeyBytesOffset;
    }

    @Override
    public long size() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.inputKeyBytesSize;
    }

    @Override
    public K get() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.cachedInputKey;
    }

    @Override
    public K getUsing(K using) {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerGetUsing(using);
    }

    private K innerGetUsing(K usingKey) {
        this.inputKeyBytes.readPosition(this.inputKeyBytesOffset);
        return this.ki.keyReader.read(this.inputKeyBytes, this.inputKeyBytesSize, usingKey);
    }
}

