/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.nio.BufferUnderflowException;
import java.util.Objects;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInterner<T> {
    protected final InternerEntry<T>[] entries;
    protected final int mask;
    protected final int shift;
    protected boolean toggle = false;

    protected AbstractInterner(@NonNegative int capacity) throws IllegalArgumentException {
        int n = Maths.nextPower2(capacity, 128);
        this.shift = Maths.intLog2(n);
        this.entries = new InternerEntry[n];
        this.mask = n - 1;
    }

    private static int hash32(@NotNull BytesStore bs, @NonNegative int length) throws IllegalStateException, BufferUnderflowException {
        return bs.fastHash(bs.readPosition(), length);
    }

    public T intern(@NotNull Bytes<?> cs) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        return this.intern((BytesStore)cs, (int)cs.readRemaining());
    }

    public T intern(@NotNull BytesStore cs) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        return this.intern(cs, (int)cs.readRemaining());
    }

    public T intern(@NotNull Bytes<?> cs, @NonNegative int length) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        return this.intern((BytesStore)cs, length);
    }

    public T intern(@NotNull BytesStore cs, @NonNegative int length) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        if (length > this.entries.length) {
            return this.getValue(cs, length);
        }
        int hash = AbstractInterner.hash32(cs, length);
        int h = hash & this.mask;
        InternerEntry<T> s = this.entries[h];
        if (s != null && s.bytes.length() == length && s.bytes.equalBytes(cs, length)) {
            return s.t;
        }
        int h2 = hash >> this.shift & this.mask;
        InternerEntry<T> s2 = this.entries[h2];
        if (s2 != null && s2.bytes.length() == length && s2.bytes.equalBytes(cs, length)) {
            return s2.t;
        }
        @NotNull T t = this.getValue(cs, length);
        byte[] bytes = new byte[length];
        @NotNull BytesStore<?, byte[]> bs = BytesStore.wrap(bytes);
        IOTools.unmonitor(bs);
        cs.read(cs.readPosition(), bytes, 0, length);
        this.entries[s == null || s2 != null && this.toggle() ? h : h2] = new InternerEntry<T>(bs, t);
        return t;
    }

    @NotNull
    protected abstract T getValue(BytesStore var1, @NonNegative int var2) throws IORuntimeException, IllegalStateException, BufferUnderflowException;

    protected boolean toggle() {
        this.toggle = !this.toggle;
        return this.toggle;
    }

    public int valueCount() {
        return (int)Stream.of(this.entries).filter(Objects::nonNull).count();
    }

    private static final class InternerEntry<T> {
        final BytesStore bytes;
        final T t;

        InternerEntry(BytesStore bytes, T t) {
            this.bytes = bytes;
            this.t = t;
        }
    }
}

