/*
 * Decompiled with CFR 0.152.
 */
package solutions.a2.oracle.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import solutions.a2.oracle.jdbc.OraProxyTranslatorIntf;
import solutions.a2.oracle.jdbc.OraProxyUtils;

public class OraProxySqlTranslatorMap
implements OraProxyTranslatorIntf {
    private final Map<String, String> sqlMap = new ConcurrentHashMap<String, String>();

    OraProxySqlTranslatorMap(URL mappingFileUrl) throws SQLException {
        try {
            OraProxyUtils.readSimpleYaml(new BufferedReader(new InputStreamReader(mappingFileUrl.openStream())), this.sqlMap);
        }
        catch (IOException ioe) {
            throw new SQLException(String.format("Unable to read from '%s'!", mappingFileUrl.toString()), ioe);
        }
    }

    @Override
    public String translate(String source) throws SQLException {
        String sqlId = OraProxyUtils.sql_id(source);
        return this.sqlMap.getOrDefault(sqlId, source);
    }
}

