/*
 * Decompiled with CFR 0.152.
 */
package solutions.a2.oracle.jdbc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import solutions.a2.oracle.jdbc.OraProxyUtils;

public class OraProxyFileUtils {
    private static final Logger LOGGER = Logger.getLogger(OraProxyFileUtils.class.getName());

    public static void main(String[] argv) {
        String targetFileName;
        File targetFile;
        boolean fromYaml;
        int modeIndex = 0;
        int fileIndex = 0;
        if (argv.length != 4 && argv.length != 2) {
            OraProxyFileUtils.usage();
            System.exit(1);
        } else {
            modeIndex = "-m".equals(argv[0]) ? 1 : (argv.length == 4 && "-m".equals(argv[2]) ? 3 : 5);
            if ("-f".equals(argv[0])) {
                fileIndex = 1;
            } else if (argv.length == 4 && "-f".equals(argv[2])) {
                fileIndex = 3;
            }
            if (modeIndex == 0 || fileIndex == 0) {
                OraProxyFileUtils.usage();
                System.exit(1);
            }
        }
        if (modeIndex == 5) {
            fromYaml = true;
        } else if ("yaml2cmap".equalsIgnoreCase(argv[modeIndex])) {
            fromYaml = true;
        } else if ("cmap2yaml".equalsIgnoreCase(argv[modeIndex])) {
            fromYaml = false;
        } else {
            fromYaml = false;
            OraProxyFileUtils.usage();
            System.exit(1);
        }
        String sourceFileName = argv[fileIndex];
        File sourceFile = new File(sourceFileName);
        if (!sourceFile.exists()) {
            LOGGER.log(Level.SEVERE, "File '" + sourceFileName + "' does not exists!");
            System.exit(1);
        }
        if ((targetFile = new File(targetFileName = sourceFileName.substring(0, sourceFileName.lastIndexOf(".") + 1) + (fromYaml ? "cmap" : "yaml"))).exists()) {
            LOGGER.log(Level.SEVERE, "Output file '" + targetFileName + "' already exists!");
            System.exit(1);
        }
        try {
            if (fromYaml) {
                OraProxyFileUtils.convertYaml(sourceFile, targetFile);
            } else {
                OraProxyFileUtils.convertCmap(sourceFile, targetFile);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Error while running conversion utility!", ioe);
            System.exit(1);
        }
        System.out.println("Done.");
    }

    private static final void usage() {
        System.err.println("Usage:");
        System.err.println(OraProxyFileUtils.class.getName() + " [-m yaml2cmap|cmap2yaml] -f <SOURCE-FILE>");
        System.err.println("\twhen the option -\u044c is not specified, the default is yaml2cmap");
    }

    private static void convertYaml(File sourceFile, File targetFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(sourceFile));
        HashMap<String, String> data = new HashMap<String, String>();
        OraProxyUtils.readSimpleYaml(reader, data);
        reader.close();
        int entries = 0;
        double avgKeySize = 0.0;
        double avgValueSize = 0.0;
        for (String k : data.keySet()) {
            ++entries;
            avgKeySize += (double)k.getBytes("UTF-8").length;
            avgValueSize += (double)((String)data.get(k)).getBytes("UTF-8").length;
        }
        avgKeySize = Math.floor(avgKeySize / (double)entries);
        avgValueSize = Math.floor(avgValueSize / (double)entries);
        ChronicleMap sqlIdMapping = ChronicleMapBuilder.of(String.class, String.class).name("https://a2.solutions/ - SQL substition").averageKeySize(avgKeySize).averageValueSize(avgValueSize).entries((long)entries).createOrRecoverPersistedTo(targetFile);
        sqlIdMapping.putAll(data);
        sqlIdMapping.close();
    }

    private static void convertCmap(File sourceFile, File targetFile) throws IOException {
        ChronicleMap sqlIdMapping = ChronicleMapBuilder.of(String.class, String.class).createOrRecoverPersistedTo(sourceFile);
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile));
        for (String sqlId : sqlIdMapping.keySet()) {
            String sqlStatement = (String)sqlIdMapping.get((Object)sqlId);
            OraProxyUtils.write2Yaml(writer, sqlId, sqlStatement);
        }
        writer.flush();
        writer.close();
        sqlIdMapping.close();
    }
}

