/*
 * Decompiled with CFR 0.152.
 */
package solutions.a2.oracle.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OraProxyUtils {
    private static final Logger LOGGER = Logger.getLogger(OraProxyUtils.class.getName());
    private static final String PROPS_PATH = "/orajdbc-proxy-version.properties";
    private static final int SQL_ID_END = 12;
    private static final String ORA_SQL_ID_ALPHABET = "0123456789abcdfghjkmnpqrstuvwxyz";
    private static final byte NULL_CHAR_BYTE = 0;
    private static String version = "undefined";
    private static int versionMajor = 0;
    private static int versionMinor = 0;

    public static String getVersion() {
        return version;
    }

    public static int getVersionMajor() {
        return versionMajor;
    }

    public static int getVersionMinor() {
        return versionMinor;
    }

    public static void write2Yaml(Writer writer, String sqlId, String sqlStatement) throws IOException {
        String[] sqlLines = sqlStatement.split("\n");
        writer.append(sqlId).append(": ");
        if (sqlLines.length > 1) {
            writer.append("|-\n");
            boolean firstLine = true;
            for (int i = 0; i < sqlLines.length; ++i) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    writer.append("\n");
                }
                writer.append("  ").append(sqlLines[i]);
            }
        } else {
            writer.append(sqlStatement);
        }
        writer.append('\n');
    }

    public static void readSimpleYaml(BufferedReader reader, Map<String, String> mappingData) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            boolean readNextLine = true;
            if (line.trim().length() > 13) {
                int semiColonPos = line.indexOf(58);
                if (semiColonPos >= 13 && semiColonPos < line.length() - 1) {
                    int pos;
                    String sqlId = line.substring(0, 13);
                    String sqlStatement = "";
                    boolean multiLine = false;
                    for (pos = semiColonPos + 1; pos < line.length(); ++pos) {
                        if (line.charAt(pos) == ' ' || line.charAt(pos) == '\t') continue;
                        if (line.charAt(pos) != '|' || pos + 1 > line.length() || line.charAt(pos + 1) != '-') break;
                        multiLine = true;
                        break;
                    }
                    if (multiLine) {
                        StringBuilder sb = new StringBuilder(line.length() * 16);
                        while (readNextLine) {
                            line = reader.readLine();
                            if (line == null || !line.startsWith("  ")) {
                                readNextLine = false;
                                continue;
                            }
                            sb.append(line.substring(2)).append('\n');
                        }
                        sqlStatement = sb.toString();
                    } else {
                        sqlStatement = line.substring(pos);
                    }
                    mappingData.put(sqlId, sqlStatement);
                } else {
                    throw new IOException("Invalid format for YAML file!");
                }
            }
            if (!readNextLine) continue;
            line = reader.readLine();
        }
    }

    public static String sql_id(String sqlText) throws SQLException {
        try {
            String strHex32Hash = OraProxyUtils.getStatementMd5Hash(sqlText);
            String strHexQ3Reverse = strHex32Hash.substring(22, 24) + strHex32Hash.substring(20, 22) + strHex32Hash.substring(18, 20) + strHex32Hash.substring(16, 18);
            String strHexQ4Reverse = strHex32Hash.substring(30, 32) + strHex32Hash.substring(28, 30) + strHex32Hash.substring(26, 28) + strHex32Hash.substring(24, 26);
            String strHexLower16Assembly = strHexQ3Reverse + strHexQ4Reverse;
            String strBinary16Assembly = new BigInteger(strHexLower16Assembly, 16).toString(2);
            StringBuilder sbBinary16mAssembly = new StringBuilder();
            for (int toLefPad = 64 - strBinary16Assembly.length(); toLefPad > 0; --toLefPad) {
                sbBinary16mAssembly.append('0');
            }
            sbBinary16mAssembly.append(strBinary16Assembly);
            strBinary16Assembly = sbBinary16mAssembly.toString();
            StringBuilder sbSQLId = new StringBuilder();
            for (int i = 0; i < 13; ++i) {
                String strPartBindaySplit = i == 0 ? strBinary16Assembly.substring(0, 4) : (i < 12 ? strBinary16Assembly.substring(i * 5 - 1, i * 5 + 4) : strBinary16Assembly.substring(i * 5 - 1));
                int intIndexOnAlphabet = Integer.parseInt(strPartBindaySplit, 2);
                sbSQLId.append(ORA_SQL_ID_ALPHABET.charAt(intIndexOnAlphabet));
            }
            return sbSQLId.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(String.format("Unable to convert SQL text\n\t'%s'\n\t\tto UTF-8 encoding.", sqlText));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException(String.format("Unable to init crypto while calculating SQL_ID for '%s'.", sqlText));
        }
    }

    public static BigInteger hash_value(String sqlText) throws SQLException {
        try {
            String strHex32Hash = OraProxyUtils.getStatementMd5Hash(sqlText);
            String strHexQ4Reverse = strHex32Hash.substring(30, 32) + strHex32Hash.substring(28, 30) + strHex32Hash.substring(26, 28) + strHex32Hash.substring(24, 26);
            return new BigInteger(strHexQ4Reverse, 16);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(String.format("Unable to convert SQL text\n\t'%s'\n\t\tto UTF-8 encoding.", sqlText));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException(String.format("Unable to init crypto while calculating HASH_VALUE for '%s'.", sqlText));
        }
    }

    private static String getStatementMd5Hash(String sqlText) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] bytesOfStatement = sqlText.getBytes("UTF-8");
        byte[] bytesOfStatementWithNull = new byte[bytesOfStatement.length + 1];
        System.arraycopy(bytesOfStatement, 0, bytesOfStatementWithNull, 0, bytesOfStatement.length);
        bytesOfStatementWithNull[bytesOfStatement.length] = 0;
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] bytesFromMD5Digest = md.digest(bytesOfStatementWithNull);
        StringBuilder sbMD5HashHex32 = new StringBuilder(32);
        for (int i = 0; i < bytesFromMD5Digest.length; ++i) {
            sbMD5HashHex32.append(Integer.toString((bytesFromMD5Digest[i] & 0xFF) + 256, 16).substring(1));
        }
        return sbMD5HashHex32.toString();
    }

    static {
        try (InputStream is = OraProxyUtils.class.getResourceAsStream(PROPS_PATH);){
            Properties props = new Properties();
            props.load(is);
            version = props.getProperty("version", version).trim();
            int firstDotPos = version.indexOf(46);
            int secondDotPos = firstDotPos + version.substring(firstDotPos + 1).indexOf(46) + 1;
            versionMajor = Integer.parseInt(version.substring(0, firstDotPos));
            versionMinor = Integer.parseInt(version.substring(firstDotPos + 1, secondDotPos));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage());
        }
    }
}

