/*
 * Decompiled with CFR 0.152.
 */
package solutions.a2.oracle.jdbc;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import solutions.a2.oracle.jdbc.OraProxyTranslatorIntf;
import solutions.a2.oracle.jdbc.OraProxyUtils;

public class OraProxySqlTranslatorChronicle
implements OraProxyTranslatorIntf {
    private final ChronicleMap<String, String> sqlMap;

    OraProxySqlTranslatorChronicle(URL mappingFileUrl) throws SQLException {
        if ("file".equals(mappingFileUrl.getProtocol())) {
            try {
                this.sqlMap = ChronicleMapBuilder.of(String.class, String.class).createOrRecoverPersistedTo(new File(mappingFileUrl.getFile()));
            }
            catch (IOException ioe) {
                throw new SQLException(String.format("Unable to instantiate Chronicle Map from file '%s'!", mappingFileUrl.getFile()), ioe);
            }
        } else {
            throw new SQLException("Only 'file' URL is currently supported for Chronicle Map!");
        }
    }

    @Override
    public String translate(String source) throws SQLException {
        String sqlId = OraProxyUtils.sql_id(source);
        return this.sqlMap.getOrDefault(sqlId, source);
    }
}

