/*
 * Decompiled with CFR 0.152.
 */
package solutions.a2.oracle.jdbc;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import solutions.a2.oracle.jdbc.OraProxySqlTranslatorChronicle;
import solutions.a2.oracle.jdbc.OraProxySqlTranslatorMap;
import solutions.a2.oracle.jdbc.OraProxyTranslatorIntf;

public class OraProxySqlTranslator {
    private static OraProxySqlTranslator instance;
    private final OraProxyTranslatorIntf translator;

    private OraProxySqlTranslator(boolean yamlStore, String mappingFileUrl) throws SQLException {
        URL url;
        if (mappingFileUrl.startsWith("s3:")) {
            throw new SQLException("S3 support not implemented yet!");
        }
        try {
            url = new URL(mappingFileUrl);
        }
        catch (MalformedURLException mfe) {
            throw new SQLException(String.format("Malformed URL '%s'", mappingFileUrl), mfe);
        }
        this.translator = yamlStore ? new OraProxySqlTranslatorMap(url) : new OraProxySqlTranslatorChronicle(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OraProxySqlTranslator getInstance(boolean yamlStore, String fileUrl) throws SQLException {
        if (instance != null) return instance;
        Class<OraProxySqlTranslator> clazz = OraProxySqlTranslator.class;
        synchronized (OraProxySqlTranslator.class) {
            instance = new OraProxySqlTranslator(yamlStore, fileUrl);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public String translate(String source) throws SQLException {
        return this.translator.translate(source);
    }
}

