/*
 * Decompiled with CFR 0.152.
 */
package solutions.a2.oracle.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import solutions.a2.oracle.jdbc.OraProxyResultSet;
import solutions.a2.oracle.jdbc.OraProxySqlTranslator;

public class OraProxyPreparedStatement
implements OraclePreparedStatement {
    final OracleConnection connection;
    final OraclePreparedStatement oracle;
    final OraProxySqlTranslator translator;

    OraProxyPreparedStatement(OracleConnection connection, OraclePreparedStatement statement, OraProxySqlTranslator translator) {
        this.connection = connection;
        this.oracle = statement;
        this.translator = translator;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return new OraProxyResultSet((Statement)((Object)this), (OracleResultSet)this.oracle.executeQuery(this.translator.translate(sql)));
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql));
    }

    public boolean execute(String sql) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql));
    }

    public void addBatch(String sql) throws SQLException {
        this.oracle.addBatch(this.translator.translate(sql));
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql), autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql), columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.oracle.executeUpdate(this.translator.translate(sql), columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql), autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql), columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.oracle.execute(this.translator.translate(sql), columnNames);
    }

    public ResultSet executeQuery() throws SQLException {
        return new OraProxyResultSet((Statement)((Object)this), (OracleResultSet)this.oracle.executeQuery());
    }

    public ResultSet getResultSet() throws SQLException {
        return new OraProxyResultSet((Statement)((Object)this), (OracleResultSet)this.oracle.getResultSet());
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return new OraProxyResultSet((Statement)((Object)this), (OracleResultSet)this.oracle.getGeneratedKeys());
    }

    public ResultSet getReturnResultSet() throws SQLException {
        return new OraProxyResultSet((Statement)((Object)this), (OracleResultSet)this.oracle.getReturnResultSet());
    }

    public void close() throws SQLException {
        this.oracle.close();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.oracle.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.oracle.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.oracle.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.oracle.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.oracle.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.oracle.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.oracle.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.oracle.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.oracle.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.oracle.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.oracle.setCursorName(name);
    }

    public int getUpdateCount() throws SQLException {
        return this.oracle.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.oracle.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.oracle.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.oracle.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.oracle.setFetchDirection(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.oracle.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.oracle.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.oracle.getResultSetType();
    }

    public void clearBatch() throws SQLException {
        this.oracle.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.oracle.executeBatch();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.oracle.getMoreResults();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.oracle.getResultSetHoldability();
    }

    public boolean isClosed() throws SQLException {
        return this.oracle.isClosed();
    }

    public void setPoolable(boolean poolable) throws SQLException {
        this.oracle.setPoolable(poolable);
    }

    public boolean isPoolable() throws SQLException {
        return this.oracle.isPoolable();
    }

    public void closeOnCompletion() throws SQLException {
        this.oracle.closeOnCompletion();
    }

    public boolean isCloseOnCompletion() throws SQLException {
        return this.oracle.isCloseOnCompletion();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.oracle.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.oracle.isWrapperFor(iface);
    }

    public int executeUpdate() throws SQLException {
        return this.oracle.executeUpdate();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.oracle.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.oracle.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.oracle.setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.oracle.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.oracle.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.oracle.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.oracle.setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.oracle.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.oracle.setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.oracle.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.oracle.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.oracle.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.oracle.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.oracle.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.oracle.setAsciiStream(parameterIndex, x, length);
    }

    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.oracle.setUnicodeStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.oracle.setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        this.oracle.clearParameters();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.oracle.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.oracle.setObject(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        return this.oracle.execute();
    }

    public void addBatch() throws SQLException {
        this.oracle.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.oracle.setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.oracle.setRef(parameterIndex, x);
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.oracle.setBlob(parameterIndex, x);
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.oracle.setClob(parameterIndex, x);
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.oracle.setArray(parameterIndex, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.oracle.getMetaData();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.oracle.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.oracle.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.oracle.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.oracle.setNull(parameterIndex, sqlType, typeName);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.oracle.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.oracle.getParameterMetaData();
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.oracle.setRowId(parameterIndex, x);
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this.oracle.setNString(parameterIndex, value);
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.oracle.setNCharacterStream(parameterIndex, value, length);
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.oracle.setNClob(parameterIndex, value);
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.oracle.setClob(parameterIndex, reader, length);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.oracle.setBlob(parameterIndex, inputStream, length);
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.oracle.setNClob(parameterIndex, reader, length);
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.oracle.setSQLXML(parameterIndex, xmlObject);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.oracle.setObject(parameterIndex, x, scaleOrLength);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.oracle.setAsciiStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.oracle.setBinaryStream(parameterIndex, x, length);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.oracle.setCharacterStream(parameterIndex, reader, length);
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.oracle.setAsciiStream(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.oracle.setBinaryStream(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.oracle.setCharacterStream(parameterIndex, reader);
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.oracle.setNCharacterStream(parameterIndex, value);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.oracle.setClob(parameterIndex, reader);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.oracle.setBlob(parameterIndex, inputStream);
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.oracle.setNClob(parameterIndex, reader);
    }

    public void clearDefines() throws SQLException {
        this.oracle.clearDefines();
    }

    public void closeWithKey(String key) throws SQLException {
        this.oracle.closeWithKey(key);
    }

    @Deprecated
    public int creationState() {
        return this.oracle.creationState();
    }

    public void defineColumnType(int columnIndex, int type) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type);
    }

    public void defineColumnType(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type, lobPrefetchSize);
    }

    public void defineColumnType(int columnIndex, int type, String typeName) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type, typeName);
    }

    @Deprecated
    public void defineColumnType(int columnIndex, int type, int lobPrefetchSize, short formOfUse) throws SQLException {
        this.oracle.defineColumnType(columnIndex, type, lobPrefetchSize, formOfUse);
    }

    @Deprecated
    public void defineColumnTypeBytes(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.oracle.defineColumnTypeBytes(columnIndex, type, lobPrefetchSize);
    }

    @Deprecated
    public void defineColumnTypeChars(int columnIndex, int type, int lobPrefetchSize) throws SQLException {
        this.oracle.defineColumnTypeChars(columnIndex, type, lobPrefetchSize);
    }

    public int getLobPrefetchSize() throws SQLException {
        return this.oracle.getLobPrefetchSize();
    }

    public long getRegisteredQueryId() throws SQLException {
        return this.oracle.getRegisteredQueryId();
    }

    public String[] getRegisteredTableNames() throws SQLException {
        return this.oracle.getRegisteredTableNames();
    }

    public int getRowPrefetch() {
        return this.oracle.getRowPrefetch();
    }

    public boolean isNCHAR(int index) throws SQLException {
        return this.oracle.isNCHAR(index);
    }

    public void setDatabaseChangeRegistration(DatabaseChangeRegistration registration) throws SQLException {
        this.oracle.setDatabaseChangeRegistration(registration);
    }

    public void setLobPrefetchSize(int size) throws SQLException {
        this.oracle.setLobPrefetchSize(size);
    }

    public void setRowPrefetch(int size) throws SQLException {
        this.oracle.setRowPrefetch(size);
    }

    public OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
        return this.oracle.OracleGetParameterMetaData();
    }

    public void defineParameterType(int parameterIndex, int type, int maxSize) throws SQLException {
        this.oracle.defineParameterType(parameterIndex, type, maxSize);
    }

    public void defineParameterTypeBytes(int parameterIndex, int type, int maxSize) throws SQLException {
        this.oracle.defineParameterTypeBytes(parameterIndex, type, maxSize);
    }

    public void defineParameterTypeChars(int parameterIndex, int type, int maxSize) throws SQLException {
        this.oracle.defineParameterTypeChars(parameterIndex, type, maxSize);
    }

    @Deprecated
    public int getExecuteBatch() {
        return this.oracle.getExecuteBatch();
    }

    public void registerReturnParameter(int parameterIndex, int externalType) throws SQLException {
        this.oracle.registerReturnParameter(parameterIndex, externalType);
    }

    public void registerReturnParameter(int parameterIndex, int externalType, int maxSize) throws SQLException {
        this.oracle.registerReturnParameter(parameterIndex, externalType, maxSize);
    }

    public void registerReturnParameter(int parameterIndex, int externalType, String typeName) throws SQLException {
        this.oracle.registerReturnParameter(parameterIndex, externalType, typeName);
    }

    @Deprecated
    public int sendBatch() throws SQLException {
        return this.oracle.sendBatch();
    }

    public void setARRAY(int parameterIndex, ARRAY value) throws SQLException {
        this.oracle.setARRAY(parameterIndex, value);
    }

    public void setARRAYAtName(String parameterName, ARRAY value) throws SQLException {
        this.oracle.setARRAYAtName(parameterName, value);
    }

    public void setArrayAtName(String parameterName, Array value) throws SQLException {
        this.oracle.setArrayAtName(parameterName, value);
    }

    public void setAsciiStreamAtName(String parameterName, InputStream stream) throws SQLException {
        this.oracle.setAsciiStreamAtName(parameterName, stream);
    }

    public void setAsciiStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
        this.oracle.setAsciiStreamAtName(parameterName, stream, length);
    }

    public void setAsciiStreamAtName(String parameterName, InputStream stream, long length) throws SQLException {
        this.oracle.setAsciiStreamAtName(parameterName, stream, length);
    }

    public void setBFILE(int parameterIndex, BFILE value) throws SQLException {
        this.oracle.setBFILE(parameterIndex, value);
    }

    public void setBFILEAtName(String parameterName, BFILE value) throws SQLException {
        this.oracle.setBFILEAtName(parameterName, value);
    }

    public void setBLOB(int parameterIndex, BLOB value) throws SQLException {
        this.oracle.setBLOB(parameterIndex, value);
    }

    public void setBLOBAtName(String parameterName, BLOB value) throws SQLException {
        this.oracle.setBLOBAtName(parameterName, value);
    }

    public void setBfile(int parameterIndex, BFILE value) throws SQLException {
        this.oracle.setBfile(parameterIndex, value);
    }

    public void setBfileAtName(String parameterName, BFILE value) throws SQLException {
        this.oracle.setBfileAtName(parameterName, value);
    }

    public void setBigDecimalAtName(String parameterName, BigDecimal value) throws SQLException {
        this.oracle.setBigDecimalAtName(parameterName, value);
    }

    public void setBinaryDouble(int parameterIndex, double value) throws SQLException {
        this.oracle.setBinaryDouble(parameterIndex, value);
    }

    public void setBinaryDouble(int parameterIndex, BINARY_DOUBLE value) throws SQLException {
        this.oracle.setBinaryDouble(parameterIndex, value);
    }

    public void setBinaryDoubleAtName(String parameterName, double value) throws SQLException {
        this.oracle.setBinaryDoubleAtName(parameterName, value);
    }

    public void setBinaryDoubleAtName(String parameterName, BINARY_DOUBLE value) throws SQLException {
        this.oracle.setBinaryDoubleAtName(parameterName, value);
    }

    public void setBinaryFloat(int parameterIndex, float value) throws SQLException {
        this.oracle.setBinaryFloat(parameterIndex, value);
    }

    public void setBinaryFloat(int parameterIndex, BINARY_FLOAT value) throws SQLException {
        this.oracle.setBinaryFloat(parameterIndex, value);
    }

    public void setBinaryFloatAtName(String parameterName, float value) throws SQLException {
        this.oracle.setBinaryFloatAtName(parameterName, value);
    }

    public void setBinaryFloatAtName(String parameterName, BINARY_FLOAT value) throws SQLException {
        this.oracle.setBinaryFloatAtName(parameterName, value);
    }

    public void setBinaryStreamAtName(String parameterName, InputStream stream) throws SQLException {
        this.oracle.setBinaryStreamAtName(parameterName, stream);
    }

    public void setBinaryStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
        this.oracle.setBinaryStreamAtName(parameterName, stream, length);
    }

    public void setBinaryStreamAtName(String parameterName, InputStream stream, long length) throws SQLException {
        this.oracle.setBinaryStreamAtName(parameterName, stream, length);
    }

    public void setBlobAtName(String parameterName, Blob value) throws SQLException {
        this.oracle.setBlobAtName(parameterName, value);
    }

    public void setBlobAtName(String parameterName, InputStream stream) throws SQLException {
        this.oracle.setBlobAtName(parameterName, stream);
    }

    public void setBlobAtName(String parameterName, InputStream stream, long length) throws SQLException {
        this.oracle.setBlobAtName(parameterName, stream, length);
    }

    public void setBooleanAtName(String parameterName, boolean value) throws SQLException {
        this.oracle.setBooleanAtName(parameterName, value);
    }

    public void setByteAtName(String parameterName, byte value) throws SQLException {
        this.oracle.setByteAtName(parameterName, value);
    }

    public void setBytesAtName(String parameterName, byte[] value) throws SQLException {
        this.oracle.setBytesAtName(parameterName, value);
    }

    public void setBytesForBlob(int parameterIndex, byte[] value) throws SQLException {
        this.oracle.setBytesForBlob(parameterIndex, value);
    }

    public void setBytesForBlobAtName(String parameterName, byte[] value) throws SQLException {
        this.oracle.setBytesForBlobAtName(parameterName, value);
    }

    public void setCHAR(int parameterIndex, CHAR value) throws SQLException {
        this.oracle.setCHAR(parameterIndex, value);
    }

    public void setCHARAtName(String parameterName, CHAR value) throws SQLException {
        this.oracle.setCHARAtName(parameterName, value);
    }

    public void setCLOB(int parameterIndex, CLOB value) throws SQLException {
        this.oracle.setCLOB(parameterIndex, value);
    }

    public void setCLOBAtName(String parameterName, CLOB value) throws SQLException {
        this.oracle.setCLOBAtName(parameterName, value);
    }

    public void setCharacterStreamAtName(String parameterName, Reader reader) throws SQLException {
        this.oracle.setCharacterStreamAtName(parameterName, reader);
    }

    public void setCharacterStreamAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setCharacterStreamAtName(parameterName, reader, length);
    }

    public void setCheckBindTypes(boolean flag) {
        this.oracle.setCheckBindTypes(flag);
    }

    public void setClobAtName(String parameterName, Clob value) throws SQLException {
        this.oracle.setClobAtName(parameterName, value);
    }

    public void setClobAtName(String parameterName, Reader reader) throws SQLException {
        this.oracle.setClobAtName(parameterName, reader);
    }

    public void setClobAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setClobAtName(parameterName, reader, length);
    }

    @Deprecated
    public void setCursor(int parameterIndex, ResultSet value) throws SQLException {
        this.oracle.setCursor(parameterIndex, value);
    }

    public void setCursorAtName(String parameterName, ResultSet value) throws SQLException {
        this.oracle.setCursorAtName(parameterName, value);
    }

    @Deprecated
    public void setCustomDatum(int parameterIndex, CustomDatum value) throws SQLException {
        this.oracle.setCustomDatum(parameterIndex, value);
    }

    public void setCustomDatumAtName(String parameterName, CustomDatum value) throws SQLException {
        this.oracle.setCustomDatumAtName(parameterName, value);
    }

    public void setDATE(int parameterIndex, DATE value) throws SQLException {
        this.oracle.setDATE(parameterIndex, value);
    }

    public void setDATEAtName(String parameterName, DATE value) throws SQLException {
        this.oracle.setDATEAtName(parameterName, value);
    }

    public void setDateAtName(String parameterName, Date value) throws SQLException {
        this.oracle.setDateAtName(parameterName, value);
    }

    public void setDateAtName(String parameterName, Date value, Calendar cal) throws SQLException {
        this.oracle.setDateAtName(parameterName, value, cal);
    }

    public void setDisableStmtCaching(boolean cache) {
        this.oracle.setDisableStmtCaching(cache);
    }

    public void setDoubleAtName(String parameterName, double value) throws SQLException {
        this.oracle.setDoubleAtName(parameterName, value);
    }

    @Deprecated
    public void setExecuteBatch(int batchValue) throws SQLException {
        this.oracle.setExecuteBatch(batchValue);
    }

    public void setFixedCHAR(int parameterIndex, String value) throws SQLException {
        this.oracle.setFixedCHAR(parameterIndex, value);
    }

    public void setFixedCHARAtName(String parameterName, String value) throws SQLException {
        this.oracle.setFixedCHARAtName(parameterName, value);
    }

    public void setFloatAtName(String parameterName, float value) throws SQLException {
        this.oracle.setFloatAtName(parameterName, value);
    }

    public void setFormOfUse(int parameterIndex, short formOfUse) {
        this.oracle.setFormOfUse(parameterIndex, formOfUse);
    }

    public void setINTERVALDS(int parameterIndex, INTERVALDS value) throws SQLException {
        this.oracle.setINTERVALDS(parameterIndex, value);
    }

    public void setINTERVALDSAtName(String parameterName, INTERVALDS value) throws SQLException {
        this.oracle.setINTERVALDSAtName(parameterName, value);
    }

    public void setINTERVALYM(int parameterIndex, INTERVALYM value) throws SQLException {
        this.oracle.setINTERVALYM(parameterIndex, value);
    }

    public void setINTERVALYMAtName(String parameterName, INTERVALYM value) throws SQLException {
        this.oracle.setINTERVALYMAtName(parameterName, value);
    }

    public void setIntAtName(String parameterName, int value) throws SQLException {
        this.oracle.setIntAtName(parameterName, value);
    }

    public void setLongAtName(String parameterName, long value) throws SQLException {
        this.oracle.setLongAtName(parameterName, value);
    }

    public void setNCharacterStreamAtName(String parameterName, Reader reader) throws SQLException {
        this.oracle.setNCharacterStreamAtName(parameterName, reader);
    }

    public void setNCharacterStreamAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setNCharacterStreamAtName(parameterName, reader, length);
    }

    public void setNClobAtName(String parameterName, NClob value) throws SQLException {
        this.oracle.setNClobAtName(parameterName, value);
    }

    public void setNClobAtName(String parameterName, Reader reader) throws SQLException {
        this.oracle.setNClobAtName(parameterName, reader);
    }

    public void setNClobAtName(String parameterName, Reader reader, long length) throws SQLException {
        this.oracle.setNClobAtName(parameterName, reader, length);
    }

    public void setNStringAtName(String parameterName, String value) throws SQLException {
        this.oracle.setNStringAtName(parameterName, value);
    }

    public void setNUMBER(int parameterIndex, NUMBER value) throws SQLException {
        this.oracle.setNUMBER(parameterIndex, value);
    }

    public void setNUMBERAtName(String parameterName, NUMBER value) throws SQLException {
        this.oracle.setNUMBERAtName(parameterName, value);
    }

    public void setNullAtName(String parameterName, int value) throws SQLException {
        this.oracle.setNullAtName(parameterName, value);
    }

    public void setNullAtName(String parameterName, int sqlType, String sqlName) throws SQLException {
        this.oracle.setNullAtName(parameterName, sqlType, sqlName);
    }

    public void setOPAQUE(int parameterIndex, OPAQUE value) throws SQLException {
        this.oracle.setOPAQUE(parameterIndex, value);
    }

    public void setOPAQUEAtName(String parameterName, OPAQUE value) throws SQLException {
        this.oracle.setOPAQUEAtName(parameterName, value);
    }

    public void setORAData(int parameterIndex, ORAData value) throws SQLException {
        this.oracle.setORAData(parameterIndex, value);
    }

    public void setORADataAtName(String parameterName, ORAData value) throws SQLException {
        this.oracle.setORADataAtName(parameterName, value);
    }

    public void setObjectAtName(String parameterName, Object value) throws SQLException {
        this.oracle.setObjectAtName(parameterName, value);
    }

    public void setObjectAtName(String parameterName, Object value, int targetSqlType) throws SQLException {
        this.oracle.setObjectAtName(parameterName, value, targetSqlType);
    }

    public void setObjectAtName(String parameterName, Object value, int targetSqlType, int scale) throws SQLException {
        this.oracle.setObjectAtName(parameterName, value, targetSqlType, scale);
    }

    public void setOracleObject(int parameterIndex, Datum value) throws SQLException {
        this.oracle.setOracleObject(parameterIndex, value);
    }

    public void setOracleObjectAtName(String parameterName, Datum value) throws SQLException {
        this.oracle.setOracleObjectAtName(parameterName, value);
    }

    public void setPlsqlIndexTable(int parameterIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        this.oracle.setPlsqlIndexTable(parameterIndex, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
    }

    public void setRAW(int parameterIndex, RAW value) throws SQLException {
        this.oracle.setRAW(parameterIndex, value);
    }

    public void setRAWAtName(String parameterName, RAW value) throws SQLException {
        this.oracle.setRAWAtName(parameterName, value);
    }

    public void setREF(int parameterIndex, REF value) throws SQLException {
        this.oracle.setREF(parameterIndex, value);
    }

    public void setREFAtName(String parameterName, REF value) throws SQLException {
        this.oracle.setREFAtName(parameterName, value);
    }

    public void setROWID(int parameterIndex, ROWID value) throws SQLException {
        this.oracle.setROWID(parameterIndex, value);
    }

    public void setROWIDAtName(String parameterName, ROWID value) throws SQLException {
        this.oracle.setROWIDAtName(parameterName, value);
    }

    public void setRefAtName(String parameterName, Ref value) throws SQLException {
        this.oracle.setRefAtName(parameterName, value);
    }

    public void setRefType(int parameterIndex, REF value) throws SQLException {
        this.oracle.setRefType(parameterIndex, value);
    }

    public void setRefTypeAtName(String parameterName, REF value) throws SQLException {
        this.oracle.setRefTypeAtName(parameterName, value);
    }

    public void setRowIdAtName(String parameterName, RowId value) throws SQLException {
        this.oracle.setRowIdAtName(parameterName, value);
    }

    public void setSQLXMLAtName(String parameterName, SQLXML value) throws SQLException {
        this.oracle.setSQLXMLAtName(parameterName, value);
    }

    public void setSTRUCT(int parameterIndex, STRUCT value) throws SQLException {
        this.oracle.setSTRUCT(parameterIndex, value);
    }

    public void setSTRUCTAtName(String parameterName, STRUCT value) throws SQLException {
        this.oracle.setSTRUCTAtName(parameterName, value);
    }

    public void setShortAtName(String parameterName, short value) throws SQLException {
        this.oracle.setShortAtName(parameterName, value);
    }

    public void setStringAtName(String parameterName, String value) throws SQLException {
        this.oracle.setStringAtName(parameterName, value);
    }

    public void setStringForClob(int parameterIndex, String value) throws SQLException {
        this.oracle.setStringForClob(parameterIndex, value);
    }

    public void setStringForClobAtName(String parameterName, String value) throws SQLException {
        this.oracle.setStringForClobAtName(parameterName, value);
    }

    public void setStructDescriptor(int parameterIndex, StructDescriptor value) throws SQLException {
        this.oracle.setStructDescriptor(parameterIndex, value);
    }

    public void setStructDescriptorAtName(String parameterName, StructDescriptor value) throws SQLException {
        this.oracle.setStructDescriptorAtName(parameterName, value);
    }

    public void setTIMESTAMP(int parameterIndex, TIMESTAMP value) throws SQLException {
        this.oracle.setTIMESTAMP(parameterIndex, value);
    }

    public void setTIMESTAMPAtName(String parameterName, TIMESTAMP value) throws SQLException {
        this.oracle.setTIMESTAMPAtName(parameterName, value);
    }

    public void setTIMESTAMPLTZ(int parameterIndex, TIMESTAMPLTZ value) throws SQLException {
        this.oracle.setTIMESTAMPLTZ(parameterIndex, value);
    }

    public void setTIMESTAMPLTZAtName(String parameterName, TIMESTAMPLTZ value) throws SQLException {
        this.oracle.setTIMESTAMPLTZAtName(parameterName, value);
    }

    public void setTIMESTAMPTZ(int parameterIndex, TIMESTAMPTZ value) throws SQLException {
        this.oracle.setTIMESTAMPTZ(parameterIndex, value);
    }

    public void setTIMESTAMPTZAtName(String parameterName, TIMESTAMPTZ value) throws SQLException {
        this.oracle.setTIMESTAMPTZAtName(parameterName, value);
    }

    public void setTimeAtName(String parameterName, Time value) throws SQLException {
        this.oracle.setTimeAtName(parameterName, value);
    }

    public void setTimeAtName(String parameterName, Time value, Calendar cal) throws SQLException {
        this.oracle.setTimeAtName(parameterName, value, cal);
    }

    public void setTimestampAtName(String parameterName, Timestamp value) throws SQLException {
        this.oracle.setTimestampAtName(parameterName, value);
    }

    public void setTimestampAtName(String parameterName, Timestamp value, Calendar cal) throws SQLException {
        this.oracle.setTimestampAtName(parameterName, value, cal);
    }

    public void setURLAtName(String parameterName, URL value) throws SQLException {
        this.oracle.setURLAtName(parameterName, value);
    }

    public void setUnicodeStreamAtName(String parameterName, InputStream stream, int length) throws SQLException {
        this.oracle.setUnicodeStreamAtName(parameterName, stream, length);
    }
}

