/*
 * Decompiled with CFR 0.152.
 */
package solutions.a2.oracle.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleConnection;
import solutions.a2.oracle.jdbc.OraProxyConnection;
import solutions.a2.oracle.jdbc.OraProxySqlTranslator;
import solutions.a2.oracle.jdbc.OraProxyUtils;

public class OraProxyDriver
implements Driver {
    public static final String A2_MAPPING_FILE_URL = "a2.mapping.file.url";
    public static final String A2_MAPPING_FILE_TYPE = "a2.mapping.file.type";
    private static final String URL_PREFIX = "jdbc:proxy:oracle:";
    private static final String ORA_PREFIX = "jdbc:oracle:thin:";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            int paramsPos = url.indexOf(63);
            if (paramsPos > -1) {
                StringBuilder sb = new StringBuilder(url.length());
                sb.append(url.substring(0, paramsPos).replace(URL_PREFIX, ORA_PREFIX));
                String mappingFile = null;
                boolean useYamlStore = true;
                boolean formatParamPresent = false;
                boolean firstParam = true;
                for (String param : url.substring(paramsPos + 1).split("&")) {
                    if (param.startsWith(A2_MAPPING_FILE_URL)) {
                        mappingFile = param.substring(param.indexOf(61) + 1);
                        continue;
                    }
                    if (param.startsWith(A2_MAPPING_FILE_TYPE)) {
                        formatParamPresent = true;
                        String mappingFileType = param.substring(param.indexOf(61) + 1);
                        if ("yaml".equals(mappingFileType)) {
                            useYamlStore = true;
                            continue;
                        }
                        if ("chronicle".equals(mappingFileType)) {
                            useYamlStore = false;
                            continue;
                        }
                        throw new SQLException("For the 'a2.mapping.file.type' only yaml and chronicle are allowed!");
                    }
                    if (firstParam) {
                        sb.append('?');
                        firstParam = false;
                    } else {
                        sb.append('&');
                    }
                    sb.append(param);
                }
                if (mappingFile == null) {
                    if (info.containsKey(A2_MAPPING_FILE_URL)) {
                        mappingFile = info.getProperty(A2_MAPPING_FILE_URL);
                    } else {
                        throw new SQLException("The 'a2.mapping.file.url' parameter must be set!");
                    }
                }
                if (!formatParamPresent && info.containsKey(A2_MAPPING_FILE_TYPE)) {
                    String mappingFileType = info.getProperty(A2_MAPPING_FILE_TYPE);
                    if ("yaml".equals(mappingFileType)) {
                        useYamlStore = true;
                    } else if ("chronicle".equals(mappingFileType)) {
                        useYamlStore = false;
                    } else {
                        throw new SQLException("For the 'a2.mapping.file.type' only yaml and chronicle are allowed!");
                    }
                }
                OraProxySqlTranslator translator = OraProxySqlTranslator.getInstance(useYamlStore, mappingFile);
                Driver oraDriver = DriverManager.getDriver(sb.toString());
                return new OraProxyConnection((oracle.jdbc.OracleConnection)((OracleConnection)oraDriver.connect(sb.toString(), info)), translator);
            }
            throw new SQLException("Incorrect format of '" + url + "' for driver!");
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public int getMajorVersion() {
        return OraProxyUtils.getVersionMajor();
    }

    @Override
    public int getMinorVersion() {
        return OraProxyUtils.getVersionMinor();
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("oracle.jdbc");
    }

    static {
        try {
            DriverManager.registerDriver(new OraProxyDriver());
        }
        catch (SQLException sqle) {
            throw new RuntimeException("Unable to register orajdbc-proxy driver!");
        }
    }
}

