/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.channel.internal;

import java.io.IOException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.hash.serialization.impl.BytesMarshallableReaderWriter;
import net.openhft.chronicle.hash.serialization.impl.BytesSizedMarshaller;
import net.openhft.chronicle.hash.serialization.impl.MarshallableReaderWriter;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.channel.MapService;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.channel.ChannelHeader;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;
import net.openhft.chronicle.wire.channel.OkHeader;
import org.jetbrains.annotations.NotNull;

public class MapChannel<VALUE, REPLY>
extends SimpleCloseable
implements ChronicleChannel {
    private static final OkHeader OK = new OkHeader();
    private final String mapName;
    private final MapService<VALUE, REPLY> mapService;
    private final ChronicleChannelCfg channelCfg;
    private final ChronicleMap<Bytes<?>, VALUE> map;
    private final Wire replyWire = (Wire)WireType.BINARY_LIGHT.apply(Bytes.allocateElasticOnHeap());

    public MapChannel(String mapName, MapService<VALUE, REPLY> mapService, ChronicleContext context, ChronicleChannelCfg channelCfg) {
        this.mapName = mapName;
        this.mapService = mapService;
        this.channelCfg = channelCfg;
        try {
            this.map = MapChannel.createMap(mapName, mapService, context);
            mapService.map(this.map);
            REPLY reply = this.replyWire.methodWriter(mapService.replyClass(), new Class[0]);
            mapService.reply(reply);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static <VALUE, REPLY> ChronicleMap<Bytes<?>, VALUE> createMap(String mapName, MapService<VALUE, REPLY> mapService, ChronicleContext context) throws IOException {
        Class<VALUE> valueClass = mapService.valueClass();
        Class<Bytes> bytesClass = Bytes.class;
        ChronicleMapBuilder builder = ((ChronicleMapBuilder)((ChronicleMapBuilder)((ChronicleMapBuilder)ChronicleMap.of(bytesClass, valueClass).keyMarshaller(new BytesSizedMarshaller())).averageKeySize(32.0)).averageValueSize(256.0).entries(1000000L)).putReturnsNull(true).removeReturnsNull(true);
        if (BytesMarshallable.class.isAssignableFrom(valueClass)) {
            builder.valueMarshaller(new BytesMarshallableReaderWriter<VALUE>(valueClass));
        } else if (Marshallable.class.isAssignableFrom(valueClass)) {
            builder.valueMarshaller(new MarshallableReaderWriter<VALUE>(valueClass));
        }
        return builder.createPersistedTo(context.toFile(mapName + ".cm3"));
    }

    @Override
    public ChronicleChannelCfg channelCfg() {
        return this.channelCfg;
    }

    @Override
    public ChannelHeader headerOut() {
        return OK;
    }

    @Override
    public ChannelHeader headerIn() {
        return OK;
    }

    @Override
    public void testMessage(long now) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long lastTestMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DocumentContext readingDocument() {
        return this.replyWire.readingDocument();
    }

    @Override
    @NotNull
    public <T> T methodWriter(@NotNull Class<T> tClass, Class ... additional) {
        return (T)this.mapService;
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        throw new UnsupportedOperationException();
    }
}

