/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.hash.ChronicleHashBuilder;
import net.openhft.chronicle.hash.ChronicleHashCorruption;
import net.openhft.chronicle.hash.ChronicleHashRecoveryFailedException;
import net.openhft.chronicle.hash.impl.ChronicleHashResources;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.InMemoryChronicleHashResources;
import net.openhft.chronicle.hash.impl.PersistedChronicleHashResources;
import net.openhft.chronicle.hash.impl.SizePrefixedBlob;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.util.CanonicalRandomAccessFiles;
import net.openhft.chronicle.hash.impl.util.FileIOUtils;
import net.openhft.chronicle.hash.impl.util.Objects;
import net.openhft.chronicle.hash.impl.util.Throwables;
import net.openhft.chronicle.hash.impl.util.math.PoissonDistribution;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.hash.serialization.impl.BytesMarshallableReaderWriter;
import net.openhft.chronicle.hash.serialization.impl.MarshallableReaderWriter;
import net.openhft.chronicle.hash.serialization.impl.SerializationBuilder;
import net.openhft.chronicle.hash.serialization.impl.TypedMarshallableReaderWriter;
import net.openhft.chronicle.map.ChronicleHashCorruptionImpl;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilderPrivateAPI;
import net.openhft.chronicle.map.DefaultSpi;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.MapEntryOperations;
import net.openhft.chronicle.map.MapMethods;
import net.openhft.chronicle.map.OldDeletedEntriesCleanupThread;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.internal.AnalyticsHolder;
import net.openhft.chronicle.map.replication.MapRemoteOperations;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.values.ValueModel;
import net.openhft.chronicle.values.Values;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.TextWire;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChronicleMapBuilder<K, V>
implements ChronicleHashBuilder<K, ChronicleMap<K, V>, ChronicleMapBuilder<K, V>> {
    private static final int UNDEFINED_ALIGNMENT_CONFIG = -1;
    private static final int NO_ALIGNMENT = 1;
    private static final int MAX_SEGMENTS = 0x40000000;
    private static final double UNDEFINED_DOUBLE_CONFIG = Double.NaN;
    private static final ConcurrentHashMap<File, Void> FILE_LOCKING_CONTROL = new ConcurrentHashMap(128);
    private static final ChronicleHashCorruption.Listener DEFAULT_CHRONICLE_MAP_CORRUPTION_LISTENER = corruption -> Jvm.error().on(ChronicleMapBuilder.class, corruption.message(), corruption.exception());
    private static final int MAX_BOOTSTRAPPING_HEADER_SIZE = (int)MemoryUnit.KILOBYTES.toBytes(16L);
    private static final boolean MAP_CREATION_DEBUG = Jvm.getBoolean("chronicle.map.creation.debug");
    SerializationBuilder<K> keyBuilder;
    SerializationBuilder<V> valueBuilder;
    K averageKey;
    V averageValue;
    long cleanupTimeout = 1L;
    TimeUnit cleanupTimeoutUnit = TimeUnit.MINUTES;
    boolean cleanupRemovedEntries = true;
    DefaultValueProvider<K, V> defaultValueProvider = DefaultSpi.defaultValueProvider();
    byte replicationIdentifier = (byte)-1;
    MapMethods<K, V, ?> methods = DefaultSpi.mapMethods();
    MapEntryOperations<K, V, ?> entryOperations = DefaultSpi.mapEntryOperations();
    MapRemoteOperations<K, V, ?> remoteOperations = DefaultSpi.mapRemoteOperations();
    Runnable preShutdownAction;
    boolean skipCloseOnExitHook = false;
    private String name;
    @UsedViaReflection
    private ChronicleMapBuilderPrivateAPI<K, V> privateAPI = new ChronicleMapBuilderPrivateAPI(this);
    private int minSegments = -1;
    private int actualSegments = -1;
    private long entriesPerSegment = -1L;
    private long actualChunksPerSegmentTier = -1L;
    private double averageKeySize = Double.NaN;
    private K sampleKey;
    private double averageValueSize = Double.NaN;
    private V sampleValue;
    private int actualChunkSize = 0;
    private int worstAlignment = -1;
    private int maxChunksPerEntry = -1;
    private int alignment = -1;
    private long entries = -1L;
    private double maxBloatFactor = 1.0;
    private boolean allowSegmentTiering = true;
    private double nonTieredSegmentsPercentile = 0.99999;
    private boolean aligned64BitMemoryOperationsAtomic = OS.is64Bit();
    private ChecksumEntries checksumEntries = ChecksumEntries.IF_PERSISTED;
    private boolean putReturnsNull = false;
    private boolean removeReturnsNull = false;
    private boolean replicated;
    private boolean persisted;
    private String replicatedMapClassName = ReplicatedChronicleMap.class.getName();
    private boolean sparseFile = Jvm.getBoolean("chronicle.map.sparseFile");

    ChronicleMapBuilder(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        this.keyBuilder = new SerializationBuilder<K>(keyClass);
        this.valueBuilder = new SerializationBuilder<V>(valueClass);
    }

    public static <K, V> ChronicleMapBuilder<K, V> of(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        return new ChronicleMapBuilder<K, V>(keyClass, valueClass);
    }

    public static <K, V> ChronicleMapBuilder<K, V> simpleMapOf(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        ChronicleMapBuilder<K, V> builder = new ChronicleMapBuilder<K, V>(keyClass, valueClass).putReturnsNull(true).removeReturnsNull(true);
        builder.name(ChronicleMapBuilder.toCamelCase(valueClass.getSimpleName()));
        if (!super.isKeySizeKnown()) {
            builder.averageKeySize(128.0);
        }
        if (!super.isValueSizeKnown()) {
            builder.averageValueSize(512.0);
        }
        if (BytesMarshallable.class.isAssignableFrom(valueClass)) {
            builder.valueMarshaller((BytesReader<V> & BytesWriter<? super V>)new BytesMarshallableReaderWriter<V>(valueClass));
        } else if (Marshallable.class.isAssignableFrom(valueClass)) {
            builder.averageValueSize(1024.0).valueMarshaller(valueClass.isMemberClass() && Modifier.isFinal(valueClass.getModifiers()) ? new MarshallableReaderWriter<V>(valueClass) : new TypedMarshallableReaderWriter<V>(valueClass));
        }
        return builder;
    }

    private static String toCamelCase(@NotNull String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private static void checkSegments(long segments) {
        if (segments <= 0L) {
            throw new IllegalArgumentException("segments should be positive, " + segments + " given");
        }
        if (segments > 0x40000000L) {
            throw new IllegalArgumentException("Max segments is 1073741824, " + segments + " given");
        }
    }

    private static String pretty(int value) {
        return value > 0 ? value + "" : "not configured";
    }

    private static String pretty(Object obj) {
        return obj != null ? obj + "" : "not configured";
    }

    private static void checkSizeIsStaticallyKnown(@NotNull SerializationBuilder builder, @NotNull String role) {
        if (builder.sizeIsStaticallyKnown) {
            throw new IllegalStateException("Size of " + builder.tClass + " instances is constant and statically known, shouldn't be specified via average" + role + "Size() or average" + role + "() methods");
        }
    }

    private static void checkAverageSize(double averageSize, @NotNull String role) {
        if (averageSize <= 0.0 || Double.isNaN(averageSize) || Double.isInfinite(averageSize)) {
            throw new IllegalArgumentException("Average " + role + " size must be a positive, finite number");
        }
    }

    private static double averageSizeStoringLength(@NotNull SerializationBuilder builder, double averageSize) {
        int upperStoringLength;
        SizeMarshaller sizeMarshaller = builder.sizeMarshaller();
        if (averageSize == (double)Math.round(averageSize)) {
            return sizeMarshaller.storingLength(Math.round(averageSize));
        }
        long lower = ChronicleMapBuilder.roundDown(averageSize);
        long upper = lower + 1L;
        int lowerStoringLength = sizeMarshaller.storingLength(lower);
        if (lowerStoringLength == (upperStoringLength = sizeMarshaller.storingLength(upper))) {
            return lowerStoringLength;
        }
        return (double)lower * ((double)upper - averageSize) + (double)upper * (averageSize - (double)lower);
    }

    static int greatestCommonDivisor(int a, int b) {
        if (b == 0) {
            return a;
        }
        return ChronicleMapBuilder.greatestCommonDivisor(b, a % b);
    }

    private static int maxDefaultChunksPerAverageEntry(boolean replicated, int avgEntrySize) {
        if (avgEntrySize >= 8192) {
            return replicated ? 32 : 64;
        }
        if (avgEntrySize >= 2048) {
            return replicated ? 16 : 32;
        }
        if (avgEntrySize >= 512) {
            return replicated ? 8 : 16;
        }
        return replicated ? 4 : 8;
    }

    private static int estimateSegmentsForEntries(long size) {
        if (size >= 0x10000000L) {
            return 256;
        }
        if (size >= 0x2000000L) {
            return 128;
        }
        if (size >= 0x400000L) {
            return 64;
        }
        if (size >= 524288L) {
            return 32;
        }
        if (size >= 65536L) {
            return 16;
        }
        if (size >= 8192L) {
            return 8;
        }
        if (size >= 1024L) {
            return 4;
        }
        return 1;
    }

    private static long headerChecksum(@NotNull ByteBuffer headerBuffer, int headerSize) {
        return LongHashFunction.xx_r39().hashBytes(headerBuffer, 8, headerSize + 4);
    }

    private static void writeNotComplete(@NotNull FileChannel fileChannel, @NotNull ByteBuffer headerBuffer, int headerSize) throws IOException {
        headerBuffer.putInt(8, Integer.MIN_VALUE | headerSize);
        headerBuffer.clear().position(8).limit(12);
        FileIOUtils.writeFully(fileChannel, 8L, headerBuffer);
    }

    private static <K, V> ByteBuffer writeHeader(@NotNull FileChannel fileChannel, @NotNull VanillaChronicleMap<K, V, ?> map) throws IOException {
        ByteBuffer headerBuffer = ByteBuffer.allocate(12 + MAX_BOOTSTRAPPING_HEADER_SIZE);
        headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Bytes<ByteBuffer> headerBytes = Bytes.wrapForWrite(headerBuffer);
        headerBytes.writePosition(12L);
        TextWire wire = new TextWire(headerBytes);
        wire.getValueOut().typedMarshallable(map);
        int headerLimit = (int)headerBytes.writePosition();
        int headerSize = headerLimit - 12;
        headerBuffer.putInt(8, 0 | headerSize);
        long checksum = ChronicleMapBuilder.headerChecksum(headerBuffer, headerSize);
        headerBuffer.putLong(0, checksum);
        headerBuffer.putInt(8, Integer.MIN_VALUE | headerSize);
        headerBuffer.position(0);
        headerBuffer.limit(headerLimit);
        FileIOUtils.writeFully(fileChannel, 0L, headerBuffer);
        headerBuffer.position(12);
        return headerBuffer;
    }

    private static void commitChronicleMapReady(@NotNull VanillaChronicleHash map, @NotNull RandomAccessFile raf, @NotNull ByteBuffer headerBuffer, int headerSize) throws IOException {
        FileChannel fileChannel = raf.getChannel();
        map.msync();
        headerBuffer.putInt(8, 0 | headerSize);
        headerBuffer.clear().position(8).limit(12);
        FileIOUtils.writeFully(fileChannel, 8L, headerBuffer);
    }

    private static ByteBuffer readSelfBootstrappingHeader(@NotNull File file, @NotNull RandomAccessFile raf, int headerSize, boolean recover, @Nullable ChronicleHashCorruption.Listener corruptionListener, @Nullable ChronicleHashCorruptionImpl corruption) throws IOException {
        if (raf.length() < (long)(headerSize + 12)) {
            throw VanillaChronicleHash.throwRecoveryOrReturnIOException(file, "The file is shorter than the header size: " + headerSize + ", file size: " + raf.length(), recover);
        }
        FileChannel fileChannel = raf.getChannel();
        ByteBuffer headerBuffer = ByteBuffer.allocate(12 + headerSize);
        headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
        FileIOUtils.readFully(fileChannel, 0L, headerBuffer);
        if (headerBuffer.remaining() > 0) {
            throw VanillaChronicleHash.throwRecoveryOrReturnIOException(file, "Unable to read the header fully, " + headerBuffer.remaining() + " is remaining to read, likely the file was truncated", recover);
        }
        int sizeWord = headerBuffer.getInt(8);
        if (!SizePrefixedBlob.isReady(sizeWord)) {
            if (recover) {
                ChronicleHashCorruptionImpl.report(corruptionListener, corruption, -1, () -> ChronicleHashCorruptionImpl.format("file={}: size-prefixed blob readiness bit is set to NOT_COMPLETE", file));
            } else {
                throw new IOException("file=" + file + ": sizeWord is not ready: " + sizeWord);
            }
        }
        headerBuffer.position(12);
        return headerBuffer;
    }

    private static boolean checkSumSelfBootstrappingHeader(@NotNull ByteBuffer headerBuffer, int headerSize) {
        long checkSum = ChronicleMapBuilder.headerChecksum(headerBuffer, headerSize);
        long storedChecksum = headerBuffer.getLong(0);
        return storedChecksum == checkSum;
    }

    private static boolean isDefined(double config) {
        return !Double.isNaN(config);
    }

    private static long toLong(double v) {
        long l = Math.round(v);
        if ((double)l != v) {
            throw new IllegalArgumentException("Integer argument expected, given " + v);
        }
        return l;
    }

    private static long roundUp(double v) {
        return Math.round(Math.ceil(v));
    }

    private static long roundDown(double v) {
        return (long)v;
    }

    private boolean isKeySizeKnown() {
        return this.keyBuilder.sizeIsStaticallyKnown;
    }

    private boolean isValueSizeKnown() {
        return this.valueBuilder.sizeIsStaticallyKnown;
    }

    @Override
    public ChronicleMapBuilder<K, V> clone() {
        try {
            ChronicleMapBuilder result = (ChronicleMapBuilder)super.clone();
            result.keyBuilder = this.keyBuilder.clone();
            result.valueBuilder = this.valueBuilder.clone();
            result.privateAPI = new ChronicleMapBuilderPrivateAPI(result);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ChronicleMapBuilder<K, V> name(@NotNull String name) {
        this.name = name;
        return this;
    }

    String name() {
        return this.name;
    }

    @Override
    public ChronicleMapBuilder<K, V> averageKeySize(double averageKeySize) {
        ChronicleMapBuilder.checkSizeIsStaticallyKnown(this.keyBuilder, "Key");
        ChronicleMapBuilder.checkAverageSize(averageKeySize, "key");
        this.averageKeySize = averageKeySize;
        this.averageKey = null;
        this.sampleKey = null;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> averageKey(@NotNull K averageKey) {
        ChronicleMapBuilder.checkSizeIsStaticallyKnown(this.keyBuilder, "Key");
        this.averageKey = averageKey;
        this.sampleKey = null;
        this.averageKeySize = Double.NaN;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> constantKeySizeBySample(@NotNull K sampleKey) {
        this.sampleKey = sampleKey;
        this.averageKey = null;
        this.averageKeySize = Double.NaN;
        return this;
    }

    private double averageKeySize() {
        if (!ChronicleMapBuilder.isDefined(this.averageKeySize)) {
            throw new AssertionError();
        }
        return this.averageKeySize;
    }

    public ChronicleMapBuilder<K, V> averageValueSize(double averageValueSize) {
        ChronicleMapBuilder.checkSizeIsStaticallyKnown(this.valueBuilder, "Value");
        ChronicleMapBuilder.checkAverageSize(averageValueSize, "value");
        this.averageValueSize = averageValueSize;
        this.averageValue = null;
        this.sampleValue = null;
        return this;
    }

    public ChronicleMapBuilder<K, V> averageValue(@NotNull V averageValue) {
        Class<?> valueClass = averageValue.getClass();
        if (BytesMarshallable.class.isAssignableFrom(valueClass) && this.valueBuilder.tClass.isInterface() && this.valueBuilder.tClass != Marshallable.class) {
            if (Serializable.class.isAssignableFrom(valueClass)) {
                Jvm.warn().on(this.getClass(), "BytesMarshallable " + valueClass + " will be serialized as Serializable as the value class is an interface");
            } else {
                throw new IllegalArgumentException("Using BytesMarshallable and an interface value type not supported");
            }
        }
        ChronicleMapBuilder.checkSizeIsStaticallyKnown(this.valueBuilder, "Value");
        this.averageValue = averageValue;
        this.sampleValue = null;
        this.averageValueSize = Double.NaN;
        return this;
    }

    public ChronicleMapBuilder<K, V> constantValueSizeBySample(@NotNull V sampleValue) {
        this.sampleValue = sampleValue;
        this.averageValue = null;
        this.averageValueSize = Double.NaN;
        return this;
    }

    double averageValueSize() {
        if (!ChronicleMapBuilder.isDefined(this.averageValueSize)) {
            throw new AssertionError();
        }
        return this.averageValueSize;
    }

    private <E> double averageKeyOrValueSize(double configuredSize, @NotNull SerializationBuilder<E> builder, E average) {
        if (ChronicleMapBuilder.isDefined(configuredSize)) {
            return configuredSize;
        }
        if (builder.constantSizeMarshaller()) {
            return builder.constantSize();
        }
        if (average != null) {
            return builder.serializationSize(average);
        }
        return Double.NaN;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualChunkSize(int actualChunkSize) {
        if (this.constantlySizedEntries()) {
            throw new IllegalStateException("Sizes of key type: " + this.keyBuilder.tClass + " and value type: " + this.valueBuilder.tClass + " are both constant, so chunk size shouldn't be specified manually");
        }
        if (actualChunkSize <= 0) {
            throw new IllegalArgumentException("Chunk size must be positive");
        }
        if (this.alignment > 0 && actualChunkSize % this.alignment != 0) {
            throw new IllegalArgumentException("The chunk size (" + actualChunkSize + ") must be a multiple of the alignment (" + this.alignment + ")");
        }
        this.actualChunkSize = actualChunkSize;
        return this;
    }

    SerializationBuilder<K> keyBuilder() {
        return this.keyBuilder;
    }

    private EntrySizeInfo entrySizeInfo() {
        int worstAlignment;
        double size = 0.0;
        double keySize = this.averageKeySize();
        size += ChronicleMapBuilder.averageSizeStoringLength(this.keyBuilder, keySize);
        size += keySize;
        if (this.replicated) {
            size += 10.0;
        }
        if (this.checksumEntries()) {
            size += 4.0;
        }
        double valueSize = this.averageValueSize();
        size += ChronicleMapBuilder.averageSizeStoringLength(this.valueBuilder, valueSize);
        int alignment = this.valueAlignment();
        size = VanillaChronicleMap.alignAddr((long)Math.ceil(size), alignment);
        if (this.worstAlignmentComputationRequiresValueSize(alignment)) {
            long constantSizeBeforeAlignment = ChronicleMapBuilder.toLong(size);
            if (this.constantlySizedValues()) {
                long totalDataSize = constantSizeBeforeAlignment + this.constantValueSize();
                worstAlignment = (int)(VanillaChronicleMap.alignAddr(totalDataSize, alignment) - totalDataSize);
            } else if (this.actualChunkSize > 0) {
                worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, this.actualChunkSize);
            } else {
                int chunkSize = 8;
                worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, chunkSize);
                if (!(size + (double)worstAlignment + valueSize >= (double)(ChronicleMapBuilder.maxDefaultChunksPerAverageEntry(this.replicated, (int)size) * chunkSize))) {
                    chunkSize = 4;
                    worstAlignment = this.worstAlignmentAssumingChunkSize(constantSizeBeforeAlignment, chunkSize);
                }
            }
        } else {
            worstAlignment = this.worstAlignmentWithoutValueSize(alignment);
        }
        size += (double)worstAlignment;
        return new EntrySizeInfo(size += valueSize, worstAlignment);
    }

    private boolean worstAlignmentComputationRequiresValueSize(int alignment) {
        return alignment != 1 && this.constantlySizedKeys() && this.valueBuilder.constantStoringLengthSizeMarshaller();
    }

    private int worstAlignmentWithoutValueSize(int alignment) {
        return alignment - 1;
    }

    int segmentEntrySpaceInnerOffset() {
        if (!this.constantlySizedEntries()) {
            return 0;
        }
        return (int)(this.constantValueSize() % (long)this.valueAlignment());
    }

    private long constantValueSize() {
        return this.valueBuilder.constantSize();
    }

    public boolean constantlySizedKeys() {
        return this.keyBuilder.constantSizeMarshaller() || this.sampleKey != null;
    }

    private int worstAlignmentAssumingChunkSize(long constantSizeBeforeAlignment, int chunkSize) {
        int alignment = this.valueAlignment();
        long firstAlignment = VanillaChronicleMap.alignAddr(constantSizeBeforeAlignment, alignment) - constantSizeBeforeAlignment;
        int gcdOfAlignmentAndChunkSize = ChronicleMapBuilder.greatestCommonDivisor(alignment, chunkSize);
        if (gcdOfAlignmentAndChunkSize == alignment) {
            return (int)firstAlignment;
        }
        long worstAlignment = firstAlignment;
        while (worstAlignment + (long)gcdOfAlignmentAndChunkSize < (long)alignment) {
            worstAlignment += (long)gcdOfAlignmentAndChunkSize;
        }
        return (int)worstAlignment;
    }

    int worstAlignment() {
        if (this.worstAlignment >= 0) {
            return this.worstAlignment;
        }
        int alignment = this.valueAlignment();
        if (!this.worstAlignmentComputationRequiresValueSize(alignment)) {
            this.worstAlignment = this.worstAlignmentWithoutValueSize(alignment);
            return this.worstAlignment;
        }
        this.worstAlignment = this.entrySizeInfo().worstAlignment;
        return this.worstAlignment;
    }

    void worstAlignment(int worstAlignment) {
        assert (worstAlignment >= 0);
        this.worstAlignment = worstAlignment;
    }

    long chunkSize() {
        if (this.actualChunkSize > 0) {
            return this.actualChunkSize;
        }
        double averageEntrySize = this.entrySizeInfo().averageEntrySize;
        if (this.constantlySizedEntries()) {
            return ChronicleMapBuilder.toLong(averageEntrySize);
        }
        int maxChunkSize = 0x40000000;
        int chunkSize = 4;
        while (chunkSize <= 0x40000000) {
            if ((double)((long)ChronicleMapBuilder.maxDefaultChunksPerAverageEntry(this.replicated, (int)averageEntrySize) * (long)chunkSize) > averageEntrySize) {
                return chunkSize;
            }
            chunkSize = (int)((long)chunkSize * 2L);
        }
        return 0x40000000L;
    }

    boolean constantlySizedEntries() {
        return this.constantlySizedKeys() && this.constantlySizedValues();
    }

    double averageChunksPerEntry() {
        if (this.constantlySizedEntries()) {
            return 1.0;
        }
        long chunkSize = this.chunkSize();
        return (this.entrySizeInfo().averageEntrySize + (double)chunkSize - 1.0) / (double)chunkSize;
    }

    @Override
    public ChronicleMapBuilder<K, V> maxChunksPerEntry(int maxChunksPerEntry) {
        if (maxChunksPerEntry < 1) {
            throw new IllegalArgumentException("maxChunksPerEntry should be >= 1, " + maxChunksPerEntry + " given");
        }
        if (this.constantlySizedEntries()) {
            throw new IllegalStateException("Sizes of key type: " + this.keyBuilder.tClass + " and value type: " + this.valueBuilder.tClass + " are both constant, so maxChunksPerEntry shouldn't be specified manually");
        }
        this.maxChunksPerEntry = maxChunksPerEntry;
        return this;
    }

    int maxChunksPerEntry() {
        if (this.constantlySizedEntries()) {
            return 1;
        }
        long actualChunksPerSegmentTier = this.actualChunksPerSegmentTier();
        int result = (int)Math.min(actualChunksPerSegmentTier, Integer.MAX_VALUE);
        if (this.maxChunksPerEntry > 0) {
            result = Math.min(this.maxChunksPerEntry, result);
        }
        return result;
    }

    public boolean constantlySizedValues() {
        return this.valueBuilder.constantSizeMarshaller() || this.sampleValue != null;
    }

    public ChronicleMapBuilder<K, V> entryAndValueOffsetAlignment(int alignment) {
        if (alignment <= 0) {
            throw new IllegalArgumentException("Alignment should be positive integer, " + alignment + " given");
        }
        if (!Maths.isPowerOf2(alignment)) {
            throw new IllegalArgumentException("Alignment should be a power of 2, " + alignment + " given");
        }
        if (Jvm.isArm() && alignment < 8) {
            return this;
        }
        this.validateAlignment(this.actualChunkSize, this.actualChunkSize, alignment);
        this.alignment = alignment;
        return this;
    }

    public void validateAlignment(int ifSet, int actualChunkSize, int alignment) {
        if (ifSet > 0 && actualChunkSize % alignment != 0) {
            throw new IllegalArgumentException("The chunk size (" + actualChunkSize + ") must be a multiple of the alignment (" + alignment + ")");
        }
    }

    int valueAlignment() {
        if (this.alignment != -1) {
            return this.alignment;
        }
        try {
            if (Values.isValueInterfaceOrImplClass(this.valueBuilder.tClass)) {
                int alignment = ValueModel.acquire(this.valueBuilder.tClass).recommendedOffsetAlignment();
                this.validateAlignment(alignment, this.actualChunkSize, alignment);
                return alignment;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public ChronicleMapBuilder<K, V> entries(long entries) {
        if (entries <= 0L) {
            throw new IllegalArgumentException("Entries should be positive, " + entries + " given");
        }
        this.entries = entries;
        return this;
    }

    long entries() {
        if (this.entries < 0L) {
            throw new IllegalStateException("If in-memory Chronicle Map is created or persisted\nto a file for the first time (i. e. not accessing an existing file),\nChronicleMapBuilder.entries() must be configured.\nSee Chronicle Map 3 tutorial and javadocs for more information");
        }
        return this.entries;
    }

    @Override
    public ChronicleMapBuilder<K, V> entriesPerSegment(long entriesPerSegment) {
        if (entriesPerSegment <= 0L) {
            throw new IllegalArgumentException("Entries per segment should be positive, " + entriesPerSegment + " given");
        }
        this.entriesPerSegment = entriesPerSegment;
        return this;
    }

    long entriesPerSegment() {
        double averageChunksPerEntry;
        boolean actualChunksDefined;
        long entriesPerSegment;
        if (this.entriesPerSegment > 0L) {
            entriesPerSegment = this.entriesPerSegment;
        } else {
            int actualSegments = this.actualSegments();
            double averageEntriesPerSegment = (double)this.entries() * 1.0 / (double)actualSegments;
            entriesPerSegment = actualSegments > 1 ? PoissonDistribution.inverseCumulativeProbability(averageEntriesPerSegment, this.nonTieredSegmentsPercentile) : ChronicleMapBuilder.roundUp(averageEntriesPerSegment);
            if (this.sparseFile && this.maxBloatFactor > 1.0) {
                double averageEntriesPerSegment2 = (double)this.entries() * this.maxBloatFactor / (double)actualSegments;
                entriesPerSegment = Math.max(ChronicleMapBuilder.roundUp(averageEntriesPerSegment2), entriesPerSegment);
            }
        }
        boolean bl = actualChunksDefined = this.actualChunksPerSegmentTier > 0L;
        if (!actualChunksDefined && (double)entriesPerSegment * (averageChunksPerEntry = this.averageChunksPerEntry()) > 1.073741824E9) {
            throw new IllegalStateException("Max chunks per segment tier is 1073741824 configured entries() and actualSegments() so that there should be " + entriesPerSegment + " entries per segment tier, while average chunks per entry is " + averageChunksPerEntry);
        }
        if (entriesPerSegment > 0x20000000L) {
            throw new IllegalStateException("shouldn't be more than 536870912 entries per segment");
        }
        return entriesPerSegment;
    }

    @Override
    public ChronicleMapBuilder<K, V> actualChunksPerSegmentTier(long actualChunksPerSegmentTier) {
        if (actualChunksPerSegmentTier <= 0L || actualChunksPerSegmentTier > 0x40000000L) {
            throw new IllegalArgumentException("Actual chunks per segment tier should be in [1, 1073741824], range, " + actualChunksPerSegmentTier + " given");
        }
        this.actualChunksPerSegmentTier = actualChunksPerSegmentTier;
        return this;
    }

    private void checkActualChunksPerSegmentTierIsConfiguredOnlyIfOtherLowLevelConfigsAreManual() {
        if (this.actualChunksPerSegmentTier > 0L && (this.entriesPerSegment <= 0L || this.actualChunkSize <= 0 && !this.constantlySizedEntries() || this.actualSegments <= 0)) {
            throw new IllegalStateException("Actual chunks per segment tier could be configured only if other three low level configs are manual: entriesPerSegment(), actualSegments() and actualChunkSize(), unless both keys and value sizes are constant");
        }
    }

    private void checkActualChunksPerSegmentGreaterOrEqualToEntries() {
        if (this.actualChunksPerSegmentTier > 0L && this.entriesPerSegment > 0L && this.entriesPerSegment > this.actualChunksPerSegmentTier) {
            throw new IllegalStateException("Entries per segment couldn't be greater than actual chunks per segment tier. Entries: " + this.entriesPerSegment + ", chunks: " + this.actualChunksPerSegmentTier + " is configured");
        }
    }

    long actualChunksPerSegmentTier() {
        if (this.actualChunksPerSegmentTier > 0L) {
            return this.actualChunksPerSegmentTier;
        }
        return this.chunksPerSegmentTier(this.entriesPerSegment());
    }

    private long chunksPerSegmentTier(long entriesPerSegment) {
        return ChronicleMapBuilder.roundUp((double)entriesPerSegment * this.averageChunksPerEntry());
    }

    @Override
    public ChronicleMapBuilder<K, V> minSegments(int minSegments) {
        ChronicleMapBuilder.checkSegments(minSegments);
        this.minSegments = minSegments;
        return this;
    }

    int minSegments() {
        return Math.max(this.estimateSegments(), this.minSegments);
    }

    private int estimateSegments() {
        return (int)Math.min(Maths.nextPower2(this.entries() / 32L, 1L), (long)this.estimateSegmentsBasedOnSize());
    }

    private int estimateSegmentsBasedOnSize() {
        int segmentsForEntries = ChronicleMapBuilder.estimateSegmentsForEntries(this.entries());
        double averageValueSize = this.averageValueSize();
        return averageValueSize >= 1000000.0 ? segmentsForEntries * 16 : (averageValueSize >= 100000.0 ? segmentsForEntries * 8 : (averageValueSize >= 10000.0 ? segmentsForEntries * 4 : (averageValueSize >= 1000.0 ? segmentsForEntries * 2 : segmentsForEntries)));
    }

    @Override
    public ChronicleMapBuilder<K, V> actualSegments(int actualSegments) {
        ChronicleMapBuilder.checkSegments(actualSegments);
        this.actualSegments = actualSegments;
        return this;
    }

    int actualSegments() {
        if (this.actualSegments > 0) {
            return this.actualSegments;
        }
        if (this.entriesPerSegment > 0L) {
            return (int)this.segmentsGivenEntriesPerSegmentFixed(this.entriesPerSegment);
        }
        long segments = this.tryHashLookupSlotSize(4);
        if (segments > 0L) {
            return (int)segments;
        }
        int maxHashLookupEntrySize = this.aligned64BitMemoryOperationsAtomic() ? 8 : 4;
        long maxEntriesPerSegment = this.findMaxEntriesPerSegmentToFitHashLookupSlotSize(maxHashLookupEntrySize);
        long maxSegments = this.trySegments(maxEntriesPerSegment, 0x40000000);
        if (maxSegments > 0L) {
            return (int)maxSegments;
        }
        throw new IllegalStateException("Max segments is 1073741824, configured so much entries (" + this.entries() + ") or average chunks per entry is too high (" + this.averageChunksPerEntry() + ") that builder automatically decided to use " + -maxSegments + " segments");
    }

    private long tryHashLookupSlotSize(int hashLookupSlotSize) {
        long entriesPerSegment = this.findMaxEntriesPerSegmentToFitHashLookupSlotSize(hashLookupSlotSize);
        long entrySpaceSize = ChronicleMapBuilder.roundUp((double)entriesPerSegment * this.entrySizeInfo().averageEntrySize);
        if (entrySpaceSize < (long)OS.pageSize() * 5L) {
            return -1L;
        }
        return this.trySegments(entriesPerSegment, 0x40000000);
    }

    private long findMaxEntriesPerSegmentToFitHashLookupSlotSize(int targetHashLookupSlotSize) {
        long entriesPerSegment = 0x4000000000000000L;
        for (long step = entriesPerSegment / 2L; step > 0L; step /= 2L) {
            if (this.hashLookupSlotBytes(entriesPerSegment) <= targetHashLookupSlotSize) continue;
            entriesPerSegment -= step;
        }
        return entriesPerSegment - 1L;
    }

    private int hashLookupSlotBytes(long entriesPerSegment) {
        int valueBits = CompactOffHeapLinearHashTable.valueBits(this.chunksPerSegmentTier(entriesPerSegment));
        int keyBits = CompactOffHeapLinearHashTable.keyBits(entriesPerSegment, valueBits);
        return CompactOffHeapLinearHashTable.entrySize(keyBits, valueBits);
    }

    private long trySegments(long entriesPerSegment, int maxSegments) {
        long segments = this.segmentsGivenEntriesPerSegmentFixed(entriesPerSegment);
        return (segments = Maths.nextPower2(Math.max(segments, (long)this.minSegments()), 1L)) <= (long)maxSegments ? segments : -segments;
    }

    private long segmentsGivenEntriesPerSegmentFixed(long entriesPerSegment) {
        double precision = 1.0 / this.averageChunksPerEntry();
        long entriesPerSegmentShouldBe = ChronicleMapBuilder.roundDown(PoissonDistribution.meanByCumulativeProbabilityAndValue(this.nonTieredSegmentsPercentile, entriesPerSegment, precision));
        long segments = Maths.divideRoundUp(this.entries(), entriesPerSegmentShouldBe);
        ChronicleMapBuilder.checkSegments(segments);
        if (this.minSegments > 0) {
            segments = Math.max((long)this.minSegments, segments);
        }
        return segments;
    }

    long tierHashLookupCapacity() {
        long entriesPerSegment = this.entriesPerSegment();
        long capacity = CompactOffHeapLinearHashTable.capacityFor(entriesPerSegment);
        if (this.actualSegments() > 1) {
            long maxEntriesPerTier = PoissonDistribution.inverseCumulativeProbability(entriesPerSegment, this.nonTieredSegmentsPercentile);
            while ((double)maxEntriesPerTier > 0.8 * (double)capacity) {
                capacity *= 2L;
            }
        }
        return capacity;
    }

    int segmentHeaderSize() {
        long pageSize;
        int segments = this.actualSegments();
        if ((long)(segments * 192) < 2L * (pageSize = (long)OS.pageSize())) {
            return 192;
        }
        if ((long)(segments * 128) < 3L * pageSize) {
            return 128;
        }
        return segments <= 16384 ? 64 : 32;
    }

    public ChronicleMapBuilder<K, V> putReturnsNull(boolean putReturnsNull) {
        this.putReturnsNull = putReturnsNull;
        return this;
    }

    boolean putReturnsNull() {
        return this.putReturnsNull;
    }

    public ChronicleMapBuilder<K, V> removeReturnsNull(boolean removeReturnsNull) {
        this.removeReturnsNull = removeReturnsNull;
        return this;
    }

    boolean removeReturnsNull() {
        return this.removeReturnsNull;
    }

    @Override
    public ChronicleMapBuilder<K, V> maxBloatFactor(double maxBloatFactor) {
        if (Double.isNaN(maxBloatFactor) || maxBloatFactor < 1.0 || maxBloatFactor > 1000.0) {
            throw new IllegalArgumentException("maxBloatFactor should be in [1.0, 1_000.0] bounds, " + maxBloatFactor + " given");
        }
        this.maxBloatFactor = maxBloatFactor;
        return this;
    }

    public double maxBloatFactor() {
        return this.maxBloatFactor;
    }

    @Override
    public ChronicleMapBuilder<K, V> allowSegmentTiering(boolean allowSegmentTiering) {
        this.allowSegmentTiering = allowSegmentTiering;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> nonTieredSegmentsPercentile(double nonTieredSegmentsPercentile) {
        if (Double.isNaN(nonTieredSegmentsPercentile) || 0.5 <= nonTieredSegmentsPercentile || nonTieredSegmentsPercentile >= 1.0) {
            throw new IllegalArgumentException("nonTieredSegmentsPercentile should be in (0.5, 1.0) range, " + nonTieredSegmentsPercentile + " is given");
        }
        this.nonTieredSegmentsPercentile = nonTieredSegmentsPercentile;
        return this;
    }

    long maxExtraTiers() {
        if (!this.allowSegmentTiering) {
            return 0L;
        }
        int actualSegments = this.actualSegments();
        return Math.round((this.maxBloatFactor - 1.0) * (double)actualSegments) + (long)actualSegments;
    }

    public String toString() {
        return "ChronicleMapBuilder{, actualSegments=" + ChronicleMapBuilder.pretty(this.actualSegments) + ", minSegments=" + ChronicleMapBuilder.pretty(this.minSegments) + ", entriesPerSegment=" + ChronicleMapBuilder.pretty(this.entriesPerSegment) + ", actualChunksPerSegmentTier=" + ChronicleMapBuilder.pretty(this.actualChunksPerSegmentTier) + ", averageKeySize=" + ChronicleMapBuilder.pretty(this.averageKeySize) + ", sampleKeyForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleKey) + ", averageValueSize=" + ChronicleMapBuilder.pretty(this.averageValueSize) + ", sampleValueForConstantSizeComputation=" + ChronicleMapBuilder.pretty(this.sampleValue) + ", actualChunkSize=" + ChronicleMapBuilder.pretty(this.actualChunkSize) + ", valueAlignment=" + this.valueAlignment() + ", entries=" + this.entries() + ", putReturnsNull=" + this.putReturnsNull() + ", removeReturnsNull=" + this.removeReturnsNull() + ", sparseFile=" + this.sparseFile() + ", keyBuilder=" + this.keyBuilder + ", valueBuilder=" + this.valueBuilder + '}';
    }

    public boolean equals(Object o) {
        return Objects.builderEquals(this, o);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    ChronicleMapBuilder<K, V> removedEntryCleanupTimeout(long removedEntryCleanupTimeout, @NotNull TimeUnit unit) {
        if (unit.toMillis(removedEntryCleanupTimeout) < 1L) {
            throw new IllegalArgumentException("timeout should be >= 1 millisecond, " + removedEntryCleanupTimeout + " " + (Object)((Object)unit) + " is given");
        }
        this.cleanupTimeout = removedEntryCleanupTimeout;
        this.cleanupTimeoutUnit = unit;
        return this;
    }

    ChronicleMapBuilder<K, V> cleanupRemovedEntries(boolean cleanupRemovedEntries) {
        this.cleanupRemovedEntries = cleanupRemovedEntries;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyReaderAndDataAccess(SizedReader<K> keyReader, @NotNull DataAccess<K> keyDataAccess) {
        this.keyBuilder.reader(keyReader);
        this.keyBuilder.dataAccess(keyDataAccess);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshallers(@NotNull SizedReader<K> keyReader, @NotNull SizedWriter<? super K> keyWriter) {
        this.keyBuilder.reader(keyReader);
        this.keyBuilder.writer(keyWriter);
        return this;
    }

    @Override
    public <M extends SizedReader<K> & SizedWriter<? super K>> ChronicleMapBuilder<K, V> keyMarshaller(@NotNull M sizedMarshaller) {
        return this.keyMarshallers((SizedReader)sizedMarshaller, (SizedWriter)sizedMarshaller);
    }

    @Override
    public ChronicleMapBuilder<K, V> keyMarshallers(@NotNull BytesReader<K> keyReader, @NotNull BytesWriter<? super K> keyWriter) {
        this.keyBuilder.reader(keyReader);
        this.keyBuilder.writer(keyWriter);
        return this;
    }

    @Override
    public <M extends BytesReader<K> & BytesWriter<? super K>> ChronicleMapBuilder<K, V> keyMarshaller(@NotNull M marshaller) {
        return this.keyMarshallers((BytesReader)marshaller, (BytesWriter)marshaller);
    }

    @Override
    public ChronicleMapBuilder<K, V> keySizeMarshaller(@NotNull SizeMarshaller keySizeMarshaller) {
        this.keyBuilder.sizeMarshaller(keySizeMarshaller);
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> aligned64BitMemoryOperationsAtomic(boolean aligned64BitMemoryOperationsAtomic) {
        this.aligned64BitMemoryOperationsAtomic = aligned64BitMemoryOperationsAtomic;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> checksumEntries(boolean checksumEntries) {
        this.checksumEntries = checksumEntries ? ChecksumEntries.YES : ChecksumEntries.NO;
        return this;
    }

    boolean checksumEntries() {
        switch (this.checksumEntries) {
            case NO: {
                return false;
            }
            case YES: {
                return true;
            }
            case IF_PERSISTED: {
                return this.persisted;
            }
        }
        throw new AssertionError();
    }

    boolean aligned64BitMemoryOperationsAtomic() {
        return this.aligned64BitMemoryOperationsAtomic;
    }

    public ChronicleMapBuilder<K, V> valueReaderAndDataAccess(@NotNull SizedReader<V> valueReader, @NotNull DataAccess<V> valueDataAccess) {
        this.valueBuilder.reader(valueReader);
        this.valueBuilder.dataAccess(valueDataAccess);
        return this;
    }

    public ChronicleMapBuilder<K, V> valueMarshallers(@NotNull SizedReader<V> valueReader, @NotNull SizedWriter<? super V> valueWriter) {
        this.valueBuilder.reader(valueReader);
        this.valueBuilder.writer(valueWriter);
        return this;
    }

    public <M extends SizedReader<V> & SizedWriter<? super V>> ChronicleMapBuilder<K, V> valueMarshaller(@NotNull M sizedMarshaller) {
        return this.valueMarshallers(sizedMarshaller, sizedMarshaller);
    }

    public ChronicleMapBuilder<K, V> valueMarshallers(@NotNull BytesReader<V> valueReader, @NotNull BytesWriter<? super V> valueWriter) {
        this.valueBuilder.reader(valueReader);
        this.valueBuilder.writer(valueWriter);
        return this;
    }

    public <M extends BytesReader<V> & BytesWriter<? super V>> ChronicleMapBuilder<K, V> valueMarshaller(@NotNull M marshaller) {
        return this.valueMarshallers(marshaller, marshaller);
    }

    public ChronicleMapBuilder<K, V> valueSizeMarshaller(@NotNull SizeMarshaller valueSizeMarshaller) {
        this.valueBuilder.sizeMarshaller(valueSizeMarshaller);
        return this;
    }

    public ChronicleMapBuilder<K, V> defaultValueProvider(@NotNull DefaultValueProvider<K, V> defaultValueProvider) {
        this.defaultValueProvider = defaultValueProvider;
        return this;
    }

    public ChronicleMapBuilder<K, V> replication(byte identifier) {
        if (identifier <= 0) {
            throw new IllegalArgumentException("Identifier must be positive, " + identifier + " given");
        }
        this.replicationIdentifier = identifier;
        return this;
    }

    public ChronicleMapBuilder<K, V> replicatedMapClassName(String replicatedMapClassName) {
        this.replicatedMapClassName = replicatedMapClassName;
        return this;
    }

    public ChronicleMapBuilder<K, V> sparseFile(boolean sparseFile) {
        this.sparseFile = sparseFile;
        return this;
    }

    public boolean sparseFile() {
        return this.sparseFile;
    }

    @Override
    public ChronicleMap<K, V> createPersistedTo(@NotNull File file) throws IOException {
        return super.createWithFile(file, false, false, null);
    }

    @Override
    public ChronicleMap<K, V> createOrRecoverPersistedTo(@NotNull File file) throws IOException {
        return this.createOrRecoverPersistedTo(file, true);
    }

    @Override
    public ChronicleMap<K, V> createOrRecoverPersistedTo(@NotNull File file, boolean sameLibraryVersion) throws IOException {
        return this.createOrRecoverPersistedTo(file, sameLibraryVersion, DEFAULT_CHRONICLE_MAP_CORRUPTION_LISTENER);
    }

    @Override
    public ChronicleMap<K, V> createOrRecoverPersistedTo(@NotNull File file, boolean sameLibraryVersion, @Nullable ChronicleHashCorruption.Listener corruptionListener) throws IOException {
        if (file.exists()) {
            return this.recoverPersistedTo(file, sameLibraryVersion, corruptionListener);
        }
        return this.createPersistedTo(file);
    }

    @Override
    public ChronicleMap<K, V> recoverPersistedTo(@NotNull File file, boolean sameBuilderConfigAndLibraryVersion) throws IOException {
        return this.recoverPersistedTo(file, sameBuilderConfigAndLibraryVersion, DEFAULT_CHRONICLE_MAP_CORRUPTION_LISTENER);
    }

    @Override
    public ChronicleMap<K, V> recoverPersistedTo(@NotNull File file, boolean sameBuilderConfigAndLibraryVersion, @Nullable ChronicleHashCorruption.Listener corruptionListener) throws IOException {
        AnalyticsHolder.instance().sendEvent("recover");
        return super.createWithFile(file, true, sameBuilderConfigAndLibraryVersion, corruptionListener);
    }

    @Override
    public ChronicleMapBuilder<K, V> setPreShutdownAction(@NotNull Runnable preShutdownAction) {
        this.preShutdownAction = preShutdownAction;
        return this;
    }

    @Override
    public ChronicleMapBuilder<K, V> skipCloseOnExitHook(boolean skipCloseOnExitHook) {
        this.skipCloseOnExitHook = skipCloseOnExitHook;
        return this;
    }

    @Override
    public ChronicleMap<K, V> create() {
        return super.createWithoutFile();
    }

    public ChronicleMapBuilder<K, V> entryOperations(@NotNull MapEntryOperations<K, V, ?> entryOperations) {
        this.entryOperations = entryOperations;
        return this;
    }

    public ChronicleMapBuilder<K, V> mapMethods(@NotNull MapMethods<K, V, ?> mapMethods) {
        this.methods = mapMethods;
        return this;
    }

    ChronicleMapBuilder<K, V> remoteOperations(@NotNull MapRemoteOperations<K, V, ?> remoteOperations) {
        this.remoteOperations = remoteOperations;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChronicleMap<K, V> createWithFile(@NotNull File file, boolean recover, boolean overrideBuilderConfig, @Nullable ChronicleHashCorruption.Listener corruptionListener) throws IOException {
        if (overrideBuilderConfig && !recover) {
            throw new AssertionError((Object)"recover -> overrideBuilderConfig");
        }
        this.replicated = this.replicationIdentifier != -1;
        this.persisted = true;
        File canonicalFile = file.getCanonicalFile();
        if (!canonicalFile.exists()) {
            if (recover) {
                throw new FileNotFoundException("file " + canonicalFile + " should exist for recovery");
            }
            canonicalFile.createNewFile();
        }
        RandomAccessFile raf = CanonicalRandomAccessFiles.acquire(canonicalFile);
        PersistedChronicleHashResources resources = new PersistedChronicleHashResources(canonicalFile);
        try {
            VanillaChronicleMap<K, V, ?> result;
            if (raf.length() > 0L) {
                result = this.openWithExistingFile(canonicalFile, raf, resources, recover, overrideBuilderConfig, corruptionListener);
            } else {
                boolean locked;
                AtomicReference map = new AtomicReference();
                AtomicReference headerBuffer = new AtomicReference();
                AtomicBoolean newFile = new AtomicBoolean(false);
                FileChannel fileChannel = raf.getChannel();
                TimingPauser pauser = Pauser.balanced();
                while (raf.length() == 0L && !(locked = CanonicalRandomAccessFiles.tryRunExclusively(canonicalFile, fileChannel, () -> {
                    if (raf.length() == 0L) {
                        map.set(this.newMap());
                        headerBuffer.set(ChronicleMapBuilder.writeHeader(fileChannel, (VanillaChronicleMap)map.get()));
                        newFile.set(true);
                    }
                }))) {
                    try {
                        pauser.pause(10L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException e) {
                        Jvm.warn().on(this.getClass(), "Failed to write header: can't acquire exclusive file lock on empty file [" + canonicalFile + "] for 10 seconds", e);
                        Jvm.rethrow(e);
                    }
                }
                if (newFile.get()) {
                    int headerSize = ((ByteBuffer)headerBuffer.get()).remaining();
                    result = this.createWithNewFile((VanillaChronicleMap)map.get(), canonicalFile, raf, resources, (ByteBuffer)headerBuffer.get(), headerSize);
                } else {
                    result = this.openWithExistingFile(canonicalFile, raf, resources, recover, overrideBuilderConfig, corruptionListener);
                }
            }
            this.prepareMapPublication(result);
            return result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    resources.setChronicleHashIdentityString("ChronicleHash{name=" + this.name + ", file=" + canonicalFile + "}");
                }
                catch (Throwable t) {
                    throwable.addSuppressed(t);
                }
                finally {
                    resources.releaseManually();
                }
            }
            catch (Throwable t) {
                throwable.addSuppressed(t);
            }
            throw Throwables.propagateNotWrapping(throwable, IOException.class);
        }
    }

    private void prepareMapPublication(@NotNull VanillaChronicleMap<K, V, ?> map) throws IOException {
        this.establishReplication(map);
        map.setResourcesName();
        map.registerCleaner();
        OS.memory().storeFence();
        map.addToOnExitHook();
    }

    private int waitUntilReady(@NotNull RandomAccessFile raf, @NotNull File file, boolean recover) throws IOException {
        FileChannel fileChannel = raf.getChannel();
        ByteBuffer sizeWordBuffer = ByteBuffer.allocate(4);
        sizeWordBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int attempts = 600;
        int lastReadHeaderSize = -1;
        for (int attempt = 0; attempt < 600; ++attempt) {
            if (raf.length() >= 12L) {
                sizeWordBuffer.clear();
                FileIOUtils.readFully(fileChannel, 8L, sizeWordBuffer);
                if (sizeWordBuffer.remaining() == 0) {
                    int sizeWord = sizeWordBuffer.getInt(0);
                    lastReadHeaderSize = SizePrefixedBlob.extractSize(sizeWord);
                    if (SizePrefixedBlob.isReady(sizeWord)) {
                        return lastReadHeaderSize;
                    }
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (recover) {
                    if (lastReadHeaderSize == -1) {
                        throw new ChronicleHashRecoveryFailedException(e);
                    }
                    return lastReadHeaderSize;
                }
                throw new IOException(e);
            }
        }
        if (recover) {
            if (lastReadHeaderSize == -1) {
                throw new ChronicleHashRecoveryFailedException("File header is not recoverable, file=" + file);
            }
            return lastReadHeaderSize;
        }
        throw new IOException("Unable to wait until the file=" + file + " is ready, likely the process which created the file crashed or hung for more than 1 minute");
    }

    private VanillaChronicleMap<K, V, ?> createWithNewFile(@NotNull VanillaChronicleMap<K, V, ?> map, @NotNull File canonicalFile, @NotNull RandomAccessFile raf, @NotNull ChronicleHashResources resources, @NotNull ByteBuffer headerBuffer, int headerSize) throws IOException {
        if (MAP_CREATION_DEBUG) {
            Jvm.warn().on(this.getClass(), "<map creation debug> File [canonizedMapDataFile=" + canonicalFile.getAbsolutePath() + "] is missing or empty, creating Map from scratch");
        }
        map.initBeforeMapping(canonicalFile, raf, headerBuffer.limit(), false);
        map.createMappedStoreAndSegments(resources);
        CanonicalRandomAccessFiles.acquireSharedFileLock(canonicalFile, raf.getChannel());
        map.addCloseable(() -> CanonicalRandomAccessFiles.releaseSharedFileLock(canonicalFile));
        ChronicleMapBuilder.commitChronicleMapReady(map, raf, headerBuffer, headerSize);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VanillaChronicleMap<K, V, ?> openWithExistingFile(@NotNull File file, @NotNull RandomAccessFile raf, @NotNull ChronicleHashResources resources, boolean recover, boolean overrideBuilderConfig, @Nullable ChronicleHashCorruption.Listener corruptionListener) throws IOException {
        if (recover) {
            Jvm.warn().on(ChronicleMapBuilder.class, "Recovery operation needs exclusive access to the ChronicleMap or else the result is unspecified including the risk of loosing and/or corrupting partial or all data.");
            Jvm.warn().on(ChronicleMapBuilder.class, "Do not use recovery as a standard way of opening a ChronicleMap.");
        }
        ChronicleHashCorruptionImpl corruption = recover ? new ChronicleHashCorruptionImpl() : null;
        try {
            int headerSize = this.waitUntilReady(raf, file, recover);
            FileChannel fileChannel = raf.getChannel();
            ByteBuffer headerBuffer = ChronicleMapBuilder.readSelfBootstrappingHeader(file, raf, headerSize, recover, corruptionListener, corruption);
            if (headerSize != headerBuffer.remaining()) {
                throw new AssertionError();
            }
            boolean headerCorrect = ChronicleMapBuilder.checkSumSelfBootstrappingHeader(headerBuffer, headerSize);
            if (MAP_CREATION_DEBUG) {
                Jvm.warn().on(this.getClass(), "<map creation debug> Using existing file [canonizedMapDataFile=" + file.getAbsolutePath() + ", size=" + raf.length() + ", headerCorrect=" + headerCorrect + "] for map creation");
            }
            boolean headerWritten = false;
            if (!headerCorrect) {
                if (overrideBuilderConfig) {
                    VanillaChronicleMap<K, V, ?> mapObjectForHeaderOverwrite = this.newMap();
                    headerBuffer = ChronicleMapBuilder.writeHeader(fileChannel, mapObjectForHeaderOverwrite);
                    headerSize = headerBuffer.remaining();
                    headerWritten = true;
                } else {
                    throw VanillaChronicleHash.throwRecoveryOrReturnIOException(file, "Self Bootstrapping Header checksum doesn't match the stored checksum", recover);
                }
            }
            Bytes<ByteBuffer> headerBytes = Bytes.wrapForRead(headerBuffer);
            headerBytes.readPosition(headerBuffer.position());
            headerBytes.readLimit(headerBuffer.limit());
            TextWire wire = new TextWire(headerBytes);
            if (MAP_CREATION_DEBUG) {
                Jvm.warn().on(this.getClass(), "<map creation debug> Read header from file [canonizedMapDataFile=" + file.getAbsolutePath() + "]: " + wire);
            }
            VanillaChronicleMap map = (VanillaChronicleMap)wire.getValueIn().typedMarshallable();
            map.initBeforeMapping(file, raf, headerBuffer.limit(), recover);
            long dataStoreSize = map.globalMutableState().getDataStoreSize();
            long fileLength = raf.length();
            if (!recover && dataStoreSize > fileLength) {
                throw new IOException("The file " + file + " the map is serialized from has unexpected length " + fileLength + ", probably corrupted. Data store size is " + dataStoreSize);
            }
            map.initTransientsFromBuilder(this);
            if (!recover) {
                map.createMappedStoreAndSegments(resources);
                CanonicalRandomAccessFiles.acquireSharedFileLock(file, raf.getChannel());
            } else {
                if (!headerWritten) {
                    ChronicleMapBuilder.writeNotComplete(fileChannel, headerBuffer, headerSize);
                }
                try {
                    CanonicalRandomAccessFiles.acquireExclusiveFileLock(file, raf.getChannel());
                    map.recover(resources, corruptionListener, corruption);
                }
                finally {
                    CanonicalRandomAccessFiles.releaseExclusiveFileLock(file);
                }
                CanonicalRandomAccessFiles.acquireSharedFileLock(file, fileChannel);
                ChronicleMapBuilder.commitChronicleMapReady(map, raf, headerBuffer, headerSize);
            }
            map.addCloseable(() -> CanonicalRandomAccessFiles.releaseSharedFileLock(file));
            if (MAP_CREATION_DEBUG) {
                Jvm.warn().on(this.getClass(), "<map creation debug> Created map [name=" + map.name() + ", size=" + map.longSize() + "] from file [canonizedMapDataFile=" + file.getAbsolutePath() + "]");
            }
            return map;
        }
        catch (Throwable t) {
            if (recover && !(t instanceof IOException) && !(t instanceof ChronicleHashRecoveryFailedException)) {
                throw new ChronicleHashRecoveryFailedException(t);
            }
            throw Throwables.propagateNotWrapping(t, IOException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChronicleMap<K, V> createWithoutFile() {
        this.replicated = this.replicationIdentifier != -1;
        this.persisted = false;
        InMemoryChronicleHashResources resources = new InMemoryChronicleHashResources();
        try {
            VanillaChronicleMap<K, V, ?> map = this.newMap();
            map.createInMemoryStoreAndSegments(resources);
            this.prepareMapPublication(map);
            return map;
        }
        catch (Throwable throwable) {
            try {
                try {
                    resources.setChronicleHashIdentityString("ChronicleHash{name=" + this.name + ", file=null}");
                }
                catch (Throwable t) {
                    throwable.addSuppressed(t);
                }
                finally {
                    resources.releaseManually();
                }
            }
            catch (Throwable t) {
                throwable.addSuppressed(t);
            }
            throw Throwables.propagate(throwable);
        }
    }

    private VanillaChronicleMap<K, V, ?> newMap() throws IOException {
        this.preMapConstruction();
        if (this.replicated) {
            try {
                return (VanillaChronicleMap)Class.forName(this.replicatedMapClassName).getDeclaredConstructor(this.getClass()).newInstance(this);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot load specified implementation class: " + this.replicatedMapClassName, e);
            }
        }
        return new VanillaChronicleMap(this);
    }

    private void preMapConstruction() {
        this.averageKeySize = this.preMapConstruction(this.keyBuilder, this.averageKeySize, this.averageKey, this.sampleKey, "Key");
        this.averageValueSize = this.preMapConstruction(this.valueBuilder, this.averageValueSize, this.averageValue, this.sampleValue, "Value");
        if (this.sparseFile) {
            this.averageKeySize *= 2.0;
            this.averageValueSize *= 2.0;
        }
        this.stateChecks();
    }

    private <E> double preMapConstruction(@NotNull SerializationBuilder<E> builder, double configuredAverageSize, @Nullable E average, @Nullable E sample, @NotNull String dim) {
        if (sample != null) {
            return builder.constantSizeBySample(sample);
        }
        double result = this.averageKeyOrValueSize(configuredAverageSize, builder, average);
        if (!Double.isNaN(result) || this.allLowLevelConfigurationsAreManual()) {
            return result;
        }
        throw new IllegalStateException(dim + " size in serialized form must be configured in ChronicleMap, at least approximately.\nUse builder.average" + dim + "()/.constant" + dim + "SizeBySample()/.average" + dim + "Size() methods to configure the size");
    }

    private void stateChecks() {
        this.checkActualChunksPerSegmentTierIsConfiguredOnlyIfOtherLowLevelConfigsAreManual();
        this.checkActualChunksPerSegmentGreaterOrEqualToEntries();
    }

    private boolean allLowLevelConfigurationsAreManual() {
        return this.actualSegments > 0 && this.entriesPerSegment > 0L && this.actualChunksPerSegmentTier > 0L && this.actualChunkSize > 0;
    }

    private void establishReplication(VanillaChronicleMap<K, V, ?> map) {
        if (map instanceof ReplicatedChronicleMap) {
            ReplicatedChronicleMap result = (ReplicatedChronicleMap)map;
            if (this.cleanupRemovedEntries) {
                this.establishCleanupThread(result);
            }
        }
    }

    private void establishCleanupThread(@NotNull ReplicatedChronicleMap map) {
        OldDeletedEntriesCleanupThread cleanupThread = new OldDeletedEntriesCleanupThread(map);
        map.addCloseable(cleanupThread);
        cleanupThread.start();
    }

    private static final class EntrySizeInfo {
        private final double averageEntrySize;
        private final int worstAlignment;

        EntrySizeInfo(double averageEntrySize, int worstAlignment) {
            this.averageEntrySize = averageEntrySize;
            this.worstAlignment = worstAlignment;
        }
    }

    private static enum ChecksumEntries {
        YES,
        NO,
        IF_PERSISTED;

    }
}

