/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LongDataAccess
extends AbstractData<Long>
implements DataAccess<Long>,
Data<Long> {
    private transient boolean bsInit;
    private transient BytesStore bs;
    private transient Long instance;

    public LongDataAccess() {
        this.initTransients();
    }

    private void initTransients() {
        this.bs = BytesStore.wrap(new byte[8]);
    }

    @Override
    public RandomDataInput bytes() {
        if (!this.bsInit) {
            this.bs.writeLong(0L, this.instance);
            this.bsInit = true;
        }
        return this.bs;
    }

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long size() {
        return 8L;
    }

    @Override
    public Long get() {
        return this.instance;
    }

    @Override
    public Long getUsing(@Nullable Long using) {
        return this.instance;
    }

    @Override
    public long hash(LongHashFunction f) {
        return f.hashLong(this.instance);
    }

    @Override
    public boolean equivalent(RandomDataInput source, long sourceOffset) {
        return source.readLong(sourceOffset) == this.instance.longValue();
    }

    @Override
    public void writeTo(RandomDataOutput target, long targetOffset) {
        target.writeLong(targetOffset, this.instance);
    }

    @Override
    public Data<Long> getData(@NotNull Long instance) {
        this.instance = instance;
        this.bsInit = false;
        return this;
    }

    @Override
    public void uninit() {
        this.instance = null;
    }

    @Override
    public void readMarshallable(@NotNull WireIn wireIn) {
        this.initTransients();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
    }

    @Override
    public DataAccess<Long> copy() {
        return new LongDataAccess();
    }
}

