/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.hash.serialization.impl.CachingCreatingMarshaller;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytesMarshallableReaderWriter<V extends BytesMarshallable>
extends CachingCreatingMarshaller<V> {
    private static final ThreadLocal<VanillaBytes> VANILLA_BYTES_TL = ThreadLocal.withInitial(VanillaBytes::vanillaBytes);

    public BytesMarshallableReaderWriter(Class<V> vClass) {
        super(vClass);
    }

    @Override
    @NotNull
    public V read(Bytes in, long size, @Nullable V using) {
        if (using == null) {
            using = (BytesMarshallable)this.createInstance();
        }
        VanillaBytes vanillaBytes = VANILLA_BYTES_TL.get();
        vanillaBytes.bytesStore(in.bytesStore(), in.readPosition(), size);
        using.readMarshallable(vanillaBytes);
        return (V)using;
    }

    @Override
    protected void writeToWire(Wire wire, @NotNull V toWrite) {
        toWrite.writeMarshallable(wire.bytes());
    }
}

