/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.impl.EnumMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteBufferSizedReader
implements SizedReader<ByteBuffer>,
EnumMarshallable<ByteBufferSizedReader> {
    public static final ByteBufferSizedReader INSTANCE = new ByteBufferSizedReader();

    private ByteBufferSizedReader() {
    }

    @Override
    @NotNull
    public ByteBuffer read(@NotNull Bytes in, long size, @Nullable ByteBuffer using) {
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("ByteBuffer size should be non-negative int, " + size + " given. Memory corruption?");
        }
        int bufferCap = (int)size;
        if (using == null || using.capacity() < bufferCap) {
            using = ByteBuffer.allocate(bufferCap);
        } else {
            using.position(0);
            using.limit(bufferCap);
        }
        in.read(using);
        using.flip();
        return using;
    }

    @Override
    @NotNull
    public ByteBufferSizedReader readResolve() {
        return INSTANCE;
    }
}

