/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ByteBufferDataAccess
extends AbstractData<ByteBuffer>
implements DataAccess<ByteBuffer> {
    private transient BytesStore nativeBytesStore;
    private transient VanillaBytes<Void> bytes;
    private transient ByteBuffer bb;
    private transient BytesStore bytesStore;

    public ByteBufferDataAccess() {
        this.initTransients();
    }

    private void initTransients() {
        this.nativeBytesStore = BytesStore.nativeStore(0L);
        this.bytes = VanillaBytes.vanillaBytes();
    }

    @Override
    public RandomDataInput bytes() {
        return this.bytesStore;
    }

    @Override
    public long offset() {
        return this.bb.position();
    }

    @Override
    public long size() {
        return this.bb.remaining();
    }

    @Override
    public ByteBuffer get() {
        return this.bb;
    }

    @Override
    public ByteBuffer getUsing(@Nullable ByteBuffer using) {
        if (using == null || using.capacity() < this.bb.remaining()) {
            using = ByteBuffer.allocate(this.bb.remaining());
        } else {
            using.position(0);
            using.limit(this.bb.remaining());
        }
        this.bytes.bytesStore(this.bytesStore, (long)this.bb.position(), (long)this.bb.remaining());
        this.bytes.read(using);
        using.flip();
        return using;
    }

    @Override
    public Data<ByteBuffer> getData(@NotNull ByteBuffer instance) {
        this.bb = instance;
        if (instance.isDirect()) {
            ((NativeBytesStore)this.nativeBytesStore).init(instance, false);
            this.bytesStore = this.nativeBytesStore;
        } else {
            this.bytesStore = BytesStore.wrap(instance);
        }
        return this;
    }

    @Override
    public void uninit() {
        this.bb = null;
        if (this.bytesStore == this.nativeBytesStore) {
            ((NativeBytesStore)this.nativeBytesStore).uninit();
        }
    }

    @Override
    public DataAccess<ByteBuffer> copy() {
        return new ByteBufferDataAccess();
    }

    @Override
    public void readMarshallable(@NotNull WireIn wireIn) {
        this.initTransients();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
    }
}

