/*
 * Decompiled with CFR 0.152.
 */
package run.smt.ktest.util.resource;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0006\u001a\n\u0010\t\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0006\u001a6\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r\"\b\b\u0001\u0010\u000e*\u00020\u000f*\u0002H\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\r0\u0011H\u0086\b\u00a2\u0006\u0002\u0010\u0012\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0013"}, d2={"classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "load", "Ljava/io/InputStream;", "", "loadAsBytes", "", "loadAsString", "resourceExists", "", "use", "R", "C", "Ljava/lang/AutoCloseable;", "action", "Lkotlin/Function1;", "(Ljava/lang/AutoCloseable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "ktest-util"})
public final class ResourceKt {
    private static final ClassLoader getClassLoader() {
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        ClassLoader classLoader = thread.getContextClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"Thread.currentThread().contextClassLoader");
        return classLoader;
    }

    @NotNull
    public static final InputStream load(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream inputStream = ResourceKt.getClassLoader().getResourceAsStream($receiver);
        if (inputStream == null) {
            throw (Throwable)new NoSuchFileException("No file found at resource path \"" + $receiver + '\"');
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] loadAsBytes(@NotNull String $receiver) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        AutoCloseable $receiver$iv = ResourceKt.load($receiver);
        try {
            InputStream it = (InputStream)$receiver$iv;
            byArray = ByteStreamsKt.readBytes$default((InputStream)it, (int)0, (int)1, null);
        }
        finally {
            try {
                $receiver$iv.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    @NotNull
    public static final String loadAsString(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = ResourceKt.loadAsBytes($receiver);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    public static final boolean resourceExists(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ResourceKt.getClassLoader().getResource($receiver) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <R, C extends AutoCloseable> R use(@NotNull C $receiver, @NotNull Function1<? super C, ? extends R> action) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        try {
            Object object = action.invoke($receiver);
            return (R)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            try {
                $receiver.close();
            }
            catch (Exception exception) {}
            InlineMarker.finallyEnd((int)1);
        }
    }
}

