/*
 * Decompiled with CFR 0.152.
 */
package run.smt.ktest.util.eventually;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import run.smt.ktest.util.duration.MillisBase;
import run.smt.ktest.util.duration.NanosBase;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003\u00a2\u0006\u0002\u0010\tJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J(\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00100\u0012H\u0086\u0004\u00a2\u0006\u0002\u0010\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003H\u0086\u0004J\"\u0010\u0017\u001a\u00020\u00002\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00030\u0012\u00a2\u0006\u0002\b\u001cH\u0086\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lrun/smt/ktest/util/eventually/Eventually;", "", "awaitMillis", "", "delayMillis", "(ILjava/lang/Integer;)V", "Ljava/lang/Integer;", "component1", "component2", "()Ljava/lang/Integer;", "copy", "(ILjava/lang/Integer;)Lrun/smt/ktest/util/eventually/Eventually;", "equals", "", "other", "execute", "T", "f", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "hashCode", "toString", "", "withDelay", "duration", "Ljava/time/Duration;", "time", "Lrun/smt/ktest/util/duration/MillisBase;", "Lkotlin/ExtensionFunctionType;", "ktest-util"})
public final class Eventually {
    private final int awaitMillis;
    private final Integer delayMillis;

    public final <T> T execute(@NotNull Function1<? super Integer, ? extends T> f) {
        AssertionError assertionError;
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        int times = 0;
        Throwable lastException = null;
        Integer n = this.delayMillis;
        if ((n != null ? n : -1) > this.awaitMillis) {
            throw (Throwable)new IllegalArgumentException("Setting delay more than total await time is non-sense!");
        }
        long end = System.currentTimeMillis() + (long)this.awaitMillis;
        while (System.currentTimeMillis() < end) {
            long l;
            Throwable throwable;
            try {
                return (T)f.invoke((Object)times);
            }
            catch (Exception e) {
                throwable = e;
            }
            catch (AssertionError e) {
                throwable = (Throwable)((Object)e);
            }
            lastException = throwable;
            ++times;
            Integer n2 = this.delayMillis;
            if (n2 == null) continue;
            long p1 = l = (long)n2.intValue();
            Thread.sleep(p1);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Test failed after ");
        AssertionError assertionError2 = assertionError;
        AssertionError assertionError3 = assertionError;
        NanosBase $receiver = NanosBase.INSTANCE;
        String string = $receiver.show($receiver.millis(this.awaitMillis));
        assertionError2((Object)stringBuilder.append(string).append("; attempted ").append(times).append(" times. ").append("Last attempt failed with: ").append(lastException).toString());
        throw (Throwable)((Object)assertionError3);
    }

    @NotNull
    public final Eventually withDelay(int delayMillis) {
        return Eventually.copy$default(this, 0, delayMillis, 1, null);
    }

    @NotNull
    public final Eventually withDelay(@NotNull Function1<? super MillisBase, Integer> time) {
        Intrinsics.checkParameterIsNotNull(time, (String)"time");
        Eventually eventually2 = this;
        Object object = time.invoke((Object)MillisBase.INSTANCE);
        return eventually2.withDelay(((Number)object).intValue());
    }

    @NotNull
    public final Eventually withDelay(@NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        return this.withDelay((int)duration.toMillis());
    }

    public Eventually(int awaitMillis, @Nullable Integer delayMillis) {
        this.awaitMillis = awaitMillis;
        this.delayMillis = delayMillis;
    }

    public /* synthetic */ Eventually(int n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        this(n, n2);
    }

    private final int component1() {
        return this.awaitMillis;
    }

    private final Integer component2() {
        return this.delayMillis;
    }

    @NotNull
    public final Eventually copy(int awaitMillis, @Nullable Integer delayMillis) {
        return new Eventually(awaitMillis, delayMillis);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Eventually copy$default(Eventually eventually2, int n, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = eventually2.awaitMillis;
        }
        if ((n3 & 2) != 0) {
            n2 = eventually2.delayMillis;
        }
        return eventually2.copy(n, n2);
    }

    public String toString() {
        return "Eventually(awaitMillis=" + this.awaitMillis + ", delayMillis=" + this.delayMillis + ")";
    }

    public int hashCode() {
        Integer n = this.delayMillis;
        return Integer.hashCode(this.awaitMillis) * 31 + (n != null ? ((Object)n).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Eventually)) break block3;
                Eventually eventually2 = (Eventually)object;
                if (!(this.awaitMillis == eventually2.awaitMillis) || !Intrinsics.areEqual((Object)this.delayMillis, (Object)eventually2.delayMillis)) break block3;
            }
            return true;
        }
        return false;
    }
}

