/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.rest;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.metadata.annotation.processing.builder.MethodDefinitionBuilder;
import org.apache.dubbo.metadata.annotation.processing.rest.AnnotatedMethodParameterProcessor;
import org.apache.dubbo.metadata.annotation.processing.rest.ServiceRestMetadataResolver;
import org.apache.dubbo.metadata.annotation.processing.util.ExecutableElementComparator;
import org.apache.dubbo.metadata.annotation.processing.util.LoggerUtils;
import org.apache.dubbo.metadata.annotation.processing.util.MethodUtils;
import org.apache.dubbo.metadata.annotation.processing.util.ServiceAnnotationUtils;
import org.apache.dubbo.metadata.definition.model.MethodDefinition;
import org.apache.dubbo.metadata.rest.RequestMetadata;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;

public abstract class AbstractServiceRestMetadataResolver
implements ServiceRestMetadataResolver {
    private static final ThreadLocal<Map<String, Object>> threadLocalCache = ThreadLocal.withInitial(HashMap::new);
    private static final Map<String, List<AnnotatedMethodParameterProcessor>> parameterProcessorsMap = AbstractServiceRestMetadataResolver.loadAnnotatedMethodParameterProcessors();
    private final String processorName = this.getClass().getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ServiceRestMetadata resolve(ProcessingEnvironment processingEnv, TypeElement serviceType, Set<? extends TypeElement> annotations) {
        LoggerUtils.info("%s is processing the service type[%s] with annotations[%s]", this.processorName, serviceType, annotations.stream().map(t -> "@" + t.toString()).collect(Collectors.joining(",")));
        ServiceRestMetadata serviceRestMetadata = new ServiceRestMetadata();
        Elements elements = processingEnv.getElementUtils();
        try {
            AnnotationMirror serviceAnnotation = ServiceAnnotationUtils.getAnnotation(serviceType);
            String serviceInterfaceName = ServiceAnnotationUtils.resolveServiceInterfaceName(serviceType, serviceAnnotation);
            serviceRestMetadata.setServiceInterface(serviceInterfaceName);
            serviceRestMetadata.setGroup(ServiceAnnotationUtils.getGroup(serviceAnnotation));
            serviceRestMetadata.setVersion(ServiceAnnotationUtils.getVersion(serviceAnnotation));
            TypeElement serviceInterfaceType = elements.getTypeElement(serviceInterfaceName);
            LinkedList<ExecutableElement> serviceMethods = new LinkedList<ExecutableElement>(MethodUtils.getPublicNonStaticMethods(serviceInterfaceType, new Type[]{Object.class}));
            Collections.sort(serviceMethods, ExecutableElementComparator.INSTANCE);
            serviceMethods.forEach(serviceMethod -> this.resolveRestMethodMetadata(processingEnv, serviceType, serviceInterfaceType, (ExecutableElement)serviceMethod).ifPresent(serviceRestMetadata.getMeta()::add));
        }
        finally {
            AbstractServiceRestMetadataResolver.clearCache();
        }
        LoggerUtils.info("The %s's process result : %s", this.processorName, serviceRestMetadata);
        return serviceRestMetadata;
    }

    protected Optional<RestMethodMetadata> resolveRestMethodMetadata(ProcessingEnvironment processingEnv, TypeElement serviceType, TypeElement serviceInterfaceType, ExecutableElement serviceMethod) {
        ExecutableElement restCapableMethod = this.findRestCapableMethod(processingEnv, serviceType, serviceInterfaceType, serviceMethod);
        if (restCapableMethod == null) {
            return Optional.empty();
        }
        String requestPath = this.resolveRequestPath(processingEnv, serviceType, restCapableMethod);
        if (requestPath == null) {
            return Optional.empty();
        }
        String requestMethod = this.resolveRequestMethod(processingEnv, serviceType, restCapableMethod);
        if (requestMethod == null) {
            return Optional.empty();
        }
        RestMethodMetadata metadata = new RestMethodMetadata();
        MethodDefinition methodDefinition = this.resolveMethodDefinition(processingEnv, serviceType, restCapableMethod);
        metadata.setMethod(methodDefinition);
        this.processAnnotatedMethodParameters(restCapableMethod, serviceType, metadata);
        LinkedHashSet<String> produces = new LinkedHashSet<String>();
        this.processProduces(processingEnv, serviceType, restCapableMethod, produces);
        LinkedHashSet<String> consumes = new LinkedHashSet<String>();
        this.processConsumes(processingEnv, serviceType, restCapableMethod, consumes);
        RequestMetadata request = metadata.getRequest();
        request.setPath(requestPath);
        request.setMethod(requestMethod);
        request.setProduces(produces);
        request.setConsumes(consumes);
        this.postProcessRestMethodMetadata(processingEnv, serviceType, serviceMethod, metadata);
        return Optional.of(metadata);
    }

    private ExecutableElement findRestCapableMethod(ProcessingEnvironment processingEnv, TypeElement serviceType, TypeElement serviceInterfaceType, ExecutableElement serviceMethod) {
        ExecutableElement overrideMethod = MethodUtils.getOverrideMethod(processingEnv, serviceType, serviceMethod);
        if (this.supports(processingEnv, serviceType, serviceInterfaceType, overrideMethod)) {
            return overrideMethod;
        }
        return this.supports(processingEnv, serviceType, serviceInterfaceType, serviceMethod) ? serviceMethod : null;
    }

    protected abstract boolean supports(ProcessingEnvironment var1, TypeElement var2, TypeElement var3, ExecutableElement var4);

    protected void postProcessRestMethodMetadata(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method, RestMethodMetadata metadata) {
    }

    protected abstract String resolveRequestPath(ProcessingEnvironment var1, TypeElement var2, ExecutableElement var3);

    protected abstract String resolveRequestMethod(ProcessingEnvironment var1, TypeElement var2, ExecutableElement var3);

    protected MethodDefinition resolveMethodDefinition(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method) {
        return MethodDefinitionBuilder.build(processingEnv, method);
    }

    protected void processAnnotatedMethodParameters(ExecutableElement method, TypeElement type, RestMethodMetadata metadata) {
        List<? extends VariableElement> methodParameters = method.getParameters();
        int size = methodParameters.size();
        for (int i = 0; i < size; ++i) {
            VariableElement parameter = methodParameters.get(i);
            metadata.addIndexToName(Integer.valueOf(i), parameter.getSimpleName().toString());
            this.processAnnotatedMethodParameter(parameter, i, method, type, metadata);
        }
    }

    protected void processAnnotatedMethodParameter(VariableElement parameter, int parameterIndex, ExecutableElement method, TypeElement serviceType, RestMethodMetadata metadata) {
        parameter.getAnnotationMirrors().forEach(annotation -> {
            String annotationType = annotation.getAnnotationType().toString();
            parameterProcessorsMap.getOrDefault(annotationType, Collections.emptyList()).forEach(parameterProcessor -> parameterProcessor.process((AnnotationMirror)annotation, parameter, parameterIndex, method, metadata));
        });
    }

    protected abstract void processProduces(ProcessingEnvironment var1, TypeElement var2, ExecutableElement var3, Set<String> var4);

    protected abstract void processConsumes(ProcessingEnvironment var1, TypeElement var2, ExecutableElement var3, Set<String> var4);

    protected static final void put(String name, Object value) {
        Map<String, Object> cache = AbstractServiceRestMetadataResolver.getCache();
        cache.put(name, value);
    }

    protected static final <T> T get(String name) throws ClassCastException {
        Map<String, Object> cache = AbstractServiceRestMetadataResolver.getCache();
        return (T)cache.get(name);
    }

    protected static final <V> V computeIfAbsent(String name, Function<? super String, ? extends V> mappingFunction) {
        return AbstractServiceRestMetadataResolver.getCache().computeIfAbsent(name, mappingFunction);
    }

    private static Map<String, List<AnnotatedMethodParameterProcessor>> loadAnnotatedMethodParameterProcessors() {
        LinkedHashMap<String, List<AnnotatedMethodParameterProcessor>> parameterProcessorsMap = new LinkedHashMap<String, List<AnnotatedMethodParameterProcessor>>();
        ExtensionLoader.getExtensionLoader(AnnotatedMethodParameterProcessor.class).getSupportedExtensionInstances().forEach(processor -> {
            List processors = parameterProcessorsMap.computeIfAbsent(processor.getAnnotationType(), k -> new LinkedList());
            processors.add(processor);
        });
        return parameterProcessorsMap;
    }

    private static Map<String, Object> getCache() {
        return threadLocalCache.get();
    }

    private static void clearCache() {
        Map<String, Object> cache = AbstractServiceRestMetadataResolver.getCache();
        cache.clear();
        threadLocalCache.remove();
    }
}

