/*
 *  Copyright 2020 Xiaomi
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package run.mone.mesh.dubbo.plugin;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import lombok.extern.slf4j.Slf4j;
import run.mone.sautumnn.springboot.starter.anno.Activate;

import java.lang.annotation.Annotation;
import java.util.List;

/**
 * @author goodjava@qq.com
 * 用来加载mesh 环境下 dubbo filter
 */
@DOceanPlugin(order = 0)
@Slf4j
public class MeshDubboPlugin implements IPlugin {


    @Override
    public List<Class<? extends Annotation>> filterAnnotations() {
        return Lists.newArrayList(Activate.class);
    }


}
