/*
 * Decompiled with CFR 0.152.
 */
package org.zlwl.wallet;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.http.HttpService;
import org.web3j.tx.RawTransactionManager;
import org.web3j.utils.Numeric;
import org.zlwl.util.DecimalTool;
import org.zlwl.wallet.EthTool;
import org.zlwl.wallet.entity.EthAccount;
import org.zlwl.wallet.util.MnemonicTool;

public class ERC20TokenTool {
    private static final String DATA_PREFIX = "0x70a08231000000000000000000000000";
    public static final String Ox00 = "0x0000000000000000000000000000000000000000";
    public static final String USDT_CONTRACT_MAINNET = "0xdac17f958d2ee523a2206206994597c13d831ec7";
    public static final String LINK_CONTRACT_RINKEBY = "0x01BE23585060835E02B77ef475b0Cc51aA1e0709";

    public static BigInteger totalSupply(String contract, Web3j web3j) throws ExecutionException, InterruptedException {
        String name = "totalSupply";
        List<1> outputParameters = List.of(new TypeReference<Uint256>(){});
        Function function = new Function(name, new ArrayList(), outputParameters);
        EthCall response = ERC20TokenTool.query(function, Ox00, contract, web3j);
        List results = FunctionReturnDecoder.decode((String)response.getValue(), (List)function.getOutputParameters());
        return (BigInteger)((Type)results.get(0)).getValue();
    }

    public static BigInteger decimals(String contract, Web3j web3j) throws ExecutionException, InterruptedException {
        String name = "decimals";
        List<2> outputParameters = List.of(new TypeReference<Uint256>(){});
        Function function = new Function(name, new ArrayList(), outputParameters);
        EthCall response = ERC20TokenTool.query(function, Ox00, contract, web3j);
        List results = FunctionReturnDecoder.decode((String)response.getValue(), (List)function.getOutputParameters());
        return (BigInteger)((Type)results.get(0)).getValue();
    }

    public static String name(String contract, Web3j web3j) throws ExecutionException, InterruptedException {
        String name = "name";
        List<3> outputParameters = List.of(new TypeReference<Utf8String>(){});
        Function function = new Function(name, new ArrayList(), outputParameters);
        EthCall response = ERC20TokenTool.query(function, Ox00, contract, web3j);
        List results = FunctionReturnDecoder.decode((String)response.getValue(), (List)function.getOutputParameters());
        return ((Type)results.get(0)).getValue().toString();
    }

    public static String symbol(String contract, Web3j web3j) throws ExecutionException, InterruptedException {
        String name = "symbol";
        List<4> outputParameters = List.of(new TypeReference<Utf8String>(){});
        Function function = new Function(name, new ArrayList(), outputParameters);
        EthCall response = ERC20TokenTool.query(function, Ox00, contract, web3j);
        List results = FunctionReturnDecoder.decode((String)response.getValue(), (List)function.getOutputParameters());
        return ((Type)results.get(0)).getValue().toString();
    }

    public static String balanceOf(String address, String contract, Web3j web3j) throws ExecutionException, InterruptedException {
        Function function = new Function("balanceOf", List.of(new Address(address)), List.of(new TypeReference<Address>(){}));
        EthCall response = ERC20TokenTool.query(function, address, contract, web3j);
        return ERC20TokenTool.hex2dec(response.getValue());
    }

    public static String legacyTransfer(String to, BigInteger amount, String contract, Credentials credentials, Web3j web3j) throws ExecutionException, InterruptedException, IOException {
        Function function = new Function("transfer", Arrays.asList(new Address(to), new Uint256(amount)), List.of(new TypeReference<Address>(){}));
        BigInteger nonce = EthTool.getNonce(credentials.getAddress(), web3j);
        BigInteger gasPrice = EthTool.getGesPrice(web3j);
        BigInteger gasLimit = BigInteger.valueOf(600000L);
        String encodedFunction = FunctionEncoder.encode((Function)function);
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)contract, (String)encodedFunction);
        byte[] signMessage = TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)credentials);
        String hexValue = Numeric.toHexString((byte[])signMessage);
        return ((EthSendTransaction)web3j.ethSendRawTransaction(hexValue).sendAsync().get()).getTransactionHash();
    }

    public static EthSendTransaction transfer(String to, BigInteger amount, String contract, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, Credentials credentials, Web3j web3j) throws ExecutionException, InterruptedException, IOException {
        Function function = new Function("transfer", Arrays.asList(new Address(to), new Uint256(amount)), List.of(new TypeReference<Address>(){}));
        BigInteger nonce = EthTool.getNonce(credentials.getAddress(), web3j);
        BigInteger gasPrice = EthTool.getGesPrice(web3j);
        BigInteger gasLimit = BigInteger.valueOf(600000L);
        long chainId = EthTool.getChainId(web3j);
        String rawData = FunctionEncoder.encode((Function)function);
        RawTransactionManager manager = new RawTransactionManager(web3j, credentials);
        EthSendTransaction transaction = manager.sendEIP1559Transaction(chainId, maxPriorityFeePerGas, maxFeePerGas, gasLimit, contract, rawData, amount);
        return transaction;
    }

    private static EthCall query(Function function, String address, String contract, Web3j web3j) throws InterruptedException, ExecutionException {
        String rawData = FunctionEncoder.encode((Function)function);
        return ERC20TokenTool.call(address, contract, rawData, web3j);
    }

    private static EthCall call(String address, String contract, String encode, Web3j web3j) throws InterruptedException, ExecutionException {
        Transaction transaction = Transaction.createEthCallTransaction((String)address, (String)contract, (String)encode);
        return (EthCall)web3j.ethCall(transaction, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).sendAsync().get();
    }

    public static EthCall balanceOf2(String address, String contract, Web3j web3j) throws IOException {
        Transaction transaction = Transaction.createEthCallTransaction((String)address, (String)contract, (String)ERC20TokenTool.prepareData(address));
        return (EthCall)web3j.ethCall(transaction, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
    }

    private static String prepareData(String address) {
        return DATA_PREFIX + address.substring(2);
    }

    private static String hex2dec(String value) {
        return new BigInteger(value.substring(2), 16).toString();
    }

    public static void main(String[] args) {
        String address = "0x4a7D597365982a941F00e11638994c17385122C9";
        String ox0 = Ox00;
        String mn = "first ceiling cupboard fresh wood situate dilemma primary october mobile family coast";
        String to = "0x3B3B43614C7E8e362A1f680d0696E054D9d850Db";
        Function function = new Function("totalSupply", new ArrayList(), new ArrayList());
        Web3j web3j = Web3j.build((Web3jService)new HttpService("https://rinkeby.infura.io/v3/62eee2c2ab8843fd96a5ff613ef3b9a5"));
        EthAccount ethAccount = MnemonicTool.loadEthDefaultWallet(mn);
        BigInteger amount = BigDecimal.valueOf(2L).multiply(DecimalTool.tenPow((Integer)18)).toBigInteger();
    }
}

