/*
 * Decompiled with CFR 0.152.
 */
package org.zlwl.wallet.util;

import com.google.common.collect.ImmutableList;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicHierarchy;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.HDKeyDerivation;
import org.bitcoinj.crypto.MnemonicCode;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.MnemonicUtils;
import org.zlwl.wallet.entity.EthAccount;

public class MnemonicTool {
    private static final ImmutableList<ChildNumber> BIP44_ETH_ACCOUNT_ZERO_PATH = ImmutableList.of((Object)new ChildNumber(44, true), (Object)new ChildNumber(60, true), (Object)ChildNumber.ZERO_HARDENED, (Object)ChildNumber.ZERO);

    public static String generateMnemonic() {
        byte[] initialEntropy = new byte[16];
        SecureRandom random = new SecureRandom();
        random.nextBytes(initialEntropy);
        return MnemonicUtils.generateMnemonic((byte[])initialEntropy);
    }

    public static byte[] toSeed(String mnemonic, String password) {
        List words = Arrays.stream(mnemonic.split(" ")).collect(Collectors.toList());
        return MnemonicCode.toSeed(words, (String)password);
    }

    public static EthAccount loadEthWalletByMnemonic(String mnemonic, String password, int index) {
        byte[] seed = MnemonicTool.toSeed(mnemonic, password);
        DeterministicKey masterPrivateKey = HDKeyDerivation.createMasterPrivateKey((byte[])seed);
        DeterministicHierarchy deterministicHierarchy = new DeterministicHierarchy(masterPrivateKey);
        DeterministicKey deterministicKey = deterministicHierarchy.deriveChild(BIP44_ETH_ACCOUNT_ZERO_PATH, false, true, new ChildNumber(index));
        return new EthAccount(ECKeyPair.create((byte[])deterministicKey.getPrivKeyBytes()));
    }

    public static EthAccount loadEthDefaultWallet(String mnemonic) {
        return MnemonicTool.loadEthWalletByMnemonic(mnemonic, "", 0);
    }

    public static void main(String[] args) {
        String mn = "first ceiling cupboard fresh wood situate dilemma primary october mobile family coast";
        String address = "0x4a7D597365982a941F00e11638994c17385122C9";
        String pk = "c3a74bb901a1c57ea13891040a6ab4d4955bc9b2996b84d1901e2d87e72e0223";
        EthAccount ethAccount = MnemonicTool.loadEthDefaultWallet(mn);
        System.out.println(ethAccount.getAddress());
        System.out.println(ethAccount.getPrivateKey());
        System.out.println(ethAccount.getPublicKey());
        System.out.println(ethAccount.get0xAddress().equals(address.toLowerCase()));
        System.out.println(ethAccount.getPrivateKey().equals(pk.toLowerCase()));
    }
}

