/*
 * Decompiled with CFR 0.152.
 */
package org.zlwl.wallet;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthChainId;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Transfer;
import org.web3j.utils.Convert;

public class EthTool {
    public static BigDecimal getEthBalance(String address, Web3j web3j) throws IOException {
        BigInteger balance = ((EthGetBalance)web3j.ethGetBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
        return Convert.fromWei((String)String.valueOf(balance), (Convert.Unit)Convert.Unit.ETHER);
    }

    public static TransactionReceipt legacyTransfer(Credentials credentials, String toAddress, BigDecimal amount, Web3j web3j) throws Exception {
        return (TransactionReceipt)Transfer.sendFunds((Web3j)web3j, (Credentials)credentials, (String)toAddress, (BigDecimal)amount, (Convert.Unit)Convert.Unit.ETHER).send();
    }

    public static TransactionReceipt transfer(Credentials credentials, String toAddress, BigDecimal amount, BigInteger gasLimit, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, Web3j web3j) throws Exception {
        return (TransactionReceipt)Transfer.sendFundsEIP1559((Web3j)web3j, (Credentials)credentials, (String)toAddress, (BigDecimal)amount, (Convert.Unit)Convert.Unit.ETHER, (BigInteger)gasLimit, (BigInteger)maxPriorityFeePerGas, (BigInteger)maxFeePerGas).send();
    }

    public static BigInteger getNonce(String address, Web3j web3j) throws IOException {
        EthGetTransactionCount ethGetTransactionCount = (EthGetTransactionCount)web3j.ethGetTransactionCount(address, (DefaultBlockParameter)DefaultBlockParameterName.PENDING).send();
        if (ethGetTransactionCount == null) {
            throw new RuntimeException("failed to get nonce!");
        }
        return ethGetTransactionCount.getTransactionCount();
    }

    public static BigInteger getGesPrice(Web3j web3j) throws ExecutionException, InterruptedException {
        EthGasPrice ethGasPrice = (EthGasPrice)web3j.ethGasPrice().sendAsync().get();
        if (ethGasPrice == null) {
            throw new RuntimeException("failed to get gas price!");
        }
        return ethGasPrice.getGasPrice();
    }

    public static long getChainId(Web3j web3j) throws IOException {
        return ((EthChainId)web3j.ethChainId().send()).getChainId().longValue();
    }

    private static BigInteger getTransactionGasLimit(Transaction transaction, Web3j web3j) {
        BigInteger gasLimit = BigInteger.ZERO;
        try {
            EthEstimateGas ethEstimateGas = (EthEstimateGas)web3j.ethEstimateGas(transaction).send();
            gasLimit = ethEstimateGas.getAmountUsed();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return gasLimit;
    }
}

