/*
 * Decompiled with CFR 0.152.
 */
package org.zkovari.changelog.gradle.api.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.zkovari.changelog.core.collector.ChangelogEntriesFileCollector;
import org.zkovari.changelog.core.generator.ChangelogGenerator;
import org.zkovari.changelog.core.parser.ChangelogEntriesParser;
import org.zkovari.changelog.core.parser.ChangelogParserException;
import org.zkovari.changelog.core.processor.ChangelogEntriesProcessor;
import org.zkovari.changelog.core.processor.InvalidChangelogEntryException;
import org.zkovari.changelog.domain.ChangelogEntry;
import org.zkovari.changelog.domain.Release;

public class ProcessChangelogEntries
extends DefaultTask {
    private File inputDirectory;
    private File outputfile;

    @InputDirectory
    public File getInputDirectory() {
        return this.inputDirectory;
    }

    public void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    @OutputFile
    public File getOutputfile() {
        return this.outputfile;
    }

    public void setOutputfile(File outputfile) {
        this.outputfile = outputfile;
    }

    @TaskAction
    public void process() {
        List<ChangelogEntry> entries = this.getEntries();
        Release release = this.processEntries(entries);
        String newChangelogContent = this.generate(release);
        this.write(newChangelogContent);
        this.clean();
    }

    private List<ChangelogEntry> getEntries() {
        List entries;
        ChangelogEntriesParser parser = new ChangelogEntriesParser();
        try {
            entries = parser.parse(this.inputDirectory);
        }
        catch (ChangelogParserException ex) {
            throw new GradleException("Could not parse new changelog entries under " + this.inputDirectory + ". Reason: " + ex.getMessage(), (Throwable)ex);
        }
        return entries;
    }

    private Release processEntries(List<ChangelogEntry> entries) {
        ChangelogEntriesProcessor processor = new ChangelogEntriesProcessor();
        try {
            return processor.processChangelogs(entries, this.getProject().getVersion().toString());
        }
        catch (InvalidChangelogEntryException ex) {
            throw new GradleException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String generate(Release release) {
        ChangelogGenerator generator = new ChangelogGenerator();
        if (this.outputfile.exists()) {
            try {
                byte[] fileContentInBytes = Files.readAllBytes(this.outputfile.toPath());
                return generator.generate(new String(fileContentInBytes), release);
            }
            catch (IOException ex) {
                throw new GradleException("Could not read file: " + this.outputfile, (Throwable)ex);
            }
        }
        return generator.generate("", release);
    }

    private void write(String newChangelogContent) {
        try {
            Files.write(this.outputfile.toPath(), newChangelogContent.getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new GradleException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void clean() {
        List files;
        ChangelogEntriesFileCollector collector = new ChangelogEntriesFileCollector();
        try {
            files = collector.collect(this.inputDirectory);
        }
        catch (IOException ex) {
            throw new GradleException("Could not collect changelog entries to clean them up", (Throwable)ex);
        }
        for (File file : files) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException ex) {
                throw new GradleException("Could not delete file: " + file, (Throwable)ex);
            }
        }
    }
}

